/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_xmlschema_objects
extends FilterableCheck {
    public has_xmlschema_objects() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("SCHEMA_URL").objectTypeFixed("XML SCHEMA").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasDbaXmlSchemas = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_XML_SCHEMAS").build());
        if (hasDbaXmlSchemas) {
            String unionSystemOwned = "";
            if (exeCtx.hasOracleMaintained() && exeCtx.getAnalysisMode() == AnalysisMode.FULL) {
                unionSystemOwned = " UNION  SELECT S.OWNER, S.SCHEMA_URL FROM SYS.DBA_XML_SCHEMAS S, SYS.DBA_OBJECTS O   WHERE S.INT_OBJNAME = O.OBJECT_NAME     AND S.OWNER IN ('SYSTEM')     AND O.ORACLE_MAINTAINED='N' ";
            }
            String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
            String sqlQuery = "SELECT OWNER, SCHEMA_URL FROM ( SELECT S.OWNER, S.SCHEMA_URL FROM SYS.DBA_XML_SCHEMAS S " + whereClause + unionSystemOwned + ") ORDER BY 1,2";
            this.setSqlQuery(sqlQuery);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "SYS.DBA_XML_SCHEMAS", "TABLE"), CheckResult.PASS);
        }
    }
}

