/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public abstract class has_sqlt_objects
extends FilterableCheck {
    protected has_sqlt_objects() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeColumn("OBJECT_TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String sqlQuery;
        if (exeCtx.getAnalysisMode() == AnalysisMode.FULL) {
            sqlQuery = "SELECT OWNER, OBJECT_NAME, OBJECT_TYPE FROM SYS.DBA_OBJECTS WHERE OWNER='SYS' AND OBJECT_NAME LIKE 'SQLT$%' UNION ALL SELECT USERNAME AS OWNER, USERNAME AS OBJECT_NAME, 'USER' AS OBJECT_TYPE FROM SYS.DBA_USERS WHERE USERNAME IN ('SQLTXPLAIN','SQLTXADMIN') UNION ALL SELECT GRANTEE AS OWNER, GRANTED_ROLE AS OBJECT_NAME, 'ROLE GRANT' AS OBJECT_TYPE FROM SYS.DBA_ROLE_PRIVS WHERE GRANTED_ROLE='SQLT_USER_ROLE' AND GRANTEE<>'SYS'";
        } else {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
            sqlQuery = "SELECT GRANTEE AS OWNER, GRANTED_ROLE AS OBJECT_NAME, 'ROLE GRANT' AS OBJECT_TYPE FROM SYS.DBA_ROLE_PRIVS " + whereClause + " AND GRANTED_ROLE='SQLT_USER_ROLE'";
        }
        this.setSqlQuery(sqlQuery);
    }
}

