/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class has_noexport_object_grants
extends Check
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_noexport_object_grants.class.getName());

    public has_noexport_object_grants() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        Version willExportVersion = Version.V21_1_0_0;
        String sourceVersion = exeCtx.getDatabaseVersion();
        if (willExportVersion.compare(sourceVersion) <= 0 && !exeCtx.isAutonomousTarget()) {
            String message = this.lang.txt("CHECK.HAS_NOEXPORT_OBJECT_GRANTS.SKIP_SUPPORTED_VERSION", willExportVersion.toString());
            this.skipCheck(message, CheckResult.PASS);
            return;
        }
        String restrictToSelect = "";
        if (willExportVersion.compare(sourceVersion) <= 0) {
            restrictToSelect = " AND PRIVILEGE = 'SELECT'";
        }
        try {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
            List<String> excludeSchemas = SqlUtils.getExcludedSchemaDefaults(exeCtx);
            if (!excludeSchemas.contains("SYS")) {
                excludeSchemas.add("SYS");
            }
            String dbaRolesClause = "";
            String usersCreatedObjectClause = ")";
            if (exeCtx.hasOracleMaintained()) {
                String whereRolesClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
                dbaRolesClause = " OR GRANTEE IN (SELECT ROLE FROM SYS.DBA_ROLES WHERE SYS.DBA_ROLES.ORACLE_MAINTAINED <> 'Y' AND ROLE IN (SELECT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS " + whereRolesClause + ")) ";
                if (exeCtx.getAnalysisMode() == AnalysisMode.SCHEMA) {
                    String whereUsernameClause = SqlUtils.createWhereNotInClause("USERNAME", exeCtx.getSourceSchemas());
                    usersCreatedObjectClause = " OR OWNER IN (SELECT USERNAME FROM SYS.DBA_USERS " + whereUsernameClause + " AND ORACLE_MAINTAINED <> 'Y' ))";
                }
            }
            String baseObjectPredicate = SqlUtils.createAndClause("OWNER", true, excludeSchemas);
            whereClause = whereClause.substring(0, whereClause.indexOf("WHERE") + 6) + " (" + whereClause.substring(whereClause.indexOf("WHERE") + 6);
            baseObjectPredicate = baseObjectPredicate.substring(0, baseObjectPredicate.indexOf("AND") + 4) + " (" + baseObjectPredicate.substring(baseObjectPredicate.indexOf("AND") + 4);
            String sqlQuery = "SELECT GRANTEE,  OWNER AS OBJECT_OWNER,  TABLE_NAME AS OBJECT_NAME,  PRIVILEGE AS PRIVILEGE,  GRANTOR  FROM SYS.DBA_TAB_PRIVS" + whereClause + " AND GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS) " + dbaRolesClause + ")" + restrictToSelect + " AND NOT (OWNER = 'SYS' AND TABLE_NAME LIKE 'QT%!_BUFFER' ESCAPE '!') " + baseObjectPredicate + usersCreatedObjectClause + " ORDER BY GRANTEE, OBJECT_OWNER, OBJECT_NAME, PRIVILEGE, GRANTOR";
            this.setSqlQuery(sqlQuery);
        }
        catch (SQLException e) {
            String msg = Utilities.getErrorText("ERROR2000", e, this.getName());
            log.severe(msg, e);
            this.skipCheck(msg, CheckResult.FATAL);
        }
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "create_object_grants";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPath = locus.getPathContribution() + File.separator + "create_object_grants" + ".sql";
        Fixup sqlFixup = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("create_object_grants").parentPath(parentFolderPath).relativeFilePath(relPath).build();
        try (FixupFileHelper fileHelper = new FixupFileHelper(this, sqlFixup);){
            ArrayList<String> dclStatements = new ArrayList<String>();
            for (Map<String, String> relevantObject : this.getRelevantObjectsData()) {
                String dcl = "GRANT " + has_noexport_object_grants.replaceSelectToReadPrivilege(relevantObject.get("PRIVILEGE"), exeCtx.isAutonomousTarget()) + " ON " + relevantObject.get("OBJECT_OWNER") + "." + relevantObject.get("OBJECT_NAME") + " TO " + relevantObject.get("GRANTEE") + ";";
                dclStatements.add(dcl);
            }
            fileHelper.writeFixupText(dclStatements, 1);
            this.addFixup(sqlFixup);
        }
        catch (Exception e) {
            String errorMsg = Utilities.getErrorText("ERROR3005", e, "create_object_grants", this.getName());
            Utilities.printAndLogErrorMessage(errorMsg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMsg, e);
        }
    }

    private static String replaceSelectToReadPrivilege(String privilege, boolean isAutonomousTarget) {
        if (isAutonomousTarget) {
            return "SELECT".equalsIgnoreCase(privilege) ? "READ" : privilege;
        }
        return privilege;
    }
}

