/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.vendors;

import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.CloudService;
import java.sql.SQLException;

public class OCI_ADB
extends CloudService {
    private TargetCloud serviceSubtype;

    public OCI_ADB() {
        this.setCloudVendor("Oracle Cloud Infrastructure");
        this.setServiceType("Autonomous Database");
        this.setQueryType(CloudService.QueryType.SINGLE_QUERY);
    }

    @Override
    public void prepare() {
        this.setCode("SELECT 'Y' IS_AUTONOMOUS FROM DBA_VIEWS WHERE VIEW_NAME ='OCI_AUTONOMOUS_DATABASES' AND ROWNUM = 1");
    }

    @Override
    public boolean determineResult(ExecutionContext exeCtx) throws SQLException {
        boolean result = super.determineResult(exeCtx);
        if (result) {
            this.setServiceSubtype(exeCtx.getLockdownProfile().toTargetCloud());
        }
        return result;
    }

    public TargetCloud getServiceSubtype() {
        return this.serviceSubtype;
    }

    public void setServiceSubtype(TargetCloud serviceSubtype) {
        this.serviceSubtype = serviceSubtype;
    }
}

