/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.redo;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RedoSize {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(RedoSize.class.getName());
    @HtmlProperty(labelKey="SRC_REDO_SIZE_INSTANCE_ID", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The instance identifier associated with the redo")
    private int instanceId;
    @HtmlProperty(labelKey="SRC_REDO_SIZE_SIZE_IN_KB", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Redo size in KB")
    private Long redoSizeInKB;
    @HtmlProperty(labelKey="SRC_REDO_SIZE_OPEN_TIME", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The date-time the analysis was done in ISO_DATE_TIME format. For example: 2023-12-15T08:43:41Z")
    private Date instanceOpenTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RedoSize> getRedoSizeData(ExecutionContext exeCtx) throws SQLException {
        ArrayList<RedoSize> redoSizeData = new ArrayList<RedoSize>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String redoSizeQuery = "SELECT   A.INST_ID AS INST_ID,   A.VALUE / 1024 AS REDO_SIZE_IN_KB,   B.STARTUP_TIME AS STARTUP_TIME FROM GV$SYSSTAT A,   GV$INSTANCE B  WHERE A.INST_ID=B.INST_ID   AND A.NAME = 'redo size'   ORDER BY 1";
        try {
            log.fine("Fetching Redo size data with query: SELECT   A.INST_ID AS INST_ID,   A.VALUE / 1024 AS REDO_SIZE_IN_KB,   B.STARTUP_TIME AS STARTUP_TIME FROM GV$SYSSTAT A,   GV$INSTANCE B  WHERE A.INST_ID=B.INST_ID   AND A.NAME = 'redo size'   ORDER BY 1");
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   A.INST_ID AS INST_ID,   A.VALUE / 1024 AS REDO_SIZE_IN_KB,   B.STARTUP_TIME AS STARTUP_TIME FROM GV$SYSSTAT A,   GV$INSTANCE B  WHERE A.INST_ID=B.INST_ID   AND A.NAME = 'redo size'   ORDER BY 1");
            rs = stmt.executeQuery();
            while (rs.next()) {
                int instanceId = rs.getInt("INST_ID");
                long redoSizeInKB = rs.getLong("REDO_SIZE_IN_KB");
                java.sql.Date startupTime = rs.getDate("STARTUP_TIME");
                RedoSize redoSize = new RedoSize(instanceId, redoSizeInKB, startupTime);
                redoSizeData.add(redoSize);
            }
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return redoSizeData;
    }

    public static RedoSize createEmptyRedoSizeInstance() {
        return new RedoSize(0, 0L, new Date());
    }

    private RedoSize(int instanceId, Long redoSizeInKB, Date instanceOpenTime) {
        this.instanceId = instanceId;
        this.redoSizeInKB = redoSizeInKB;
        this.instanceOpenTime = instanceOpenTime;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public Long getRedoSizeInKB() {
        return this.redoSizeInKB;
    }

    public Date getInstanceOpenTime() {
        return this.instanceOpenTime;
    }
}

