/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.redo.RedoHistory;
import com.oracle.premigration.dbinspector.addinform.redo.RedoSize;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;

public final class RedoData {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(RedoData.class.getName());
    @HtmlProperty(labelKey="SRC_LOG_MODE", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The LOG_MODE from V$DATABASE; typically ARCHIVELOG or NOARCHIVELOG")
    private final String logMode;
    @HtmlProperty(labelKey="SRC_REDO_SIZE_INFO", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="GV$SYSSTAT Redo size information")
    private final List<RedoSize> sysStatRedoSize;
    @HtmlProperty(labelKey="SRC_REDO_HISTORY_INFO", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Redo history data")
    private final List<RedoHistory> redoHistory;

    public static RedoData getRedoData(ExecutionContext exeCtx) {
        RedoData redoData = null;
        long startFetchingRedoInfo = System.currentTimeMillis();
        try {
            String logMode = SqlUtils.getSingleString("SELECT LOG_MODE FROM V$DATABASE", exeCtx);
            List<RedoHistory> redoHistory = RedoHistory.getRedoHistory(exeCtx);
            List<RedoSize> redoSizes = RedoSize.getRedoSizeData(exeCtx);
            redoData = new RedoData(logMode, redoSizes, redoHistory);
        }
        catch (SQLException e) {
            String errorMessage = Utilities.getErrorText("ERROR2011", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, exeCtx.getEnvCtx(), Level.WARNING, e);
        }
        log.info("Elapsed time fetching Redo information: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startFetchingRedoInfo));
        return redoData;
    }

    public String getLogMode() {
        return this.logMode;
    }

    public List<RedoSize> getSysStatRedoSize() {
        return this.sysStatRedoSize;
    }

    public List<RedoHistory> getRedoHistory() {
        return this.redoHistory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedoData)) {
            return false;
        }
        RedoData other = (RedoData)o;
        String this$logMode = this.getLogMode();
        String other$logMode = other.getLogMode();
        if (this$logMode == null ? other$logMode != null : !this$logMode.equals(other$logMode)) {
            return false;
        }
        List<RedoSize> this$sysStatRedoSize = this.getSysStatRedoSize();
        List<RedoSize> other$sysStatRedoSize = other.getSysStatRedoSize();
        if (this$sysStatRedoSize == null ? other$sysStatRedoSize != null : !((Object)this$sysStatRedoSize).equals(other$sysStatRedoSize)) {
            return false;
        }
        List<RedoHistory> this$redoHistory = this.getRedoHistory();
        List<RedoHistory> other$redoHistory = other.getRedoHistory();
        return !(this$redoHistory == null ? other$redoHistory != null : !((Object)this$redoHistory).equals(other$redoHistory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logMode = this.getLogMode();
        result = result * 59 + ($logMode == null ? 43 : $logMode.hashCode());
        List<RedoSize> $sysStatRedoSize = this.getSysStatRedoSize();
        result = result * 59 + ($sysStatRedoSize == null ? 43 : ((Object)$sysStatRedoSize).hashCode());
        List<RedoHistory> $redoHistory = this.getRedoHistory();
        result = result * 59 + ($redoHistory == null ? 43 : ((Object)$redoHistory).hashCode());
        return result;
    }

    public String toString() {
        return "RedoData(logMode=" + this.getLogMode() + ", sysStatRedoSize=" + this.getSysStatRedoSize() + ", redoHistory=" + this.getRedoHistory() + ")";
    }

    public RedoData(String logMode, List<RedoSize> sysStatRedoSize, List<RedoHistory> redoHistory) {
        this.logMode = logMode;
        this.sysStatRedoSize = sysStatRedoSize;
        this.redoHistory = redoHistory;
    }
}

