/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.SQLException;

public abstract class InstalledPackage {
    @CpatJsonPropertyDescription(value="The name of package installed in the source instance")
    private String packageName;
    @CpatJsonIgnore
    private String sqlQuery;

    public abstract void prepare();

    public boolean determineIfPackageIsInstalled(ExecutionContext exeCtx) throws SQLException {
        String sql = this.getSqlQuery();
        String result = SqlUtils.getSingleString(sql, exeCtx);
        return result != null && !result.isEmpty() && "Y".equalsIgnoreCase(result);
    }

    public String toString() {
        return "InstalledPackage(packageName=" + this.getPackageName() + ", sqlQuery=" + this.getSqlQuery() + ")";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    @CpatJsonIgnore
    public String getSqlQuery() {
        return this.sqlQuery;
    }
}

