/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.ResultSetProcessor;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.filters.FilterCriteria;
import com.oracle.premigration.reports.filters.RelevantObjectFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class FilterableCheck
extends Check
implements RelevantObjectFilter {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(FilterableCheck.class.getName());

    protected FilterableCheck() {
        this.initFiltrationMetadata();
    }

    public abstract void initFiltrationMetadata();

    @Override
    public boolean acceptRelevantObject(Map<String, String> relevantObject, FilterCriteria filterCriteria) {
        String dataType;
        String owner = relevantObject.get(this.getFiltrationMetadata().getSchemaOwnerColumn());
        String name = relevantObject.get(this.getFiltrationMetadata().getObjectNameColumn());
        String string = dataType = this.getFiltrationMetadata().getObjectTypeFixed().length() != 0 ? this.getFiltrationMetadata().getObjectTypeFixed() : relevantObject.get(this.getFiltrationMetadata().getObjectTypeColumn());
        if (owner == null || name == null || dataType == null) {
            String errorText = "Unexpected null value in acceptRelevantObject: " + relevantObject.toString() + ", filtrationMetadata: " + this.getFiltrationMetadata().toString();
            log.severe(errorText);
            throw new IllegalArgumentException(errorText);
        }
        return filterCriteria.include(owner, name, dataType);
    }

    @Override
    public List<Map<String, String>> resultSetToListMap(ResultSet rs, ExecutionContext exeCtx) throws SQLException {
        ResultSetProcessor.RSProcessorInputs inputs = ResultSetProcessor.RSProcessorInputs.builder().resultSet(rs).maxRelevantObjects(exeCtx.getParsedArgs().getMaxRelevantObjects()).filter(this).filterCriteria(exeCtx.getFilterCriteria()).build();
        ResultSetProcessor.RSProcessorOutputs outputs = ResultSetProcessor.processResultSet(inputs);
        this.setOmittedFilteredObjectsCount(outputs.getOmittedFilteredObjectsCount());
        this.setFilteredObjectsData(outputs.getFilteredObjects());
        return outputs.getRelevantObjects();
    }
}

