/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.extension.apex.utility.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.jdbc.OracleCallableStatement;

public class APEXExport {
    private static OutputStream _out;
    private Connection _gConn;
    private boolean _noFileStoreClob = false;
    private final LinkedHashMap<String, RowDetails> _clobData = new LinkedHashMap();
    ScriptRunnerContext _ctx;

    private static void write(Object o) throws IOException, OutputBufferNotInitialized {
        if (_out == null || o == null) {
            throw new OutputBufferNotInitialized();
        }
        _out.write(o.toString().getBytes("UTF8"));
        _out.write("\n".getBytes("UTF8"));
        _out.flush();
    }

    public APEXExport() {
        this._noFileStoreClob = false;
    }

    public APEXExport(boolean noFileStoreClob) {
        this._noFileStoreClob = noFileStoreClob;
    }

    public void doCapture() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getBool("expworkspace")) {
            if (this.getDec("workspaceid") != null) {
                this.ExportWorkspace();
            } else {
                this.ExportAllWorkspaces();
            }
        } else if (this.getBool("expfeedback")) {
            this.ExportFeedback();
        } else if (this.getBool("expfiles")) {
            this.ExportStaticFiles();
        } else if (this.getBool("list")) {
            this.List();
        } else if (this.getBool("instance")) {
            this.ExportInstance();
        } else if (this.getDec("workspaceid") != null) {
            this.ExportAllApplications();
        } else {
            this.ExportApplication(false);
        }
    }

    public void ExportAllApplications() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_ALL_APPLICATIONS);
        }
        if (this.getString("workspaceid") == null || "".equals(this.getString("workspaceid"))) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_WORKSPACE"));
        }
        PreparedStatement stmt = this._gConn.prepareStatement(QueryUtils.getXMLQueries().getQuery("gStmt2", this._gConn).getSql());
        stmt.setBigDecimal(1, this.getDec("workspaceid"));
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "applicationid", (Object)result.getBigDecimal(1));
            this.ExportApplication(true);
        }
        result.close();
        stmt.close();
    }

    public void ExportAllWorkspaces() throws SQLException, IOException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_ALL_WORKSPACES);
        }
        String wkspName = null;
        PreparedStatement stmt = this._gConn.prepareStatement(QueryUtils.getXMLQueries().getQuery("gStmtWorkspaces", this._gConn).getSql());
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            BigDecimal wkspID = result.getBigDecimal(1);
            wkspName = result.getString(2);
            this._ctx.getParameterInstance().putParameter("apex.parms", "workspaceid", (Object)wkspID);
            this._ctx.getParameterInstance().putParameter("apex.parms", "workspacename", (Object)wkspName);
            this.ExportWorkspace();
        }
        result.close();
        stmt.close();
    }

    public void ExportApplication(boolean expPkgAppMapping) throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_APPLICATION);
        }
        QueryUtils.loadAppDetail(this._gConn, this._ctx, this.getDec("applicationid"));
        APEXExport.write("Exporting Workspace " + this.getString("workspacename") + " - application " + this.getString("applicationid") + ":" + this.getString("applicationname"));
        String p_stmt = QueryUtils.getXMLQueries().getQuery("apex.export.v" + this.getApiVersion(this._gConn), this._gConn).getSql();
        OracleCallableStatement l_stmt = this.getExportStmt(p_stmt);
        l_stmt.setBigDecimal(2, this.getDec("applicationid"));
        this.bind_yn(l_stmt, 3, this.getBool("split"));
        this.bind_yn(l_stmt, 4, !this.getBool("skipexportdate"));
        this.bind_yn(l_stmt, 5, this.getBool("exppubreports"));
        this.bind_yn(l_stmt, 6, this.getBool("expsavedreports"));
        this.bind_yn(l_stmt, 7, this.getBool("expirnotif"));
        this.bind_yn(l_stmt, 8, this.getBool("exptranslations"));
        this.bind_yn(l_stmt, 9, expPkgAppMapping);
        this.bind_yn(l_stmt, 10, this.getBool("exporiginalids"));
        this.bind_yn(l_stmt, 11, this.getBool("expnosubscriptions"));
        this.bind_yn(l_stmt, 12, this.getBool("expcomments"));
        l_stmt.setString(13, this.getString("expsupportingobjects"));
        this.bind_yn(l_stmt, 14, this.getBool("expaclassignments"));
        if (this.getApiVersion(this._gConn) > 1) {
            if (this.getString("expcomponents") != null) {
                String cleaned = this.getString("expcomponents").replaceAll("^\"|\"$", "");
                l_stmt.setString(15, cleaned);
            } else {
                l_stmt.setString(15, "");
            }
        }
        if (this.getApiVersion(this._gConn) > 2) {
            l_stmt.setString(16, this.getString("exptype"));
        }
        this.handle_write_or_save(l_stmt);
    }

    public void ExportComponents() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_COMPONENTS);
        }
        this.ExportApplication(false);
    }

    public void ExportFeedback() throws SQLException, IOException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_FEEDBACK);
        }
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_feedback (\n             p_workspace_id      => ?,\n             p_with_date         => ?='Y',\n             p_since             => ?,\n             p_deployment_system => ? );\nend;");
        boolean hasRows = false;
        String wkspName = null;
        if (this.getDec("workspaceid") != null && this.getDec("workspaceid").longValue() != 0L) {
            String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspaceFeedback", this._gConn).getSql();
            PreparedStatement stmt = this._gConn.prepareStatement(sql);
            stmt.setBigDecimal(1, this.getDec("workspaceid"));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                hasRows = true;
                wkspName = result.getString(1);
                APEXExport.write("Exporting Feedback for Workspace " + this.getDec("workspaceid") + ":'" + wkspName + "' ");
                l_stmt.setBigDecimal(2, this.getDec("workspaceid"));
                this.bind_yn(l_stmt, 3, !this.getBool("skipexportdate"));
                l_stmt.setDate(4, this.getDate("expfeedbacksince"));
                l_stmt.setString(5, this.getString("deploymentsystem"));
                this.handle_write_or_save(l_stmt);
            }
            if (!hasRows) {
                APEXExport.write("No data found meeting your query");
            }
            result.close();
            stmt.close();
        } else {
            wkspName = null;
            String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspacesFeedbacks", this._gConn).getSql();
            PreparedStatement stmt = this._gConn.prepareStatement(sql);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                hasRows = true;
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                APEXExport.write("Exporting Feedback for Workspace " + wkspID + ":'" + wkspName + "' ");
                l_stmt.setBigDecimal(2, this.getDec("workspaceid"));
                this.bind_yn(l_stmt, 3, !this.getBool("skipexportdate"));
                l_stmt.setDate(4, this.getDate("expfeedbacksince"));
                l_stmt.setString(5, this.getString("deploymentsystem"));
                this.handle_write_or_save(l_stmt);
            }
            if (!hasRows) {
                APEXExport.write("No data found meeting your query");
            }
            result.close();
            stmt.close();
        }
    }

    public void ExportInstance() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_INSTANCE);
        }
        String sql = QueryUtils.getXMLQueries().getQuery("gStmtInstance", this._gConn).getSql();
        PreparedStatement stmt = this._gConn.prepareStatement(sql);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "workspaceid", (Object)result.getBigDecimal(1));
            this._ctx.getParameterInstance().putParameter("apex.parms", "applicationid", (Object)result.getBigDecimal(2));
            this._ctx.getParameterInstance().putParameter("apex.parms", "workspacename", (Object)result.getString(3));
            this._ctx.getParameterInstance().putParameter("apex.parms", "applicationname", (Object)result.getString(4));
            this.ExportApplication(true);
        }
    }

    public void ExportStaticFiles() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_STATIC_FILES);
        }
        if (this.getString("workspaceid") == null || "".equals(this.getString("workspaceid"))) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_WORKSPACE"));
        }
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_workspace_files (\n             p_workspace_id          => ?,\n             p_with_date             => ?='Y' );\nend;");
        l_stmt.setBigDecimal(2, this.getDec("workspaceid"));
        this.bind_yn(l_stmt, 3, !this.getBool("skipexportdate"));
        this.handle_write_or_save(l_stmt);
    }

    public void ExportWorkspace() throws SQLException, IOException, OutputBufferNotInitialized {
        if (this.getString("exportType") == null || "".equals(this.getString("exportType"))) {
            this._ctx.getParameterInstance().putParameter("apex.parms", "exportType", (Object)ApexOptions.EXP_WORKSPACE);
        }
        HashMap<String, String> binds = new HashMap<String, String>();
        DBUtil dbUtil = DBUtil.getInstance((Connection)this._gConn);
        binds.put("ID", this.getString("workspaceid"));
        String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspace", this._gConn).getSql();
        String wName = dbUtil.executeOracleReturnOneCol(sql, binds);
        APEXExport.write("Exporting Workspace " + this.getDec("workspaceid") + ":'" + wName + "' ");
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_workspace (\n             p_workspace_id          => ?,\n             p_with_team_development => ?='Y',\n             p_with_misc             => ?='Y',\n             p_with_date             => ?='Y' );\nend;");
        l_stmt.setBigDecimal(2, this.getDec("workspaceid"));
        this.bind_yn(l_stmt, 3, this.getBool("expteamdevdata"));
        this.bind_yn(l_stmt, 4, !this.getBool("expminimal"));
        this.bind_yn(l_stmt, 5, !this.getBool("skipexportdate"));
        this.handle_write_or_save(l_stmt);
    }

    public LinkedHashMap<String, RowDetails> getResults() {
        return this._clobData;
    }

    public void List() throws SQLException, IOException, OutputBufferNotInitialized {
        PreparedStatement stmt;
        String sql;
        PrintStream ps = new PrintStream(_out);
        if (this.getDec("applicationid") != null) {
            sql = QueryUtils.getXMLQueries().getQuery("gStmtListCompChanges", this._gConn).getSql();
            stmt = this._gConn.prepareStatement(sql);
            stmt.setBigDecimal(1, this.getDec("applicationid"));
        } else {
            sql = QueryUtils.getXMLQueries().getQuery("gStmtListAppChanges", this._gConn).getSql();
            stmt = this._gConn.prepareStatement(sql);
            stmt.setBigDecimal(1, this.getDec("workspaceid"));
        }
        stmt.setString(2, this.getString("changessince"));
        stmt.setString(3, this.getString("changessince"));
        stmt.setString(4, this.getString("changesby"));
        stmt.setString(5, this.getString("changesby"));
        ResultSet result = stmt.executeQuery();
        APEXExport.write("Date             ID                                      Name");
        APEXExport.write("---------------- --------------------------------------- -----------------------");
        while (result.next()) {
            String d = result.getString(1);
            String id = result.getString(2);
            String name = result.getString(3);
            ps.printf("%s %-39s %s\n", d, id, name);
        }
        stmt.close();
    }

    public void setConnection(Connection conn) {
        this._gConn = conn;
    }

    public void setCtx(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public void setCWD(String cwd) {
    }

    public void setOutStream(OutputStream out) {
        _out = out;
    }

    private void bind_yn(OracleCallableStatement p_stmt, int p_pos, boolean p_val) throws SQLException {
        p_stmt.setString(p_pos, p_val ? "Y" : "N");
    }

    private int getApiVersion(Connection conn) {
        String version = DBUtil.getInstance((Connection)conn).executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        String cleanversion = version.replaceAll("-", "");
        Version source = new Version(cleanversion);
        if (source.compareTo(new Version("19.2")) < 0) {
            return 1;
        }
        if (source.compareTo(new Version("20.1")) > 0) {
            return 3;
        }
        return 2;
    }

    private void exec_and_save_files(OracleCallableStatement p_stmt) throws SQLException, IOException, OutputBufferNotInitialized {
        Object[] l_result;
        java.util.Date now;
        if (this.getBool("debug")) {
            now = new java.util.Date();
            APEXExport.write("  Start " + now);
        }
        p_stmt.execute();
        for (Object l_tmp : l_result = (Object[])((Array)p_stmt.getObject(1)).getArray()) {
            Struct l_rec = (Struct)l_tmp;
            if (this.getBool("debug")) {
                APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            Object l_name = (String)l_rec.getAttributes()[0];
            if (this.getString("dir") != null && this.getString("dir") != "") {
                l_name = this.getString("dir").replaceAll("/$", "") + "/" + (String)l_name;
            }
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            this._clobData.put((String)l_name, new RowDetails((String)l_name, l_contents.getSubString(1L, (int)l_contents.length()), this.getString("applicationid"), this.getString("workspaceid"), this.getString("applicationname"), this.getString("workspacename"), this.getString("override-app-schema"), this.getString("override-app-alias"), this.getString("override-app-id"), this.getString("override-app-workspace")));
        }
        p_stmt.close();
        if (this.getBool("debug")) {
            now = new java.util.Date();
            APEXExport.write("  Completed at " + now);
        }
    }

    private void exec_and_write_files(OracleCallableStatement p_stmt) throws SQLException, IOException, OutputBufferNotInitialized {
        Object[] l_result;
        java.util.Date now;
        Object l_name = null;
        if (this.getBool("debug")) {
            now = new java.util.Date();
            APEXExport.write("  Start " + now);
        }
        p_stmt.execute();
        for (Object l_tmp : l_result = (Object[])((Array)p_stmt.getObject(1)).getArray()) {
            Struct l_rec = (Struct)l_tmp;
            if (this.getBool("debug")) {
                APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            l_name = (String)l_rec.getAttributes()[0];
            if (this.getString("dir") != null && this.getString("dir") != "") {
                l_name = this.getString("dir").replaceAll("/$", "") + "/" + (String)l_name;
            }
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            ApexUtil.writeFile(this._ctx, (String)l_name, l_contents.getSubString(1L, (int)l_contents.length()));
        }
        p_stmt.close();
        APEXExport.write("File " + l_name + " created");
        if (this.getBool("debug")) {
            now = new java.util.Date();
            APEXExport.write("  Completed at " + now);
        }
    }

    private boolean getBool(String name) {
        try {
            return Boolean.parseBoolean(this.getString(name));
        }
        catch (Exception e) {
            return false;
        }
    }

    private Date getDate(String name) {
        try {
            return (Date)new SimpleDateFormat("yyyy-MM-dd").parse(this.getString(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    private BigDecimal getDec(String name) {
        try {
            if (this.getString(name) != null) {
                return BigDecimal.valueOf(Long.parseLong(this.getString(name)));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private OracleCallableStatement getExportStmt(String p_stmt) throws SQLException {
        if (this.getBool("debug")) {
            try {
                APEXExport.write("  " + p_stmt.replace("\n", "\n  "));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OracleCallableStatement l_stmt = (OracleCallableStatement)this._gConn.prepareCall(p_stmt);
        l_stmt.registerOutParameter(1, 2003, "PUBLIC.APEX_T_EXPORT_FILES");
        return l_stmt;
    }

    private String getString(String name) {
        return this._ctx.getParameterInstance().getParameterAsString("apex.parms", name);
    }

    private void handle_write_or_save(OracleCallableStatement p_stmt) throws SQLException, IOException, OutputBufferNotInitialized {
        if (this._noFileStoreClob) {
            this.exec_and_save_files(p_stmt);
        } else {
            this.exec_and_write_files(p_stmt);
        }
    }

    public class RowDetails {
        String fileName;
        String contents;
        String appId;
        String workId;
        String appName;
        String workName;
        String override_schema;
        String override_alias;
        String override_appid;
        String override_workspace;

        public RowDetails(String fName, String contents, String appId, String workId, String appName, String workName, String override_schema, String override_alias, String override_appid, String override_workspace) {
            this.fileName = fName;
            this.contents = contents;
            this.appId = appId;
            this.workId = workId;
            this.appName = appName;
            this.workName = workName;
            this.override_schema = override_schema;
            this.override_alias = override_alias;
            this.override_appid = override_appid;
            this.override_workspace = override_workspace;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getContents() {
            return this.contents;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getWorkId() {
            return this.workId;
        }

        public String getWorkName() {
            return this.workName;
        }

        public String getOverrideSchema() {
            return this.override_schema;
        }

        public String getOverrideAlias() {
            return this.override_alias;
        }

        public String getOverrideAppId() {
            return this.override_appid;
        }

        public String getOverrideWorkspace() {
            return this.override_workspace;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        public void setContent(String content) {
            this.contents = content;
        }
    }
}

