/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.json.common.LobInputStream;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;
import oracle.json.util.LimitedInputStream;
import oracle.soda.OracleBatchException;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentFragmentImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;

public class TableCollectionImpl
extends OracleCollectionImpl {
    private static final int MAX_RANGE_TRANSFER = 0x100000;
    private static final int MIN_RANGE_TRANSFER = 4096;
    private static final int BATCH_MAX_SIZE = 100;
    private static final int SEQUENCE_BATCH_SIZE = 10;
    private final long[] seqCache = new long[100];
    private int seqCacheAvail = 0;
    private int seqCachePos = 0;

    TableCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        super(oracleDatabaseImpl, string);
    }

    TableCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        super(oracleDatabaseImpl, string, collectionDescriptor);
    }

    private String buildSelectForUpsert(String string) {
        this.sb.setLength(0);
        boolean bl = false;
        if (this.options.creationColumnName != null) {
            this.sb.append("select ");
            if (string != null) {
                this.sb.append("/*+ " + string + " */ ");
            }
            this.sb.append("\"" + this.options.creationColumnName);
            this.sb.append('\"');
            bl = true;
        }
        if (this.returnVersion()) {
            if (bl) {
                this.sb.append(", \"");
            } else {
                this.sb.append("select \"");
            }
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.addFrom(this.sb);
        this.addWhereKey(this.sb, false);
        return this.sb.toString();
    }

    boolean returnVersion() {
        return this.options.versionColumnName != null && (this.options.versioningMethod == 0 || this.options.versioningMethod == 2);
    }

    private String buildQuery() {
        this.sb.setLength(0);
        this.sb.append("select ");
        switch (this.options.keyDataType) {
            case 3: {
                this.sb.append("to_char(\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\")");
                break;
            }
            case 4: {
                this.sb.append("rawtohex(\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\")");
                break;
            }
            case 1: 
            case 2: {
                this.sb.append("\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\"");
            }
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\"");
        }
        this.sb.append(",\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append('\"');
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append('\"');
        }
        if (this.options.versionColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.addFrom(this.sb);
        this.addWhereKey(this.sb, false);
        return this.sb.toString();
    }

    private void addFrom(StringBuilder stringBuilder) {
        stringBuilder.append(" from \"");
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    private boolean returnInsertedTime() {
        return this.options.timestampColumnName != null || this.options.creationColumnName != null;
    }

    private boolean returnInsertedKey() {
        return this.options.keyAssignmentMethod == 3 || this.options.keyAssignmentMethod == 7 || this.options.keySequenceName != null;
    }

    private boolean returnInsertedVersion() {
        return this.options.versionColumnName != null && this.options.versioningMethod == 0;
    }

    private boolean insertHasReturnClause(boolean bl) {
        return !bl && (this.returnInsertedKey() || this.returnInsertedTime() || this.returnInsertedVersion());
    }

    static void addInto(StringBuilder stringBuilder, int n) {
        if (n > 0) {
            stringBuilder.append(" into ?");
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(", ?");
            }
        }
    }

    static void addComma(StringBuilder stringBuilder, int n) {
        if (n > 0) {
            stringBuilder.append(", ");
        }
    }

    private String buildInsert(boolean bl, String string, Boolean bl2) {
        this.sb.setLength(0);
        if (this.insertHasReturnClause(bl) && this.useCallableReturns) {
            this.sb.append("begin\n");
        }
        this.sb.append("insert");
        if (string != null) {
            this.sb.append(" /*+ " + string + " */");
        }
        this.sb.append(" into ");
        this.appendTable(this.sb);
        this.sb.append(" (\"");
        if (this.options.keyAssignmentMethod != 7) {
            this.sb.append(this.options.keyColumnName);
            this.sb.append("\",\"");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\",\"");
        }
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\"");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\"");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.sb.append(") values (");
        if (this.options.keySequenceName != null && !bl) {
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL");
                    break;
                }
                case 4: {
                    this.sb.append("hextoraw(substr(to_char(\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL,'0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'),3))");
                    break;
                }
                default: {
                    this.sb.append("to_char(\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL)");
                    break;
                }
            }
        } else if (this.options.keyAssignmentMethod == 3 && !bl) {
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("to_number(");
                    this.sb.append("rawtohex(SYS_GUID()),");
                    this.sb.append("'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')");
                    break;
                }
                case 4: {
                    this.sb.append("SYS_GUID()");
                    break;
                }
                default: {
                    this.sb.append("rawtohex(SYS_GUID())");
                    break;
                }
            }
        } else if (this.options.keyAssignmentMethod != 7) {
            this.addKey(this.sb);
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",?");
        }
        if (bl2.booleanValue()) {
            if (this.options.hasBinaryFormat()) {
                this.sb.append(",OSON(? EXTENDED)");
            } else if (this.options.hasJsonType()) {
                this.sb.append(",JSON(? EXTENDED)");
            }
        } else if (this.options.keyAssignmentMethod == 7) {
            this.sb.append("?");
        } else {
            this.sb.append(",?");
        }
        if (this.options.timestampColumnName != null) {
            if (bl) {
                OracleDatabaseImpl.addToTimestamp(",", this.sb);
            } else {
                this.sb.append(",sys_extract_utc(SYSTIMESTAMP)");
            }
        }
        if (this.options.creationColumnName != null) {
            if (bl) {
                OracleDatabaseImpl.addToTimestamp(",", this.sb);
            } else {
                this.sb.append(",sys_extract_utc(SYSTIMESTAMP)");
            }
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",?");
        }
        this.sb.append(")");
        if (this.insertHasReturnClause(bl)) {
            this.sb.append(" returning ");
            int n = 0;
            if (this.returnInsertedKey()) {
                if (this.options.isDualityView()) {
                    this.sb.append("json_value(data, '$._id') ");
                } else {
                    this.sb.append("\"");
                    this.sb.append(this.options.keyColumnName);
                    this.sb.append("\"");
                }
                ++n;
            }
            if (this.returnInsertedTime()) {
                TableCollectionImpl.addComma(this.sb, n);
                this.sb.append("\"");
                if (this.options.timestampColumnName != null) {
                    this.sb.append(this.options.timestampColumnName);
                } else {
                    this.sb.append(this.options.creationColumnName);
                }
                this.sb.append('\"');
                ++n;
            }
            if (this.returnInsertedVersion()) {
                TableCollectionImpl.addComma(this.sb, n);
                if (this.options.isDualityView()) {
                    this.sb.append("json_value(data, '$._etag') ");
                } else {
                    this.sb.append("\"");
                    this.sb.append(this.options.versionColumnName);
                    this.sb.append("\"");
                }
                ++n;
            }
            if (this.useCallableReturns) {
                TableCollectionImpl.addComma(this.sb, n);
                this.sb.append("'1'");
                ++n;
            }
            TableCollectionImpl.addInto(this.sb, n);
        }
        if (this.insertHasReturnClause(bl) && this.useCallableReturns) {
            this.sb.append(";\nend;\n");
        }
        return this.sb.toString();
    }

    private void addWhereKey(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(" where \"");
        stringBuilder.append(this.options.keyColumnName);
        stringBuilder.append(bl ? "\" > " : "\" = ");
        this.addKey(stringBuilder);
    }

    void addKey(StringBuilder stringBuilder) {
        switch (this.options.keyDataType) {
            case 3: {
                stringBuilder.append("to_number(?)");
                break;
            }
            case 4: {
                stringBuilder.append("?");
                break;
            }
            default: {
                stringBuilder.append("?");
            }
        }
    }

    private String buildUpsert(String string) {
        this.sb.setLength(0);
        this.sb.append("merge ");
        if (string != null) {
            this.sb.append("/*+ " + string + " */ ");
        }
        this.sb.append("into ");
        this.appendTable(this.sb);
        this.sb.append(" JSON$TARGET using (select ");
        this.sb.append(" ? \"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\" from SYS.DUAL) JSON$SOURCE");
        this.sb.append(" on (JSON$TARGET.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\" = JSON$SOURCE.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\")");
        this.sb.append(" when matched then update set JSON$TARGET.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\" = ?");
        if (this.options.timestampColumnName != null) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.timestampColumnName);
            OracleDatabaseImpl.addToTimestamp("\" = ", this.sb);
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\" = ");
            if (this.options.versioningMethod == 2) {
                this.sb.append("(JSON$TARGET.\"");
                this.sb.append(this.options.versionColumnName);
                this.sb.append("\" + 1)");
            } else {
                this.sb.append("?");
            }
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\" = ?");
        }
        this.sb.append(" when not matched then insert (JSON$TARGET.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\",JSON$TARGET.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\"");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\"");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\"");
        }
        this.sb.append(") values (?,?");
        if (this.options.timestampColumnName != null) {
            OracleDatabaseImpl.addToTimestamp(",", this.sb);
        }
        if (this.options.creationColumnName != null) {
            OracleDatabaseImpl.addToTimestamp(",", this.sb);
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",?");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",?");
        }
        this.sb.append(")");
        return this.sb.toString();
    }

    void setStreamBind(PreparedStatement preparedStatement, OracleDocument oracleDocument, int n) throws OracleException, SQLException {
        if (this.options.contentDataType != 4) {
            throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
        }
        InputStream inputStream = ((OracleDocumentImpl)oracleDocument).getContentAsStream();
        long l = -1L;
        if (inputStream instanceof LimitedInputStream) {
            l = ((LimitedInputStream)inputStream).availableLong();
        }
        if (l == 0L) {
            preparedStatement.setNull(n, -3);
        } else if (l > 0L) {
            preparedStatement.setBlob(n, inputStream, l);
        } else {
            preparedStatement.setBlob(n, inputStream);
        }
    }

    @Override
    public void insert(OracleDocument oracleDocument) throws OracleException {
        this.checkJDBCVersion();
        this.insertAndGet(oracleDocument);
    }

    @Override
    public OracleDocument insertAndGet(OracleDocument oracleDocument) throws OracleException {
        this.checkJDBCVersion();
        return this.insertAndGet(oracleDocument, null);
    }

    @Override
    public OracleDocument insertAndGet(OracleDocument oracleDocument, Map<String, ?> map) throws OracleException {
        Object object;
        this.checkJDBCVersion();
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "document");
        }
        String string = this.getHintString(map);
        Boolean bl = this.getEJSONBoolean(map);
        if (bl.booleanValue() && !this.options.hasBinaryFormat() && !this.options.hasJsonType()) {
            throw SODAUtils.makeException(SODAMessage.EX_EJSON_CANNOT_BE_USED, new Object[0]);
        }
        if (OracleDocumentImpl.isBinary(oracleDocument) && bl.booleanValue()) {
            throw SODAUtils.makeException(SODAMessage.EX_EJSON_CANNOT_BE_USED_WITH_BINARY_DOC, new Object[0]);
        }
        this.writeCheck("insert");
        String string2 = this.getDocumentKey(oracleDocument, true, bl);
        if (string2 != null && this.hasExtrinsicServerKey()) {
            throw SODAUtils.makeException(SODAMessage.EX_INPUT_DOC_HAS_KEY, new Object[0]);
        }
        PreparedStatement preparedStatement = null;
        byte[] byArray = EMPTY_DATA;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = this.internalDriver;
        if (!this.oracleDriver && !this.useCallableReturns) {
            bl2 = true;
        }
        switch (this.options.keyAssignmentMethod) {
            case 7: {
                break;
            }
            case 5: {
                if (!bl2) break;
                throw SODAUtils.makeException(SODAMessage.EX_IDENTITY_ASSIGN_RETURNING, new Object[0]);
            }
            case 4: {
                if (!bl2) break;
                string3 = Long.toString(this.nextSequenceValue());
                break;
            }
            case 3: {
                if (!bl2) break;
                string3 = this.db.nextGuid();
                if (this.options.keyDataType != 3) break;
                string3 = this.uidToDecimal(string3);
                break;
            }
            case 2: {
                string3 = this.db.generateKey();
                if (this.options.keyDataType != 3) break;
                string3 = this.uidToDecimal(string3);
                break;
            }
            default: {
                string3 = this.canonicalKey(string2);
            }
        }
        String string6 = this.buildInsert(bl2, string, bl);
        try {
            int n;
            object = null;
            this.metrics.startTiming();
            if (this.insertHasReturnClause(bl2) && this.useCallableReturns) {
                object = this.conn.prepareCall(string6);
                preparedStatement = object;
            } else {
                preparedStatement = this.conn.prepareStatement(string6);
            }
            int n2 = 0;
            if (!this.returnInsertedKey() || bl2) {
                this.bindKeyColumn(preparedStatement, ++n2, string3);
            }
            n2 = this.bindMediaTypeColumn(preparedStatement, n2, oracleDocument);
            boolean bl3 = true;
            if (!this.payloadBasedVersioning() && this.admin().isHeterogeneous() && ((OracleDocumentImpl)oracleDocument).hasStreamContent()) {
                this.setStreamBind(preparedStatement, oracleDocument, ++n2);
                bl3 = false;
            } else {
                byArray = this.bindPayloadColumn(preparedStatement, ++n2, oracleDocument, (boolean)bl);
            }
            if (this.returnInsertedTime() && bl2) {
                string5 = ComponentTime.instantToString(this.db.getDatabaseTime(), false);
                if (this.options.timestampColumnName != null) {
                    preparedStatement.setString(++n2, string5);
                }
                if (this.options.creationColumnName != null) {
                    preparedStatement.setString(++n2, string5);
                }
            }
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        long l = 1L;
                        preparedStatement.setLong(++n2, l);
                        string4 = Long.toString(l);
                        break;
                    }
                    case 1: {
                        long l = this.db.getDatabaseTimeVersion(this.db.getDatabaseTime());
                        preparedStatement.setLong(++n2, l);
                        string4 = Long.toString(l);
                        break;
                    }
                    case 3: {
                        string4 = this.db.generateKey();
                        preparedStatement.setString(++n2, string4);
                        break;
                    }
                    default: {
                        if (!bl3) {
                            throw SODAUtils.makeException(SODAMessage.EX_NO_HASH_VERSION, this.options.uriName, this.options.getVersioningMethod());
                        }
                        string4 = this.computeVersion(byArray);
                        preparedStatement.setString(++n2, string4);
                    }
                }
            }
            int n3 = -1;
            if (this.insertHasReturnClause(bl2)) {
                if (!this.useCallableReturns) {
                    if (this.returnInsertedKey()) {
                        this.db.registerReturnString(preparedStatement, ++n2);
                    }
                    if (this.returnInsertedTime()) {
                        this.db.registerReturnTimestamp(preparedStatement, ++n2);
                    }
                    if (this.returnInsertedVersion()) {
                        this.db.registerReturnString(preparedStatement, ++n2);
                    }
                } else {
                    n3 = n2++;
                    if (this.returnInsertedKey()) {
                        object.registerOutParameter(n2, 12);
                    }
                    if (this.returnInsertedTime()) {
                        object.registerOutParameter(++n2, 93);
                    }
                    if (this.returnInsertedVersion()) {
                        object.registerOutParameter(++n2, 12);
                    }
                    object.registerOutParameter(++n2, 12);
                }
            }
            if ((n = preparedStatement.executeUpdate()) != 1) {
                throw SODAUtils.makeException(SODAMessage.EX_INSERT_FAILED, this.options.uriName);
            }
            if (this.insertHasReturnClause(bl2)) {
                Object object2;
                int n4 = 0;
                if (!this.useCallableReturns) {
                    object2 = this.db.getReturnResultSet(preparedStatement);
                    if (object2 == null || !object2.next()) {
                        throw SODAUtils.makeException(SODAMessage.EX_INSERT_FAILED, this.options.uriName);
                    }
                    if (this.returnInsertedKey()) {
                        string3 = object2.getString(++n4);
                    }
                    if (this.returnInsertedTime()) {
                        string5 = OracleDatabaseImpl.getTimestamp((ResultSet)object2, ++n4);
                    }
                    if (this.returnInsertedVersion()) {
                        string4 = object2.getString(++n4);
                    }
                    object2.close();
                    object2 = null;
                } else {
                    n4 = n3;
                    if (this.returnInsertedKey()) {
                        string3 = object.getString(++n4);
                    }
                    if (this.returnInsertedTime()) {
                        string5 = OracleDatabaseImpl.getTimestamp((CallableStatement)object, ++n4);
                    }
                    if (this.returnInsertedVersion()) {
                        string4 = object.getString(++n4);
                    }
                    if ((object2 = object.getString(++n4)) == null || !((String)object2).equals("1")) {
                        throw SODAUtils.makeException(SODAMessage.EX_INSERT_FAILED, this.options.uriName);
                    }
                }
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString() + "\n" + string6);
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string6);
            }
            catch (Throwable throwable) {
                for (String string7 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string7);
                }
                throw throwable;
            }
        }
        for (String string8 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string8);
        }
        object = new OracleDocumentImpl(string3, string4, string5);
        ((OracleDocumentImpl)object).setCreatedOn(string5);
        String string9 = oracleDocument.getMediaType();
        this.setContentType(string9, (OracleDocumentImpl)object);
        return object;
    }

    @Override
    public void save(OracleDocument oracleDocument) throws OracleException {
        this.checkJDBCVersion();
        this.saveAndGet(oracleDocument, null);
    }

    @Override
    public OracleDocument saveAndGet(OracleDocument oracleDocument) throws OracleException {
        this.checkJDBCVersion();
        return this.saveAndGet(oracleDocument, null);
    }

    @Override
    public OracleDocument saveAndGet(OracleDocument oracleDocument, Map<String, ?> map) throws OracleException {
        this.checkJDBCVersion();
        this.writeCheck("save");
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "document");
        }
        String string = this.getHintString(map);
        Boolean bl = this.getEJSONBoolean(map);
        if (bl.booleanValue()) {
            throw SODAUtils.makeException(SODAMessage.EX_EJSON_CANNOT_BE_USED, new Object[0]);
        }
        String string2 = this.getDocumentKey(oracleDocument, false, false);
        if (this.hasExtrinsicServerKey()) {
            string2 = null;
        }
        if (string2 != null) {
            return this.upsert(string2, oracleDocument, string);
        }
        return this.insertAndGet(oracleDocument);
    }

    @Override
    public void insert(Iterator<OracleDocument> iterator) throws OracleBatchException {
        try {
            this.checkJDBCVersion();
        }
        catch (OracleException oracleException) {
            throw this.convertToOracleBatchException(oracleException, 0, null);
        }
        this.insertAndGet(iterator);
    }

    private List<OracleDocument> insertRows(Iterator<OracleDocument> iterator, Map<String, ?> map) throws OracleBatchException {
        int n = 0;
        if (!iterator.hasNext()) {
            return EMPTY_LIST;
        }
        ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
        boolean bl = false;
        try {
            if (this.conn.getAutoCommit()) {
                if (this.avoidTxnManagement) {
                    throw SODAUtils.makeBatchException(SODAMessage.EX_OPERATION_REQUIRES_TXN_MANAGEMENT, n, "insertRows");
                }
                this.conn.setAutoCommit(false);
                bl = true;
            }
            while (iterator.hasNext()) {
                Object object;
                OracleDocument oracleDocument = iterator.next();
                if (oracleDocument == null) {
                    object = SODAUtils.makeBatchException(SODAMessage.EX_ITERATOR_RETURNED_NULL_ELEMENT, n, "documents", n);
                    throw object;
                }
                object = this.getDocumentKey(oracleDocument, false, false);
                if (object != null && this.options.keyAssignmentMethod != 1) {
                    OracleBatchException oracleBatchException = SODAUtils.makeBatchException(SODAMessage.EX_ITERATOR_RETURNED_DOC_WITH_KEY, n, "documents", n);
                    throw oracleBatchException;
                }
                if ((oracleDocument = this.insertAndGet(oracleDocument, map)) == null) {
                    throw SODAUtils.makeBatchException(SODAMessage.EX_INSERT_FAILED, n, this.options.uriName);
                }
                arrayList.add(oracleDocument);
                ++n;
            }
        }
        catch (OracleException oracleException) {
            OracleBatchException oracleBatchException = this.convertToOracleBatchException(oracleException, n, null);
            oracleBatchException.setNextException(TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, false));
            throw oracleBatchException;
        }
        catch (SQLException sQLException) {
            OracleBatchException oracleBatchException = SODAUtils.makeBatchException(sQLException, n);
            oracleBatchException.setNextException(TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, false));
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString());
            }
            throw oracleBatchException;
        }
        return arrayList;
    }

    @Override
    public List<OracleDocument> insertAndGet(Iterator<OracleDocument> iterator) throws OracleBatchException {
        try {
            this.checkJDBCVersion();
        }
        catch (OracleException oracleException) {
            throw this.convertToOracleBatchException(oracleException, 0, null);
        }
        return this.insertAndGet(iterator, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OracleDocument> insertAndGet(Iterator<OracleDocument> iterator, Map<String, ?> map) throws OracleBatchException {
        Object object;
        int n = 0;
        int n2 = 0;
        if (iterator == null) {
            throw SODAUtils.makeBatchException(SODAMessage.EX_ARG_CANNOT_BE_NULL, n2, "documents");
        }
        try {
            this.checkJDBCVersion();
        }
        catch (OracleException oracleException) {
            throw this.convertToOracleBatchException(oracleException, n2, null);
        }
        String string = null;
        try {
            string = this.getHintString(map);
        }
        catch (OracleException oracleException) {
            throw this.convertToOracleBatchException(oracleException, n2, null);
        }
        Boolean bl = null;
        try {
            bl = this.getEJSONBoolean(map);
            if (bl.booleanValue() && !this.options.hasBinaryFormat() && !this.options.hasJsonType()) {
                throw SODAUtils.makeException(SODAMessage.EX_EJSON_CANNOT_BE_USED, new Object[0]);
            }
        }
        catch (OracleException oracleException) {
            throw this.convertToOracleBatchException(oracleException, n2, null);
        }
        Integer n3 = null;
        try {
            n3 = this.getMaxJDBCBatchSize(map);
        }
        catch (OracleException oracleException) {
            throw this.convertToOracleBatchException(oracleException, n2, null);
        }
        if (n3 == null) {
            n3 = 100;
        }
        if (this.isReadOnly()) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning("Write to " + this.options.uriName + " not allowed");
            }
            throw SODAUtils.makeBatchException(SODAMessage.EX_READ_ONLY, n2, this.options.uriName, "insert");
        }
        if (!iterator.hasNext()) {
            return EMPTY_LIST;
        }
        if (this.options.keyAssignmentMethod == 5 || this.options.isDualityView()) {
            return this.insertRows(iterator, map);
        }
        ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
        PreparedStatement preparedStatement = null;
        String string2 = this.buildInsert(true, string, bl);
        boolean bl2 = false;
        try {
            Object object2;
            if (this.conn.getAutoCommit()) {
                if (this.avoidTxnManagement) {
                    throw SODAUtils.makeBatchException(SODAMessage.EX_OPERATION_REQUIRES_TXN_MANAGEMENT, n2, "insertAndGet");
                }
                this.conn.setAutoCommit(false);
                bl2 = true;
            }
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            object = this.db.getDatabaseTime();
            long l = this.db.getDatabaseTimeVersion((Instant)object);
            String string3 = ComponentTime.instantToString((Instant)object, false);
            while (iterator.hasNext()) {
                Object object3;
                Object object4;
                object2 = iterator.next();
                if (object2 == null) {
                    object4 = SODAUtils.makeBatchException(SODAMessage.EX_ITERATOR_RETURNED_NULL_ELEMENT, n2, "documents", n2);
                    throw object4;
                }
                if (OracleDocumentImpl.isBinary((OracleDocument)object2) && bl.booleanValue()) {
                    object4 = SODAUtils.makeBatchException(SODAMessage.EX_EJSON_CANNOT_BE_USED_WITH_BINARY_DOC, n2, "documents", n2);
                    throw object4;
                }
                object4 = this.getDocumentKey((OracleDocument)object2, true, bl);
                if (object4 != null && this.hasExtrinsicServerKey()) {
                    object3 = SODAUtils.makeBatchException(SODAMessage.EX_ITERATOR_RETURNED_DOC_WITH_KEY, n2, "documents", n2);
                    throw object3;
                }
                object3 = null;
                String string4 = null;
                switch (this.options.keyAssignmentMethod) {
                    case 5: {
                        throw SODAUtils.makeException(SODAMessage.EX_IDENTITY_ASSIGN_RETURNING, new Object[0]);
                    }
                    case 4: {
                        object3 = Long.toString(this.nextSequenceValue());
                        break;
                    }
                    case 3: {
                        object3 = this.db.nextGuid();
                        if (this.options.keyDataType != 3) break;
                        object3 = this.uidToDecimal((String)object3);
                        break;
                    }
                    case 2: {
                        object3 = this.db.generateKey();
                        if (this.options.keyDataType != 3) break;
                        object3 = this.uidToDecimal((String)object3);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        object3 = this.canonicalKey((String)object4);
                    }
                }
                int n4 = 0;
                if (this.options.keyAssignmentMethod != 7) {
                    this.bindKeyColumn(preparedStatement, ++n4, (String)object3);
                }
                n4 = this.bindMediaTypeColumn(preparedStatement, n4, (OracleDocument)object2);
                byte[] byArray = this.bindPayloadColumn(preparedStatement, ++n4, (OracleDocument)object2, (boolean)bl);
                if (this.options.timestampColumnName != null) {
                    preparedStatement.setString(++n4, string3);
                }
                if (this.options.creationColumnName != null) {
                    preparedStatement.setString(++n4, string3);
                }
                if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                    switch (this.options.versioningMethod) {
                        case 2: {
                            long l2 = 1L;
                            preparedStatement.setLong(++n4, l2);
                            string4 = Long.toString(l2);
                            break;
                        }
                        case 1: {
                            preparedStatement.setLong(++n4, l);
                            string4 = Long.toString(l);
                            break;
                        }
                        case 3: {
                            string4 = this.db.generateKey();
                            preparedStatement.setString(++n4, string4);
                            break;
                        }
                        default: {
                            string4 = this.computeVersion(byArray);
                            preparedStatement.setString(++n4, string4);
                        }
                    }
                }
                preparedStatement.addBatch();
                if (++n2 % n3 == 0) {
                    int[] nArray = preparedStatement.executeBatch();
                    n += nArray.length;
                }
                OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl((String)object3, string4, string3);
                oracleDocumentImpl.setCreatedOn(string3);
                String string5 = object2.getMediaType();
                this.setContentType(string5, oracleDocumentImpl);
                arrayList.add(oracleDocumentImpl);
            }
            if (n2 % n3 != 0) {
                object2 = preparedStatement.executeBatch();
                n += ((Object)object2).length;
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(n2, n3);
        }
        catch (OracleException oracleException) {
            try {
                OracleBatchException oracleBatchException = this.convertToOracleBatchException(oracleException, n2, string2);
                oracleBatchException.setNextException(TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl2, false));
                throw oracleBatchException;
                catch (SQLException sQLException) {
                    int n5 = 0;
                    n5 = sQLException instanceof BatchUpdateException ? (n += ((BatchUpdateException)sQLException).getUpdateCounts().length) : n2;
                    OracleBatchException oracleBatchException2 = SODAUtils.makeBatchExceptionWithSQLText(sQLException, n5, string2);
                    oracleBatchException2.setNextException(TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl2, false));
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString() + "\n" + string2);
                    }
                    throw oracleBatchException2;
                }
                catch (RuntimeException runtimeException) {
                    TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl2, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(runtimeException.toString());
                    }
                    throw runtimeException;
                }
                catch (Error error) {
                    TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl2, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(error.toString());
                    }
                    throw error;
                }
            }
            catch (Throwable throwable) {
                Iterator<String> iterator2 = SODAUtils.closeCursor(preparedStatement, null).iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        throw throwable;
                    }
                    String string6 = iterator2.next();
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string6);
                }
            }
        }
        for (String string7 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string7);
        }
        object = TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl2, true);
        if (object != null) {
            throw new OracleBatchException((Throwable)object, n2);
        }
        return arrayList;
    }

    private OracleBatchException convertToOracleBatchException(OracleException oracleException, int n, String string) {
        if (oracleException instanceof OracleBatchException) {
            return (OracleBatchException)oracleException;
        }
        OracleBatchException oracleBatchException = null;
        Throwable throwable = oracleException.getCause();
        oracleBatchException = throwable != null && throwable instanceof SQLException ? SODAUtils.makeBatchExceptionWithSQLText(throwable, n, string) : new OracleBatchException(oracleException, n);
        return oracleBatchException;
    }

    private Integer getMaxJDBCBatchSize(Map<String, ?> map) throws OracleException {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object obj = map.get("maxBatchSize");
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Integer)) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_BATCH_SIZE, obj.toString());
        }
        return (Integer)obj;
    }

    private String getHintString(Map<String, ?> map) throws OracleException {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object obj = map.get("hint");
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_HINT, obj.toString());
        }
        String string = (String)obj;
        if (string.indexOf("/*") >= 0 || string.indexOf("*/") >= 0) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_HINT, string);
        }
        return string == "" ? null : string;
    }

    private Boolean getEJSONBoolean(Map<String, ?> map) throws OracleException {
        if (map == null || map.isEmpty()) {
            return false;
        }
        Object obj = map.get("format");
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof String) || !obj.equals("eJSON")) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_FORMAT, obj.toString());
        }
        return true;
    }

    static OracleException completeTxnAndRestoreAutoCommit(Connection connection, boolean bl, boolean bl2) {
        OracleException oracleException = null;
        if (bl) {
            try {
                if (!bl2) {
                    connection.rollback();
                } else {
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                oracleException = new OracleException(sQLException);
            }
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                if (oracleException == null) {
                    oracleException = new OracleException(sQLException);
                }
                oracleException.setNextException(new OracleException(sQLException));
            }
        }
        return oracleException;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OracleDocument upsert(String string, OracleDocument oracleDocument, String string2) throws OracleException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = this.buildUpsert(string2);
        OracleDocumentImpl oracleDocumentImpl = null;
        string = this.canonicalKey(string);
        boolean bl = false;
        try {
            object = this.db.getDatabaseTime();
            long l = this.db.getDatabaseTimeVersion((Instant)object);
            String string4 = ComponentTime.instantToString((Instant)object, false);
            this.metrics.startTiming();
            if (this.conn.getAutoCommit()) {
                if (this.avoidTxnManagement) {
                    throw SODAUtils.makeException(SODAMessage.EX_OPERATION_REQUIRES_TXN_MANAGEMENT, "save");
                }
                this.conn.setAutoCommit(false);
                bl = true;
            }
            preparedStatement = this.conn.prepareStatement(string3);
            int n = 0;
            this.bindKeyColumn(preparedStatement, ++n, string);
            byte[] byArray = null;
            byArray = this.options.hasBinaryFormat() ? (((OracleDocumentImpl)oracleDocument).isBinary() ? ((OracleDocumentImpl)oracleDocument).getBinaryContentAsByteArray() : this.convertToBinary(oracleDocument.getContentAsByteArray())) : (((OracleDocumentImpl)oracleDocument).isBinary() && this.options.hasJsonType() ? ((OracleDocumentImpl)oracleDocument).getBinaryContentAsByteArray() : oracleDocument.getContentAsByteArray());
            String string5 = null;
            switch (this.options.contentDataType) {
                case 1: {
                    string5 = TableCollectionImpl.stringFromBytes(byArray);
                    preparedStatement.setString(++n, string5);
                    break;
                }
                case 5: {
                    string5 = TableCollectionImpl.stringFromBytes(byArray);
                    this.setPayloadClobWorkaround(preparedStatement, ++n, string5);
                    break;
                }
                case 3: {
                    string5 = TableCollectionImpl.stringFromBytes(byArray);
                    preparedStatement.setNString(++n, string5);
                    break;
                }
                case 6: {
                    string5 = TableCollectionImpl.stringFromBytes(byArray);
                    this.setPayloadNclob(preparedStatement, ++n, string5);
                    break;
                }
                case 2: {
                    preparedStatement.setBytes(++n, byArray);
                    break;
                }
                case 4: {
                    this.setPayloadBlobWorkaround(preparedStatement, ++n, byArray);
                    break;
                }
                case 7: {
                    this.db.setBytesForJson(preparedStatement, ++n, byArray);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.options.timestampColumnName != null) {
                preparedStatement.setString(++n, string4);
            }
            String string6 = null;
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        preparedStatement.setLong(++n, l);
                        string6 = Long.toString(l);
                        break;
                    }
                    case 3: {
                        string6 = this.db.generateKey();
                        preparedStatement.setString(++n, string6);
                        break;
                    }
                    default: {
                        string6 = this.computeVersion(byArray);
                        preparedStatement.setString(++n, string6);
                    }
                }
            }
            n = this.bindMediaTypeColumn(preparedStatement, n, oracleDocument);
            this.bindKeyColumn(preparedStatement, ++n, string);
            switch (this.options.contentDataType) {
                case 1: {
                    preparedStatement.setString(++n, string5);
                    break;
                }
                case 5: {
                    this.setPayloadClobWorkaround(preparedStatement, ++n, string5);
                    break;
                }
                case 3: {
                    preparedStatement.setNString(++n, string5);
                    break;
                }
                case 6: {
                    this.setPayloadNclob(preparedStatement, ++n, string5);
                    break;
                }
                case 2: {
                    preparedStatement.setBytes(++n, byArray);
                    break;
                }
                case 4: {
                    this.setPayloadBlobWorkaround(preparedStatement, ++n, byArray);
                    break;
                }
                case 7: {
                    this.db.setBytesForJson(preparedStatement, ++n, byArray);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.options.timestampColumnName != null) {
                preparedStatement.setString(++n, string4);
            }
            if (this.options.creationColumnName != null) {
                preparedStatement.setString(++n, string4);
            }
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        long l2 = 1L;
                        preparedStatement.setLong(++n, l2);
                        string6 = Long.toString(l2);
                        break;
                    }
                    case 1: {
                        preparedStatement.setLong(++n, l);
                        string6 = Long.toString(l);
                        break;
                    }
                    default: {
                        preparedStatement.setString(++n, string6);
                    }
                }
            }
            this.bindMediaTypeColumn(preparedStatement, n, oracleDocument);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw SODAUtils.makeException(SODAMessage.EX_SAVE_FAILED, this.options.uriName);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
            String string7 = null;
            if (this.options.creationColumnName != null || this.returnVersion()) {
                this.metrics.startTiming();
                preparedStatement = this.conn.prepareStatement(this.buildSelectForUpsert(string2));
                this.bindKeyColumn(preparedStatement, 1, string);
                resultSet = preparedStatement.executeQuery();
                n = 0;
                boolean bl2 = resultSet.next();
                if (!bl2) {
                    throw SODAUtils.makeException(SODAMessage.EX_SAVE_FAILED, this.options.uriName);
                }
                if (this.options.creationColumnName != null) {
                    string7 = OracleDatabaseImpl.getTimestamp(resultSet, ++n);
                }
                if (this.returnVersion()) {
                    string6 = resultSet.getString(++n);
                }
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
                preparedStatement = null;
                this.metrics.recordReads(1, 1);
            }
            oracleDocumentImpl = new OracleDocumentImpl(string, string6, string4);
            oracleDocumentImpl.setCreatedOn(string7);
            String string8 = oracleDocument.getMediaType();
            this.setContentType(string8, oracleDocumentImpl);
        }
        catch (OracleException oracleException) {
            try {
                oracleException.setNextException(TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, false));
                throw oracleException;
                catch (SQLException sQLException) {
                    OracleException oracleException2 = SODAUtils.makeExceptionWithSQLText(sQLException, string3);
                    oracleException2.setNextException(TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, false));
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString() + "\n" + string3);
                    }
                    throw oracleException2;
                }
                catch (RuntimeException runtimeException) {
                    TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(runtimeException.toString());
                    }
                    throw runtimeException;
                }
                catch (Error error) {
                    TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(error.toString());
                    }
                    throw error;
                }
            }
            catch (Throwable throwable) {
                Iterator<String> iterator = SODAUtils.closeCursor(preparedStatement, resultSet).iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    String string9 = iterator.next();
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string9);
                }
            }
        }
        for (String string10 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string10);
        }
        object = TableCollectionImpl.completeTxnAndRestoreAutoCommit((Connection)this.conn, bl, true);
        if (object != null) {
            throw object;
        }
        return oracleDocumentImpl;
    }

    @Override
    public OracleDocumentFragmentImpl findFragment(String string, long l, int n) throws OracleException {
        OracleDocumentFragmentImpl oracleDocumentFragmentImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        byte[] byArray = null;
        LobInputStream lobInputStream = null;
        boolean bl = false;
        String string2 = this.buildQuery();
        string = this.canonicalKey(string);
        if (this.admin().isHeterogeneous()) {
            bl = true;
        }
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            this.bindKeyColumn(preparedStatement, 1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = 0;
                String string3 = resultSet.getString(++n2);
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                long l2 = -1L;
                if (this.options.doctypeColumnName != null) {
                    if ((string4 = resultSet.getString(++n2)) == null) {
                        bl = false;
                    } else if (string4.equalsIgnoreCase("application/json")) {
                        bl = false;
                    }
                }
                if (this.options.hasBinaryFormat()) {
                    bl = true;
                }
                if (bl) {
                    Blob blob;
                    if (this.options.contentDataType != 4) {
                        throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
                    }
                    if ((blob = resultSet.getBlob(++n2)) != null) {
                        l2 = blob.length();
                        if (l2 > 0L) {
                            InputStream inputStream;
                            if (n < 0 || (long)n + l > l2) {
                                n = (int)(l2 - l);
                            }
                            if ((l > 0L || (long)n + l < l2) && n <= 0x100000 && l2 > 4096L && l2 >> 1 > (long)n) {
                                byArray = blob.getBytes(l + 1L, n);
                                bl = false;
                                blob.free();
                            }
                            if (bl && (inputStream = blob.getBinaryStream()) != null) {
                                lobInputStream = new LobInputStream(blob, inputStream, l2);
                                lobInputStream.setMetrics(this.metrics);
                            }
                        }
                        if (lobInputStream == null && byArray == null) {
                            lobInputStream = new LobInputStream();
                        }
                    }
                } else {
                    byArray = this.readPayloadColumn(resultSet, ++n2);
                }
                if (this.options.timestampColumnName != null) {
                    string5 = OracleDatabaseImpl.getTimestamp(resultSet, ++n2);
                }
                if (this.options.creationColumnName != null) {
                    string6 = OracleDatabaseImpl.getTimestamp(resultSet, ++n2);
                }
                if (this.options.versionColumnName != null) {
                    string7 = resultSet.getString(++n2);
                }
                if (lobInputStream != null) {
                    oracleDocumentFragmentImpl = new OracleDocumentFragmentImpl(string3, string7, string5, lobInputStream, string4);
                } else {
                    oracleDocumentFragmentImpl = new OracleDocumentFragmentImpl(string3, string7, string5, byArray);
                    this.setContentType(string4, oracleDocumentFragmentImpl);
                    if (l2 > 0L) {
                        oracleDocumentFragmentImpl.setFragmentInfo(l, l2);
                    }
                }
                if (string6 != null) {
                    oracleDocumentFragmentImpl.setCreatedOn(string6);
                }
            }
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                block33: {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    try {
                        if (lobInputStream != null) {
                            lobInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!OracleLog.isLoggingEnabled()) break block33;
                        log.severe(iOException.toString());
                    }
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string8 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string8);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return oracleDocumentFragmentImpl;
    }

    private byte[] readPayloadColumn(ResultSet resultSet, int n) throws SQLException {
        byte[] byArray = EMPTY_DATA;
        switch (this.options.contentDataType) {
            case 1: 
            case 5: {
                String string = resultSet.getString(n);
                if (string == null) break;
                byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
                break;
            }
            case 3: 
            case 6: {
                String string = resultSet.getNString(n);
                if (string == null) break;
                byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
                break;
            }
            case 2: 
            case 4: {
                byArray = resultSet.getBytes(n);
            }
        }
        return byArray;
    }

    private long nextSequenceValue(int n) throws OracleException {
        if (this.seqCacheAvail == 0) {
            this.fetchSequence(n);
        }
        --this.seqCacheAvail;
        return this.seqCache[this.seqCachePos++];
    }

    private long nextSequenceValue() throws OracleException {
        return this.nextSequenceValue(10);
    }

    private String buildSequenceFetch() {
        this.sb.setLength(0);
        this.sb.append("declare\n");
        this.sb.append("  N number;\n");
        this.sb.append("  X number;\n");
        this.sb.append("  K XDB.DBMS_SODA_ADMIN.NUMNTAB;\n");
        this.sb.append("begin\n");
        this.sb.append("  N := ?;\n");
        this.sb.append("  K := XDB.DBMS_SODA_ADMIN.NUMNTAB();\n");
        this.sb.append("  K.extend(N);\n");
        this.sb.append("  for I in 1..N loop\n");
        this.sb.append("    select \"");
        this.sb.append(this.options.keySequenceName);
        this.sb.append("\".NEXTVAL into X from SYS.DUAL;\n");
        this.sb.append("    K(I) := X;\n");
        this.sb.append("  end loop;\n");
        this.sb.append("  ? := K;\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private void fetchSequence(int n) throws OracleException {
        CallableStatement callableStatement = null;
        String string = this.buildSequenceFetch();
        int n2 = n;
        if (n2 > this.seqCache.length) {
            n2 = this.seqCache.length;
        } else if (n2 < 10) {
            n2 = 10;
        }
        try {
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.setInt(1, n2);
            callableStatement.registerOutParameter(2, 2003, "XDB.DBMS_SODA_ADMIN.NUMNTAB");
            callableStatement.execute();
            Array array = callableStatement.getArray(2);
            BigDecimal[] object = (BigDecimal[])array.getArray();
            n2 = object.length;
            for (int i = 0; i < n2; ++i) {
                this.seqCache[i] = object[i].longValue();
            }
            this.seqCachePos = 0;
            this.seqCacheAvail = n2;
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordsSequenceBatchFetches();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    void setContentType(String string, OracleDocumentImpl oracleDocumentImpl) {
        if (string != null || this.options.doctypeColumnName != null) {
            oracleDocumentImpl.setContentType(string);
        }
    }

    int bindMediaTypeColumn(PreparedStatement preparedStatement, int n, OracleDocument oracleDocument) throws SQLException {
        String string = oracleDocument.getMediaType();
        if (this.options.doctypeColumnName != null) {
            if (string != null) {
                preparedStatement.setString(++n, string);
            } else {
                preparedStatement.setNull(++n, 12);
            }
        }
        return n;
    }

    void bindKeyColumn(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        switch (this.options.keyDataType) {
            case 3: {
                preparedStatement.setString(n, string);
                break;
            }
            case 4: {
                if (this.options.isDualityView()) {
                    preparedStatement.setString(n, string);
                    break;
                }
                preparedStatement.setBytes(n, ByteArray.hexToRaw(string));
                break;
            }
            case 1: {
                preparedStatement.setString(n, string);
                break;
            }
            case 2: {
                preparedStatement.setNString(n, string);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void setPayloadBlob(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException, OracleException {
        if (this.internalDriver || this.options.hasBinaryFormat() && byArray != null && byArray.length > Short.MAX_VALUE) {
            if (!this.db.setBytesForBlob(preparedStatement, n, byArray)) {
                preparedStatement.setBlob(n, new ByteArrayInputStream(byArray), byArray.length);
            }
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    private void setPayloadBlobWorkaround(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException, OracleException {
        if (!this.db.setBytesForBlob(preparedStatement, n, byArray)) {
            preparedStatement.setBlob(n, new ByteArrayInputStream(byArray), byArray.length);
        }
    }

    private void setClobInternalDriver(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (string.length() < Short.MAX_VALUE && this.db.setStringForClob(preparedStatement, n, string)) {
            return;
        }
        preparedStatement.setClob(n, new StringReader(string));
    }

    private void setPayloadClob(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            this.setClobInternalDriver(preparedStatement, n, string);
        } else {
            preparedStatement.setString(n, string);
        }
    }

    private void setPayloadClobWorkaround(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            this.setClobInternalDriver(preparedStatement, n, string);
        } else if (!this.db.setStringForClob(preparedStatement, n, string)) {
            preparedStatement.setClob(n, new StringReader(string));
        }
    }

    private void setPayloadNclob(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setNClob(n, new StringReader(string));
        } else {
            preparedStatement.setNString(n, string);
        }
    }

    byte[] bindPayloadColumn(PreparedStatement preparedStatement, int n, OracleDocument oracleDocument, boolean bl) throws SQLException, OracleException {
        byte[] byArray = this.getContentForTransfer(oracleDocument, bl);
        this.bindPayloadColumn(preparedStatement, n, byArray, bl);
        return byArray;
    }

    void bindPayloadColumn(PreparedStatement preparedStatement, int n, byte[] byArray, boolean bl) throws OracleException, SQLException {
        switch (this.options.contentDataType) {
            case 1: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                preparedStatement.setString(n, string);
                break;
            }
            case 5: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                this.setPayloadClob(preparedStatement, n, string);
                break;
            }
            case 3: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                preparedStatement.setNString(n, string);
                break;
            }
            case 6: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                this.setPayloadNclob(preparedStatement, n, string);
                break;
            }
            case 2: {
                preparedStatement.setBytes(n, byArray);
                break;
            }
            case 4: {
                this.setPayloadBlob(preparedStatement, n, byArray);
                break;
            }
            case 7: {
                if (bl) {
                    this.setPayloadBlob(preparedStatement, n, byArray);
                    break;
                }
                this.db.setBytesForJson(preparedStatement, n, byArray);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    byte[] getContentForTransfer(OracleDocument oracleDocument, boolean bl) throws OracleException {
        if (this.options.hasBinaryFormat() && !bl) {
            if (((OracleDocumentImpl)oracleDocument).isBinary()) {
                return ((OracleDocumentImpl)oracleDocument).getBinaryContentAsByteArray();
            }
            return this.convertToBinary(oracleDocument.getContentAsByteArray());
        }
        if (((OracleDocumentImpl)oracleDocument).isBinary() && this.options.hasJsonType() && !bl) {
            return ((OracleDocumentImpl)oracleDocument).getBinaryContentAsByteArray();
        }
        return oracleDocument.getContentAsByteArray();
    }
}

