/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.json.common.Message;

public final class ComponentTime {
    public static final String LOWEST_TIME = "0001-01-01T00:00:00.000000";
    public static final String INFINITY_TIME = "9999-12-31T23:59:59.999999";
    public static final String DEFAULT_OFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DEFAULT_IFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String HTTP_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final int YPOS = 46;
    private static final int MPOS = 42;
    private static final int DPOS = 37;
    private static final int HPOS = 32;
    private static final int IPOS = 26;
    private static final int SPOS = 20;
    private static final int UPOS = 0;
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ofPattern("YYYY-MM-dd'T'HH:mm:ss.nnnnnnnnn");

    private ComponentTime() {
    }

    private static void throwException(String string) {
        throw new IllegalArgumentException(Message.EX_ILLEGAL_DATE_TIME.get(string));
    }

    public static SimpleDateFormat makeOutputFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_OFORMAT);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat;
    }

    public static SimpleDateFormat makeInputFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_IFORMAT);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat simpleDateFormat = ComponentTime.makeOutputFormatter();
        return simpleDateFormat.format(date);
    }

    public static String dateToHeaderString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HTTP_FORMAT, Locale.US);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat.format(date);
    }

    public static Date dateFromHeaderString(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HTTP_FORMAT, Locale.US);
        ParsePosition parsePosition = new ParsePosition(0);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat.parse(string, parsePosition);
    }

    public static Date stringToDate(String string) {
        int n;
        SimpleDateFormat simpleDateFormat = ComponentTime.makeInputFormatter();
        ParsePosition parsePosition = new ParsePosition(0);
        int n2 = string.length();
        if (string.endsWith("Z")) {
            string = string.substring(0, --n2);
        }
        if (n2 > 23) {
            string = string.substring(0, 23);
        }
        if (n2 == 10) {
            string = string + "T00:00:00.000";
        }
        if ((n = string.indexOf(46)) < 0 && n2 == 19) {
            string = string + ".000";
        }
        return simpleDateFormat.parse(string, parsePosition);
    }

    public static String millisToString(long l) {
        return Instant.ofEpochMilli(l).toString();
    }

    public static long stringToMillis(String string) throws IllegalArgumentException {
        if (string != null) {
            try {
                Instant instant = ComponentTime.stringToInstant(string);
                return instant.toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
                ComponentTime.throwException(string);
            }
        }
        return Integer.MIN_VALUE;
    }

    public static Instant stringToInstant(String string) throws DateTimeParseException {
        if (string.length() == 10) {
            string = string + "T00:00:00.000";
        }
        if (!string.endsWith("Z")) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(string);
                return localDateTime.toInstant(ZoneOffset.UTC);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(string);
        return offsetDateTime.toInstant();
    }

    public static String instantToString(Instant instant) {
        return ComponentTime.instantToString(instant, true);
    }

    public static String instantToString(Instant instant, boolean bl) {
        return ComponentTime.instantToString(instant, bl, false);
    }

    public static String instantToString(Instant instant, boolean bl, boolean bl2) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        String string = localDateTime.format(ISO_FORMATTER);
        if (bl2) {
            string = string.substring(0, string.indexOf(46));
        } else if (string.endsWith("000")) {
            string = string.substring(0, string.length() - 3);
        }
        if (bl) {
            string = string + "Z";
        }
        return string;
    }

    public static Instant maxFractional(Instant instant) {
        long l = 999999999L - (long)instant.getNano();
        if (l < 999L) {
            l = 999L - l;
            instant = instant.minusNanos(l);
        } else if (l > 999L) {
            instant = instant.plusNanos(l -= 999L);
        }
        return instant;
    }

    public static long instantToStamp(Instant instant) {
        long l;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        long l2 = localDateTime.getYear();
        long l3 = localDateTime.getMonthValue();
        long l4 = localDateTime.getDayOfMonth();
        long l5 = localDateTime.getHour();
        long l6 = localDateTime.getMinute();
        long l7 = localDateTime.getSecond();
        long l8 = l = (long)localDateTime.getNano() / 1000L;
        l8 |= l2 << 46;
        l8 |= l3 << 42;
        l8 |= l4 << 37;
        l8 |= l5 << 32;
        l8 |= l6 << 26;
        return l8 |= l7 << 20;
    }
}

