/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.util.HashMap;

class Evaluator {
    static final String MODIFIER_NOT = "not";
    static HashMap<EvaluatorCode, String> Operator = new HashMap();
    static HashMap<EvaluatorCode, String> Modifier = new HashMap();

    Evaluator() {
    }

    public static boolean requires_12_2(EvaluatorCode evaluatorCode) {
        if (evaluatorCode == null) {
            return false;
        }
        switch (evaluatorCode) {
            case $hasSubstring: 
            case $instr: 
            case $like: 
            case $double: 
            case $number: 
            case $string: 
            case $date: 
            case $timestamp: 
            case $boolean: 
            case $ceiling: 
            case $floor: 
            case $abs: 
            case $upper: 
            case $lower: 
            case $type: 
            case $length: 
            case $size: 
            case $near: 
            case $within: 
            case $intersects: {
                return true;
            }
        }
        return false;
    }

    public static boolean requires_12_2(String string) {
        EvaluatorCode evaluatorCode = null;
        if (string == null) {
            return false;
        }
        try {
            evaluatorCode = EvaluatorCode.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            evaluatorCode = null;
        }
        return Evaluator.requires_12_2(evaluatorCode);
    }

    static {
        Operator.put(EvaluatorCode.$gt, ">");
        Operator.put(EvaluatorCode.$lt, "<");
        Operator.put(EvaluatorCode.$gte, ">=");
        Operator.put(EvaluatorCode.$lte, "<=");
        Operator.put(EvaluatorCode.$ge, ">=");
        Operator.put(EvaluatorCode.$le, "<=");
        Operator.put(EvaluatorCode.$eq, "==");
        Operator.put(EvaluatorCode.$ne, "!=");
        Operator.put(EvaluatorCode.$exists, "exists");
        Operator.put(EvaluatorCode.$in, "in");
        Operator.put(EvaluatorCode.$nin, "not_in");
        Operator.put(EvaluatorCode.$between, "between");
        Operator.put(EvaluatorCode.$startsWith, "starts with");
        Operator.put(EvaluatorCode.$regex, "eq_regex");
        Operator.put(EvaluatorCode.$likeRegex, "like_regex");
        Operator.put(EvaluatorCode.$ciRegex, "ci_regex");
        Operator.put(EvaluatorCode.$ciLikeRegex, "ci_like_regex");
        Operator.put(EvaluatorCode.$hasSubstring, "has substring");
        Operator.put(EvaluatorCode.$instr, "has substring");
        Operator.put(EvaluatorCode.$like, "like");
        Operator.put(EvaluatorCode.$id, "id");
        Modifier.put(EvaluatorCode.$not, MODIFIER_NOT);
        Modifier.put(EvaluatorCode.$double, "double");
        Modifier.put(EvaluatorCode.$number, "number");
        Modifier.put(EvaluatorCode.$string, "string");
        Modifier.put(EvaluatorCode.$date, "date");
        Modifier.put(EvaluatorCode.$timestamp, "timestamp");
        Modifier.put(EvaluatorCode.$boolean, "boolean");
        Modifier.put(EvaluatorCode.$binary, "binary");
        Modifier.put(EvaluatorCode.$ceiling, "ceiling");
        Modifier.put(EvaluatorCode.$floor, "floor");
        Modifier.put(EvaluatorCode.$abs, "abs");
        Modifier.put(EvaluatorCode.$upper, "upper");
        Modifier.put(EvaluatorCode.$lower, "lower");
        Modifier.put(EvaluatorCode.$type, "type");
        Modifier.put(EvaluatorCode.$length, "length");
        Modifier.put(EvaluatorCode.$size, "size");
        Modifier.put(EvaluatorCode.$numberOnly, "numberOnly");
        Modifier.put(EvaluatorCode.$stringOnly, "stringOnly");
        Modifier.put(EvaluatorCode.$booleanOnly, "booleanOnly");
        Modifier.put(EvaluatorCode.$binaryOnly, "binaryOnly");
        Modifier.put(EvaluatorCode.$dateTimeOnly, "dateTimeOnly");
        Modifier.put(EvaluatorCode.$idOnly, "idOnly");
    }

    static enum EvaluatorCode {
        $and,
        $or,
        $exists,
        $eq,
        $ne,
        $gt,
        $lt,
        $gte,
        $lte,
        $ge,
        $le,
        $in,
        $nin,
        $all,
        $not,
        $nor,
        $between,
        $startsWith,
        $regex,
        $likeRegex,
        $ciRegex,
        $ciLikeRegex,
        $hasSubstring,
        $instr,
        $like,
        $id,
        $sqlJson,
        $double,
        $number,
        $string,
        $date,
        $timestamp,
        $boolean,
        $binary,
        $ceiling,
        $floor,
        $abs,
        $upper,
        $lower,
        $type,
        $length,
        $size,
        $numberOnly,
        $stringOnly,
        $booleanOnly,
        $dateTimeOnly,
        $binaryOnly,
        $idOnly,
        $near,
        $within,
        $intersects,
        $contains,
        $orderby;

    }
}

