/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import oracle.jdbc.OraclePreparedStatement;
import oracle.json.common.Configuration;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.AndORNode;
import oracle.json.parser.ContainsClause;
import oracle.json.parser.Evaluator;
import oracle.json.parser.FilterLoader;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.OrderBySpecification;
import oracle.json.parser.Predicate;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.parser.SpatialClause;
import oracle.json.parser.SqlJsonClause;
import oracle.json.parser.ValueTypePair;
import oracle.sql.json.OracleJsonValue;

public class AndORTree {
    private static final String NULL = "null";
    private AndORNode root;
    private ArrayList<ValueTypePair> valueArray = new ArrayList();
    private ArrayList<Predicate> orderByArray = new ArrayList();
    private HashSet<String> keysSet = new HashSet();
    private String predChar = "@";
    private StringBuilder jsonExists;
    private boolean need_12_2 = false;
    private boolean strictTypeMode = false;
    boolean strictTypeMatching = false;
    private static final boolean WRAP_TEMPORAL = false;
    private static final String FIELDS_ARRAY = "$fields";
    private static final String LAX = "$lax";
    private static final String SCALAR_REQ = "$scalarRequired";
    public static final String ERROR_ON_ERROR = "error on error";
    public static final String ERROR_ON_ERROR_NULL_ON_EMPTY = "error on error null on empty";
    public static final String NULL_ON_ERROR = "null on error";
    private int bookmark_start = -1;
    private Evaluator.EvaluatorCode bookmarkedModifier = null;
    private int numBinds;
    private ArrayList<SqlJsonClause> sjClauses = null;
    private ArrayList<SpatialClause> spatialClauses = null;
    private ArrayList<ContainsClause> containsClauses = null;

    private AndORTree(boolean bl) {
        this.strictTypeMode = bl;
    }

    public ArrayList<ValueTypePair> getValueArray() {
        return this.valueArray;
    }

    public void checkStringValues(int n) throws QueryException {
        if (this.valueArray == null) {
            return;
        }
        for (ValueTypePair valueTypePair : this.valueArray) {
            int n2;
            String string = valueTypePair.getStringValue();
            if (string == null || (n2 = string.length()) * 3 <= n) continue;
            if (n2 <= n) {
                n2 = string.getBytes(Configuration.DEFAULT_CHARSET).length;
            }
            if (n2 <= n) continue;
            QueryException.throwSyntaxException(QueryMessage.EX_STRING_BIND_TOO_LONG, n2, n);
        }
    }

    public ArrayList<Predicate> getOrderByArray() {
        return this.orderByArray;
    }

    public HashSet<String> getKeys() {
        return this.keysSet;
    }

    String getPredChar() {
        return this.predChar;
    }

    private void addToOrderByArray(Predicate predicate) {
        this.orderByArray.add(predicate);
    }

    void addToKeys(String string) {
        this.keysSet.add(string);
    }

    void checkCompatibility(Evaluator.EvaluatorCode evaluatorCode) {
        if (Evaluator.requires_12_2(evaluatorCode)) {
            this.need_12_2 = true;
        }
    }

    String getScalarKey(JsonValue jsonValue) throws QueryException {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.STRING) {
            return ((JsonString)jsonValue).getString();
        }
        if (valueType == JsonValue.ValueType.NUMBER) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            BigDecimal bigDecimal = jsonNumber.bigDecimalValue().stripTrailingZeros();
            if (bigDecimal.scale() <= 0) {
                return bigDecimal.toBigInteger().toString();
            }
            return bigDecimal.toPlainString();
        }
        QueryException.throwSyntaxException(QueryMessage.EX_NON_SCALAR_KEY, new Object[0]);
        return null;
    }

    static boolean isJSONPrimitive(JsonValue jsonValue) {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        return valueType != JsonValue.ValueType.ARRAY && valueType != JsonValue.ValueType.OBJECT;
    }

    static boolean isJSONArray(JsonValue jsonValue) {
        return jsonValue.getValueType() == JsonValue.ValueType.ARRAY;
    }

    static boolean isJSONObject(JsonValue jsonValue) {
        return jsonValue.getValueType() == JsonValue.ValueType.OBJECT;
    }

    static ValueTypePair createBindValue(JsonValue jsonValue, String string, boolean bl) throws QueryException {
        ValueTypePair valueTypePair = null;
        boolean bl2 = false;
        if (AndORTree.isJSONPrimitive(jsonValue)) {
            bl2 = jsonValue.getValueType() == JsonValue.ValueType.NULL || jsonValue.getValueType() == JsonValue.ValueType.TRUE || jsonValue.getValueType() == JsonValue.ValueType.FALSE;
            valueTypePair = new ValueTypePair(jsonValue);
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_SCALAR, string);
        }
        if (bl2 && !bl) {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_NOT_BE_LITERAL, string);
        }
        return valueTypePair;
    }

    ValueTypePair addToValueArray(JsonValue jsonValue, String string) throws QueryException {
        ValueTypePair valueTypePair = AndORTree.createBindValue(jsonValue, string, true);
        if (valueTypePair != null) {
            this.valueArray.add(valueTypePair);
        }
        return valueTypePair;
    }

    ValueTypePair addToValueArray(String string) {
        ValueTypePair valueTypePair = new ValueTypePair(string);
        if (valueTypePair != null) {
            this.valueArray.add(valueTypePair);
        }
        return valueTypePair;
    }

    void setValBookmark(Evaluator.EvaluatorCode evaluatorCode) {
    }

    void endValBookmark() {
        if (this.bookmarkedModifier != null) {
            boolean bl;
            boolean bl2 = this.bookmarkedModifier == Evaluator.EvaluatorCode.$date;
            boolean bl3 = bl = this.bookmarkedModifier == Evaluator.EvaluatorCode.$timestamp;
            if (bl2 || bl) {
                for (int i = this.bookmark_start; i < this.getNumVals(); ++i) {
                    ValueTypePair valueTypePair = this.valueArray.get(i);
                    valueTypePair = ValueTypePair.makeTemporal(valueTypePair, bl);
                    this.valueArray.set(i, valueTypePair);
                }
            }
            this.bookmarkedModifier = null;
            this.bookmark_start = -1;
        }
    }

    int getNextBind() throws QueryException {
        int n = this.getNumVals();
        if (this.numBinds >= n) {
            QueryException.throwExecutionException(QueryMessage.RR_BIND_MISMATCH, Integer.toString(n), Integer.toString(this.numBinds + 1));
        }
        return this.numBinds++;
    }

    void removeBind(int n) {
        this.valueArray.remove(n);
        --this.numBinds;
    }

    int getNumVals() {
        if (this.getValueArray() != null) {
            return this.valueArray.size();
        }
        return 0;
    }

    public static AndORTree createTree(JsonObject jsonObject, boolean bl) throws QueryException {
        OrderBySpecification orderBySpecification = new OrderBySpecification(jsonObject);
        return AndORTree.createTree(jsonObject, orderBySpecification, bl);
    }

    public static AndORTree createTree(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) throws QueryException {
        FilterLoader filterLoader;
        try {
            filterLoader = new FilterLoader(jsonFactoryProvider, inputStream);
        }
        catch (JsonException jsonException) {
            throw new QueryException((Exception)((Object)jsonException));
        }
        return AndORTree.createTree(filterLoader);
    }

    private static void processArrayOrderBy(AndORTree andORTree, JsonArray jsonArray, String string) throws QueryException {
        JsonArray jsonArray2 = jsonArray;
        for (JsonValue jsonValue : jsonArray2) {
            AndORTree.checkIfValueIsJsonObject(jsonValue, "$orderby");
            JsonObject jsonObject = (JsonObject)jsonValue;
            String string2 = null;
            String string3 = null;
            int n = 0;
            boolean bl = true;
            for (Map.Entry entry : jsonObject.entrySet()) {
                String string4 = (String)entry.getKey();
                JsonValue jsonValue2 = (JsonValue)entry.getValue();
                if (string4.equals("path")) {
                    if (!(jsonValue2 instanceof JsonString)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "path", "string");
                    }
                    string2 = ((JsonString)jsonValue2).getString();
                    continue;
                }
                if (string4.equals("datatype")) {
                    if (!(jsonValue2 instanceof JsonString)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "datatype", "string");
                    }
                    string3 = ((JsonString)jsonValue2).getString();
                    continue;
                }
                if (string4.equals("order")) {
                    String string5;
                    if (!(jsonValue2 instanceof JsonString)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "order", "string");
                    }
                    if ((string5 = ((JsonString)jsonValue2).getString()).equals("asc")) {
                        bl = true;
                        continue;
                    }
                    if (string5.equals("desc")) {
                        bl = false;
                        continue;
                    }
                    QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_INVALID_PROP, "order", string5);
                    continue;
                }
                if (string4.equals("maxLength")) {
                    if (!(jsonValue2 instanceof JsonNumber)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "maxLength", "number");
                    }
                    if ((n = ((JsonNumber)jsonValue2).intValue()) > 0) continue;
                    QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_INVALID_PROP, "maxLength", Integer.toString(n));
                    continue;
                }
                QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_UNKNOWN_PROP, string4);
            }
            if (string2 == null) {
                QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_PATH_REQUIRED, new Object[0]);
            }
            if (string3 != null) {
                if (string3.equalsIgnoreCase("number")) {
                    string3 = "number";
                } else if (string3.equalsIgnoreCase("date")) {
                    string3 = "date";
                } else if (string3.equalsIgnoreCase("datetime")) {
                    string3 = "timestamp";
                } else if (string3.equalsIgnoreCase("string") || string3.equalsIgnoreCase("varchar2") || string3.equalsIgnoreCase("varchar")) {
                    string3 = "varchar2";
                    if (n > 0) {
                        string3 = string3 + "(" + Integer.toString(n) + ")";
                    }
                } else {
                    QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_INVALID_PROP, "datatype", string3);
                }
            }
            Predicate predicate = new Predicate(new JsonQueryPath(string2), bl ? "1" : "-1", string3, string);
            andORTree.addToOrderByArray(predicate);
        }
    }

    private static AndORTree createTree(FilterLoader filterLoader) throws QueryException {
        JsonObject jsonObject;
        try {
            JsonStructure jsonStructure = filterLoader.parse();
            if (!(jsonStructure instanceof JsonObject)) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, "filter");
            }
            jsonObject = (JsonObject)jsonStructure;
        }
        catch (JsonParsingException jsonParsingException) {
            if (jsonParsingException.getMessage().equals("SODA FOR JAVA: ENCOUNTERED MULTIPLE $orderby")) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MULTIPLE_OPS, "$orderby");
            }
            if (jsonParsingException.getMessage().equals("SODA FOR JAVA: ENCOUNTERED MULTIPLE $query")) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MULTIPLE_OPS, "$query");
            }
            throw new QueryException((Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException((Exception)((Object)jsonException));
        }
        return AndORTree.createTree(jsonObject, filterLoader.getOrderBySpec(), false);
    }

    private static AndORTree createTree(JsonObject jsonObject, OrderBySpecification orderBySpecification, boolean bl) throws QueryException {
        AndORTree andORTree = new AndORTree(bl);
        AndORNode andORNode = new AndORNode(null);
        andORNode.setEval(Evaluator.EvaluatorCode.$and);
        andORNode.setPredicate(new Predicate(new JsonQueryPath(), null));
        andORTree.root = andORNode;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (jsonObject != null) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonValue jsonValue;
                String string = (String)entry.getKey();
                if (string.equalsIgnoreCase("$project") || string.equalsIgnoreCase("$patch") || string.equalsIgnoreCase("$merge")) {
                    if (bl3) {
                        QueryException.throwSyntaxException(QueryMessage.EX_ENVELOPE_WITH_OTHER_OPS, new Object[0]);
                    }
                    bl4 = true;
                    continue;
                }
                if (string.equalsIgnoreCase("$query")) {
                    if (bl3) {
                        QueryException.throwSyntaxException(QueryMessage.EX_QUERY_WITH_OTHER_OPS, new Object[0]);
                    }
                    bl4 = true;
                    bl2 = true;
                    jsonValue = (JsonValue)entry.getValue();
                    AndORTree.checkIfValueIsJsonObject(jsonValue, "$query");
                    for (Map.Entry entry2 : ((JsonObject)jsonValue).entrySet()) {
                        andORNode.addNode(andORTree, entry2);
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("$orderby")) {
                    if (bl3) {
                        QueryException.throwSyntaxException(QueryMessage.EX_ENVELOPE_WITH_OTHER_OPS, new Object[0]);
                    }
                    bl4 = true;
                    jsonValue = (JsonValue)entry.getValue();
                    if (jsonValue instanceof JsonObject) {
                        Object object;
                        int n;
                        Object object2;
                        String[] stringArray;
                        JsonObject jsonObject2 = (JsonObject)jsonValue;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        JsonArray jsonArray = null;
                        String[] stringArray2 = null;
                        String[] stringArray3 = null;
                        for (Map.Entry entry3 : jsonObject2.entrySet()) {
                            stringArray = (String[])entry3.getKey();
                            if (stringArray.equals(FIELDS_ARRAY)) {
                                object2 = (JsonValue)entry3.getValue();
                                if (!object2.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) continue;
                                jsonArray = (JsonArray)object2;
                                continue;
                            }
                            if (stringArray.equals(SCALAR_REQ)) {
                                object2 = (JsonValue)entry3.getValue();
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.TRUE)) {
                                    bl5 = true;
                                    continue;
                                }
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.FALSE)) continue;
                                stringArray3 = stringArray;
                                continue;
                            }
                            if (stringArray.equals(LAX)) {
                                object2 = (JsonValue)entry3.getValue();
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.TRUE)) {
                                    bl6 = true;
                                    continue;
                                }
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.FALSE)) continue;
                                stringArray3 = stringArray;
                                continue;
                            }
                            stringArray2 = stringArray;
                        }
                        if (jsonArray != null) {
                            if (bl5 && bl6) {
                                QueryException.throwSyntaxException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
                            } else if (stringArray3 != null) {
                                QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", stringArray3, "boolean");
                            } else if (stringArray2 != null) {
                                QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_UNKNOWN_PROP, new Object[]{stringArray2});
                            }
                            if (bl5) {
                                AndORTree.processArrayOrderBy(andORTree, jsonArray, ERROR_ON_ERROR);
                                continue;
                            }
                            if (bl6) {
                                AndORTree.processArrayOrderBy(andORTree, jsonArray, NULL_ON_ERROR);
                                continue;
                            }
                            AndORTree.processArrayOrderBy(andORTree, jsonArray, ERROR_ON_ERROR_NULL_ON_EMPTY);
                            continue;
                        }
                        int n2 = orderBySpecification.getOrderCount();
                        if (n2 <= 0) continue;
                        stringArray = new String[n2];
                        object2 = new int[n2];
                        for (n = 0; n < n2; ++n) {
                            int n3;
                            object = orderBySpecification.getOrderPath(n);
                            String string2 = orderBySpecification.getOrderDirection(n);
                            if (object == null) break;
                            int n4 = 0;
                            if (string2 != null) {
                                try {
                                    n4 = Integer.parseInt(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE, object, string2);
                                }
                                if (n4 == 0) {
                                    QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE, object, string2);
                                }
                            } else {
                                QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE2, object);
                            }
                            int n5 = n4 < 0 ? -n4 : n4;
                            for (n3 = 0; n3 < n; ++n3) {
                                int n6 = object2[n3];
                                if (n6 < 0) {
                                    n6 = -n6;
                                }
                                if (n5 < n6) break;
                            }
                            if (n3 < n) {
                                System.arraycopy(stringArray, n3, stringArray, n3 + 1, n - n3);
                                System.arraycopy(object2, n3, object2, n3 + 1, n - n3);
                            }
                            stringArray[n3] = object;
                            object2[n3] = n4;
                        }
                        n2 = n;
                        for (n = 0; n < n2; ++n) {
                            object = new Predicate(new JsonQueryPath(stringArray[n]), object2[n] < 0 ? "-1" : "1", null, ERROR_ON_ERROR_NULL_ON_EMPTY);
                            andORTree.addToOrderByArray((Predicate)object);
                        }
                        continue;
                    }
                    if (jsonValue instanceof JsonArray) {
                        AndORTree.processArrayOrderBy(andORTree, (JsonArray)jsonValue, ERROR_ON_ERROR_NULL_ON_EMPTY);
                        continue;
                    }
                    QueryException.throwSyntaxException(QueryMessage.EX_BAD_OP_VALUE, "$orderby");
                    continue;
                }
                bl3 = true;
                if (bl2) {
                    QueryException.throwSyntaxException(QueryMessage.EX_QUERY_WITH_OTHER_OPS, new Object[0]);
                }
                if (bl4) {
                    QueryException.throwSyntaxException(QueryMessage.EX_ENVELOPE_WITH_OTHER_OPS, new Object[0]);
                }
                andORNode.addNode(andORTree, entry);
            }
        }
        return andORTree;
    }

    private static void checkIfValueIsJsonObject(JsonValue jsonValue, String string) throws QueryException {
        if (!(jsonValue instanceof JsonObject)) {
            QueryException.throwSyntaxException(QueryMessage.EX_BAD_OP_VALUE, string);
        }
    }

    public boolean hasOrderBy() {
        return !this.getOrderByArray().isEmpty();
    }

    public boolean hasKeys() {
        return !this.getKeys().isEmpty();
    }

    public boolean hasJsonExists() {
        if (this.jsonExists == null) {
            throw new IllegalStateException();
        }
        return this.jsonExists.length() > 0;
    }

    public void generateJsonExists() throws QueryException {
        this.jsonExists = this.root.generateJsonExists(this);
    }

    public void appendJsonExists(StringBuilder stringBuilder) {
        if (this.jsonExists == null) {
            throw new IllegalStateException();
        }
        stringBuilder.append("'$?");
        stringBuilder.append((CharSequence)this.jsonExists);
        stringBuilder.append("'");
        int n = this.getNumVals();
        if (n > 0) {
            stringBuilder.append(" passing ");
            for (int i = 0; i < n; ++i) {
                ValueTypePair valueTypePair = this.valueArray.get(i);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (valueTypePair.isTimestamp()) {
                    stringBuilder.append("TO_TIMESTAMP_TZ(?,'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM')");
                } else if (valueTypePair.isDate()) {
                    stringBuilder.append("TO_DATE(?,'SYYYY-MM-DD\"T\"HH24:MI:SS')");
                } else {
                    stringBuilder.append("?");
                }
                stringBuilder.append(" as \"B");
                stringBuilder.append(Integer.toString(i));
                stringBuilder.append("\"");
            }
        }
    }

    public void appendFormattedBind(StringBuilder stringBuilder, ValueTypePair valueTypePair, SqlJsonClause sqlJsonClause) {
        if (sqlJsonClause == null) {
            stringBuilder.append("?");
            return;
        }
        boolean bl = sqlJsonClause.useDateWrapper();
        boolean bl2 = sqlJsonClause.useTimestampWrapper();
        if (valueTypePair.isNumber()) {
            if (bl || bl2) {
                stringBuilder.append("TO_DATE(((?/1000)+2440588),'J')");
                return;
            }
        } else if (valueTypePair.isString()) {
            if (bl) {
                stringBuilder.append("TO_DATE(?,'YYYY-MM-DD')");
                return;
            }
            if (bl2) {
                stringBuilder.append("TO_TIMESTAMP_TZ(?,'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM')");
                return;
            }
        }
        stringBuilder.append("?");
    }

    void addSqlJsonOperator(SqlJsonClause sqlJsonClause) {
        if (this.sjClauses == null) {
            this.sjClauses = new ArrayList();
        }
        this.sjClauses.add(sqlJsonClause);
    }

    public boolean hasSqlJsonClause() {
        return this.sjClauses != null;
    }

    public List<SqlJsonClause> getSqlJsonOperators() {
        return this.sjClauses;
    }

    void addSpatialOperator(SpatialClause spatialClause) {
        if (this.spatialClauses == null) {
            this.spatialClauses = new ArrayList();
        }
        this.spatialClauses.add(spatialClause);
    }

    public List<SpatialClause> getSpatialOperators() {
        return this.spatialClauses;
    }

    public boolean hasSpatialClause() {
        return this.spatialClauses != null;
    }

    void addContainsClause(ContainsClause containsClause) {
        if (this.containsClauses == null) {
            this.containsClauses = new ArrayList();
        }
        this.containsClauses.add(containsClause);
    }

    public List<ContainsClause> getContainsOperators() {
        return this.containsClauses;
    }

    public boolean hasContainsClause() {
        return this.containsClauses != null;
    }

    public boolean requires_12_2() {
        return this.need_12_2;
    }

    public boolean hasFilterSpec() {
        return this.hasJsonExists() || this.hasSpatialClause() || this.hasContainsClause() || this.hasSqlJsonClause();
    }

    public boolean appendFilerSpec(StringBuilder stringBuilder, boolean bl, String string, String string2) {
        if (this.hasJsonExists()) {
            AndORTree.appendAnd(stringBuilder, bl);
            this.appendFilterSpecJsonExists(stringBuilder, string, string2);
            bl = true;
        }
        if (this.hasSpatialClause()) {
            bl = this.appendSpatialClauses(stringBuilder, bl, string);
        }
        if (this.hasContainsClause()) {
            bl = this.appendFullTextClauses(stringBuilder, bl, string);
        }
        if (this.hasSqlJsonClause()) {
            bl = this.appendSqlJsonClauses(stringBuilder, bl, string);
        }
        return bl;
    }

    private void appendFilterSpecJsonExists(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append("JSON_EXISTS(");
        this.appendColumn(stringBuilder, string);
        if (string2 != null) {
            stringBuilder.append(" ").append(string2);
        }
        stringBuilder.append(",");
        this.appendJsonExists(stringBuilder);
        if (this.strictTypeMode) {
            stringBuilder.append(" type(strict)");
        }
        stringBuilder.append(")");
    }

    public void appendFilterSpecOrderBy(StringBuilder stringBuilder, String string, String string2) throws QueryException {
        ArrayList<Predicate> arrayList = this.getOrderByArray();
        Predicate predicate = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3;
            JsonQueryPath jsonQueryPath;
            predicate = arrayList.get(i);
            if (i != 0) {
                stringBuilder.append(", ");
            }
            if (this.strictTypeMode) {
                stringBuilder.append("JSON_QUERY(");
            } else {
                stringBuilder.append("JSON_VALUE(");
            }
            this.appendColumn(stringBuilder, string);
            if (string2 != null) {
                stringBuilder.append(" ").append(string2);
            }
            if ((jsonQueryPath = predicate.getQueryPath()).hasArraySteps()) {
                throw new QueryException(QueryMessage.EX_ARRAY_STEPS_IN_PATH.get(new Object[0]));
            }
            stringBuilder.append(", '");
            jsonQueryPath.toSingletonString(stringBuilder);
            stringBuilder.append("'");
            String string4 = predicate.getReturnType();
            if (string4 != null) {
                stringBuilder.append(" returning ");
                stringBuilder.append(string4);
            }
            if ((string3 = predicate.getErrorClause()) != null && !string3.equals(NULL_ON_ERROR)) {
                stringBuilder.append(" ");
                stringBuilder.append(string3);
            }
            stringBuilder.append(")");
            if (predicate.getValue().equals("1")) {
                stringBuilder.append(" asc");
                continue;
            }
            stringBuilder.append(" desc");
        }
    }

    private boolean appendSqlJsonClauses(StringBuilder stringBuilder, boolean bl, String string) {
        if (!this.hasSqlJsonClause()) {
            return bl;
        }
        List<SqlJsonClause> list = this.getSqlJsonOperators();
        if (list.size() == 0) {
            return bl;
        }
        for (SqlJsonClause sqlJsonClause : list) {
            int n;
            String string2;
            ValueTypePair valueTypePair;
            String string3;
            AndORTree.appendAnd(stringBuilder, bl);
            bl = true;
            stringBuilder.append(sqlJsonClause.isNot() ? "not(" : "(");
            String string4 = sqlJsonClause.getCompareFunction();
            if (string4 != null) {
                stringBuilder.append(string4);
                stringBuilder.append("(");
            }
            if ((string3 = sqlJsonClause.getConversionFunction()) != null) {
                stringBuilder.append(string3);
                stringBuilder.append("(");
            }
            if (sqlJsonClause.isExists()) {
                stringBuilder.append("JSON_QUERY(");
            } else {
                stringBuilder.append("JSON_VALUE(");
            }
            this.appendColumn(stringBuilder, string);
            stringBuilder.append(", '");
            sqlJsonClause.getPath().toSingletonString(stringBuilder);
            stringBuilder.append("'");
            String string5 = sqlJsonClause.getReturningType();
            if (sqlJsonClause.isExists()) {
                stringBuilder.append(" with array wrapper)");
            } else {
                if (string5 != null) {
                    stringBuilder.append(" returning ");
                    stringBuilder.append(string5);
                }
                stringBuilder.append(")");
            }
            if (string3 != null) {
                stringBuilder.append(")");
            }
            int n2 = 0;
            for (int i = 0; i < sqlJsonClause.getArgCount(); ++i) {
                stringBuilder.append(",");
                valueTypePair = sqlJsonClause.getValue(n2++);
                this.appendFormattedBind(stringBuilder, valueTypePair, sqlJsonClause);
            }
            if (string4 != null) {
                stringBuilder.append(")");
            }
            if ((string2 = sqlJsonClause.getComparator()) != null) {
                stringBuilder.append(" ");
                stringBuilder.append(string2);
            }
            if ((n = sqlJsonClause.getBindCount()) == 1) {
                stringBuilder.append(" ");
                valueTypePair = sqlJsonClause.getValue(n2++);
                this.appendFormattedBind(stringBuilder, valueTypePair, sqlJsonClause);
            } else if (n > 1) {
                stringBuilder.append(" (");
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    valueTypePair = sqlJsonClause.getValue(n2++);
                    this.appendFormattedBind(stringBuilder, valueTypePair, sqlJsonClause);
                }
                stringBuilder.append(")");
            }
            stringBuilder.append(")");
        }
        return bl;
    }

    public static void appendAnd(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(" and ");
        }
    }

    private void appendColumn(StringBuilder stringBuilder, String string) {
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
    }

    private boolean appendFullTextClauses(StringBuilder stringBuilder, boolean bl, String string) {
        if (!this.hasContainsClause()) {
            return bl;
        }
        List<ContainsClause> list = this.getContainsOperators();
        if (list.size() == 0) {
            return bl;
        }
        for (ContainsClause containsClause : list) {
            AndORTree.appendAnd(stringBuilder, bl);
            bl = true;
            if (containsClause.isNot()) {
                stringBuilder.append("not(");
            }
            stringBuilder.append("JSON_TextContains(");
            this.appendColumn(stringBuilder, string);
            stringBuilder.append(", '");
            containsClause.getPath().toLaxString(stringBuilder);
            stringBuilder.append("', ?)");
            if (!containsClause.isNot()) continue;
            stringBuilder.append(")");
        }
        return bl;
    }

    private boolean appendSpatialClauses(StringBuilder stringBuilder, boolean bl, String string) {
        if (!this.hasSpatialClause()) {
            return bl;
        }
        List<SpatialClause> list = this.getSpatialOperators();
        if (list.size() == 0) {
            return bl;
        }
        for (SpatialClause spatialClause : list) {
            AndORTree.appendAnd(stringBuilder, bl);
            bl = true;
            stringBuilder.append("(");
            stringBuilder.append(spatialClause.getOperator());
            stringBuilder.append("(");
            stringBuilder.append("JSON_VALUE(");
            this.appendColumn(stringBuilder, string);
            stringBuilder.append(", '");
            spatialClause.getPath().toSingletonString(stringBuilder);
            stringBuilder.append("' returning SDO_GEOMETRY");
            String string2 = spatialClause.getErrorClause();
            if (string2 != null && !string2.equals(NULL_ON_ERROR)) {
                stringBuilder.append(" ");
                stringBuilder.append(string2);
            }
            stringBuilder.append("),");
            stringBuilder.append("JSON_VALUE(?, '$' returning SDO_GEOMETRY error on error)");
            if (spatialClause.getDistance() != null) {
                stringBuilder.append(", ?");
            }
            if (spatialClause.isNot()) {
                stringBuilder.append(") <> 'TRUE')");
                continue;
            }
            stringBuilder.append(") = 'TRUE')");
        }
        return bl;
    }

    public int bind(PreparedStatement preparedStatement, int n, BiFunction<String, ValueTypePair, Void> biFunction) throws SQLException {
        n = this.bindJsonExists(preparedStatement, n, biFunction);
        n = this.bindSpatialClauses(preparedStatement, n, biFunction);
        n = this.bindContainsClauses(preparedStatement, n, biFunction);
        n = this.bindSqlJsonClauses(preparedStatement, n, biFunction);
        return n;
    }

    private int bindJsonExists(PreparedStatement preparedStatement, int n, BiFunction<String, ValueTypePair, Void> biFunction) throws SQLException {
        int n2 = 0;
        for (ValueTypePair valueTypePair : this.getValueArray()) {
            ++n;
            if (biFunction != null) {
                String string = "B" + Integer.toString(++n2);
                biFunction.apply(string, valueTypePair);
            }
            this.bindTypedParam(preparedStatement, valueTypePair, n);
        }
        return n;
    }

    private int bindSqlJsonClauses(PreparedStatement preparedStatement, int n, BiFunction<String, ValueTypePair, Void> biFunction) throws SQLException {
        List<SqlJsonClause> list = this.getSqlJsonOperators();
        if (list != null) {
            int n2 = 0;
            for (SqlJsonClause sqlJsonClause : list) {
                String string;
                ValueTypePair valueTypePair;
                int n3;
                int n4 = 0;
                for (n3 = 0; n3 < sqlJsonClause.getArgCount(); ++n3) {
                    valueTypePair = sqlJsonClause.getValue(n4++);
                    if (biFunction != null) {
                        string = "JV" + ++n2;
                        biFunction.apply(string, valueTypePair);
                    }
                    this.bindTypedParam(preparedStatement, valueTypePair, ++n);
                }
                for (n3 = 0; n3 < sqlJsonClause.getBindCount(); ++n3) {
                    valueTypePair = sqlJsonClause.getValue(n4++);
                    if (biFunction != null) {
                        string = "JV" + ++n2;
                        biFunction.apply(string, valueTypePair);
                    }
                    this.bindTypedParam(preparedStatement, valueTypePair, ++n);
                }
            }
        }
        return n;
    }

    private int bindContainsClauses(PreparedStatement preparedStatement, int n, BiFunction<String, ValueTypePair, Void> biFunction) throws SQLException {
        List<ContainsClause> list = this.getContainsOperators();
        if (list != null) {
            int n2 = 0;
            for (ContainsClause containsClause : list) {
                String string = containsClause.getSearchString();
                if (string == null) continue;
                if (biFunction != null) {
                    String string2 = "TXT" + Integer.toString(++n2);
                    biFunction.apply(string2, new ValueTypePair(string));
                }
                preparedStatement.setString(++n, string);
            }
        }
        return n;
    }

    private int bindSpatialClauses(PreparedStatement preparedStatement, int n, BiFunction<String, ValueTypePair, Void> biFunction) throws SQLException {
        List<SpatialClause> list = this.getSpatialOperators();
        if (list != null) {
            int n2 = 0;
            for (SpatialClause spatialClause : list) {
                String string;
                String string2 = spatialClause.getReference();
                String string3 = spatialClause.getDistance();
                if (string2 == null) continue;
                if (biFunction != null) {
                    string = "GEO" + Integer.toString(++n2);
                    biFunction.apply(string, new ValueTypePair(string2));
                }
                preparedStatement.setString(++n, string2);
                if (string3 == null) continue;
                if (biFunction != null) {
                    string = "GEO" + Integer.toString(++n2);
                    biFunction.apply(string, new ValueTypePair(string3));
                }
                preparedStatement.setString(++n, string3);
            }
        }
        return n;
    }

    private void bindTypedParam(PreparedStatement preparedStatement, ValueTypePair valueTypePair, int n) throws SQLException {
        if (this.strictTypeMode) {
            this.bindTypedParameterStrict(preparedStatement, valueTypePair, n);
        } else {
            this.bindTypedParamLax(preparedStatement, valueTypePair, n);
        }
    }

    private void bindTypedParamLax(PreparedStatement preparedStatement, ValueTypePair valueTypePair, int n) throws SQLException {
        JsonValue jsonValue = valueTypePair.getValue();
        switch (jsonValue.getValueType()) {
            case NUMBER: {
                preparedStatement.setBigDecimal(n, valueTypePair.getNumberValue());
                break;
            }
            case STRING: {
                preparedStatement.setString(n, valueTypePair.getStringValue());
                break;
            }
            case TRUE: 
            case FALSE: {
                preparedStatement.setString(n, String.valueOf(valueTypePair.getBooleanValue()));
                break;
            }
            case NULL: {
                preparedStatement.setString(n, NULL);
                break;
            }
            case ARRAY: 
            case OBJECT: {
                throw new IllegalStateException();
            }
        }
    }

    private void bindTypedParameterStrict(PreparedStatement preparedStatement, ValueTypePair valueTypePair, int n) throws SQLException {
        Wrapper wrapper;
        JsonValue jsonValue = valueTypePair.getValue();
        if (jsonValue instanceof Wrapper && (wrapper = (Wrapper)jsonValue).isWrapperFor(OracleJsonValue.class)) {
            this.bindTypedParameterStrict(preparedStatement, wrapper.unwrap(OracleJsonValue.class), n);
            return;
        }
        switch (jsonValue.getValueType()) {
            case TRUE: 
            case FALSE: 
            case NULL: 
            case ARRAY: 
            case OBJECT: {
                preparedStatement.setObject(n, jsonValue);
                break;
            }
            case NUMBER: {
                preparedStatement.setBigDecimal(n, ((JsonNumber)jsonValue).bigDecimalValue());
                break;
            }
            case STRING: {
                preparedStatement.setString(n, ((JsonString)jsonValue).getString());
                break;
            }
        }
    }

    private void bindTypedParameterStrict(PreparedStatement preparedStatement, OracleJsonValue oracleJsonValue, int n) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        switch (oracleJsonValue.getOracleJsonType()) {
            case ARRAY: 
            case OBJECT: 
            case NULL: 
            case TRUE: 
            case FALSE: {
                preparedStatement.setObject(n, oracleJsonValue);
                break;
            }
            case BINARY: {
                oraclePreparedStatement.setRAW(n, oracleJsonValue.asJsonBinary().getRAW());
                break;
            }
            case DATE: {
                oraclePreparedStatement.setDATE(n, oracleJsonValue.asJsonDate().getDATE());
                break;
            }
            case TIMESTAMP: {
                oraclePreparedStatement.setTIMESTAMP(n, oracleJsonValue.asJsonTimestamp().getTIMESTAMP());
                break;
            }
            case TIMESTAMPTZ: {
                oraclePreparedStatement.setTIMESTAMPTZ(n, oracleJsonValue.asJsonTimestampTZ().getTIMESTAMPTZ());
                break;
            }
            case DECIMAL: {
                oraclePreparedStatement.setNUMBER(n, oracleJsonValue.asJsonDecimal().getNUMBER());
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                preparedStatement.setBigDecimal(n, oracleJsonValue.asJsonNumber().bigDecimalValue());
                break;
            }
            case INTERVALDS: {
                oraclePreparedStatement.setINTERVALDS(n, oracleJsonValue.asJsonIntervalDS().getINTERVALDS());
                break;
            }
            case INTERVALYM: {
                oraclePreparedStatement.setINTERVALYM(n, oracleJsonValue.asJsonIntervalYM().getINTERVALYM());
                break;
            }
            case STRING: {
                oraclePreparedStatement.setCHAR(n, oracleJsonValue.asJsonString().getCHAR());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

