/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.json.parser.AndORTree;
import oracle.json.parser.ContainsClause;
import oracle.json.parser.Evaluator;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.Predicate;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.parser.SpatialClause;
import oracle.json.parser.SqlJsonClause;
import oracle.json.parser.ValueTypePair;

class AndORNode {
    private static final int KEY_TYPE_OPERATOR = 1;
    private static final int KEY_TYPE_AND = 2;
    private static final int KEY_TYPE_OR = 3;
    private static final int KEY_TYPE_LEAF = 4;
    private static final int KEY_TYPE_ID = 5;
    private static final int KEY_TYPE_NOR = 6;
    private static final int KEY_TYPE_SPATIAL = 7;
    private static final int KEY_TYPE_FULLTEXT = 8;
    private static final int KEY_TYPE_MODIFIER = 9;
    private static final int KEY_TYPE_SQLJSON = 10;
    private Evaluator.EvaluatorCode eval;
    private Predicate predicate;
    private List<AndORNode> children = new ArrayList<AndORNode>();
    private final AndORNode parent;
    private int numVals = 0;
    private JsonQueryPath downScopePath = null;
    private boolean notOp = false;
    static final boolean restrictedSqlJson = true;
    private static final boolean useSqlNotIn = false;
    private static final boolean generateNIN = false;

    public AndORNode(AndORNode andORNode) {
        this.parent = andORNode;
    }

    Evaluator.EvaluatorCode getEval() {
        return this.eval;
    }

    AndORNode getParent() {
        return this.parent;
    }

    int getNumVals() {
        return this.numVals;
    }

    String getDownScopePath() {
        if (this.downScopePath != null) {
            return this.downScopePath.toQueryString();
        }
        return null;
    }

    Predicate getPredicate() {
        return this.predicate;
    }

    boolean getNotOperation() {
        return this.notOp;
    }

    void setEval(Evaluator.EvaluatorCode evaluatorCode) {
        this.eval = evaluatorCode;
    }

    private void setPredicatePath(String string) throws QueryException {
        this.downScopePath = new JsonQueryPath(string);
    }

    private void incrementNumVals() {
        ++this.numVals;
    }

    void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    private void setNotOperation() {
        this.notOp = true;
    }

    private void clearNotOperation() {
        this.notOp = false;
    }

    private static Evaluator.EvaluatorCode codeFor(String string) throws QueryException {
        Evaluator.EvaluatorCode evaluatorCode = null;
        try {
            evaluatorCode = Evaluator.EvaluatorCode.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            QueryException.throwSyntaxException(QueryMessage.EX_NOT_AN_OPERATOR, string);
        }
        return evaluatorCode;
    }

    private static JsonValue.ValueType checkScalarType(Evaluator.EvaluatorCode evaluatorCode, String string, ValueTypePair valueTypePair) throws QueryException {
        JsonValue.ValueType valueType = valueTypePair.getValue().getValueType();
        if (evaluatorCode == Evaluator.EvaluatorCode.$startsWith || evaluatorCode == Evaluator.EvaluatorCode.$hasSubstring || evaluatorCode == Evaluator.EvaluatorCode.$instr || evaluatorCode == Evaluator.EvaluatorCode.$like || evaluatorCode == Evaluator.EvaluatorCode.$regex || evaluatorCode == Evaluator.EvaluatorCode.$likeRegex || evaluatorCode == Evaluator.EvaluatorCode.$ciRegex || evaluatorCode == Evaluator.EvaluatorCode.$ciLikeRegex) {
            if (valueType != JsonValue.ValueType.STRING) {
                QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_STRING, string);
            }
        } else if (evaluatorCode != Evaluator.EvaluatorCode.$eq && evaluatorCode != Evaluator.EvaluatorCode.$ne && evaluatorCode != Evaluator.EvaluatorCode.$exists && (valueType == JsonValue.ValueType.TRUE || valueType == JsonValue.ValueType.FALSE || valueType == JsonValue.ValueType.NULL)) {
            QueryException.throwSyntaxException(QueryMessage.EX_OPERAND_INVALID, string, valueType.toString());
        }
        return valueType;
    }

    static boolean isReversedExists(ValueTypePair valueTypePair) {
        boolean bl = false;
        if (valueTypePair.isBoolean()) {
            if (!valueTypePair.getBooleanValue()) {
                bl = true;
            }
        } else if (valueTypePair.getValue() == JsonValue.NULL) {
            bl = true;
        } else if (valueTypePair.isNumber() && BigDecimal.ZERO.equals(valueTypePair.getNumberValue())) {
            bl = true;
        }
        return bl;
    }

    static int getKeyType(String string) throws QueryException {
        int n = 0;
        if (string.length() == 0) {
            n = 4;
        } else if (string.charAt(0) != '$') {
            n = 4;
        } else if (string.equalsIgnoreCase("$and")) {
            n = 2;
        } else if (string.equalsIgnoreCase("$or")) {
            n = 3;
        } else if (string.equalsIgnoreCase("$nor")) {
            n = 6;
        } else if (string.equalsIgnoreCase("$sqlJson")) {
            n = 10;
        } else if (string.equalsIgnoreCase("$id")) {
            n = 5;
        } else if (string.equalsIgnoreCase("$near") || string.equalsIgnoreCase("$within") || string.equalsIgnoreCase("$intersects")) {
            n = 7;
        } else if (string.equalsIgnoreCase("$contains")) {
            n = 8;
        } else if (string.equalsIgnoreCase("$gt") || string.equalsIgnoreCase("$gte") || string.equalsIgnoreCase("$ge") || string.equalsIgnoreCase("$lt") || string.equalsIgnoreCase("$lte") || string.equalsIgnoreCase("$le") || string.equalsIgnoreCase("$eq") || string.equalsIgnoreCase("$ne") || string.equalsIgnoreCase("$in") || string.equalsIgnoreCase("$nin") || string.equalsIgnoreCase("$all") || string.equalsIgnoreCase("$between") || string.equalsIgnoreCase("$regex") || string.equalsIgnoreCase("$likeRegex") || string.equalsIgnoreCase("$ciRegex") || string.equalsIgnoreCase("$ciLikeRegex") || string.equalsIgnoreCase("$exists") || string.equalsIgnoreCase("$hasSubstring") || string.equalsIgnoreCase("$instr") || string.equalsIgnoreCase("$like") || string.equalsIgnoreCase("$startsWith")) {
            n = 1;
        } else if (string.equalsIgnoreCase("$double") || string.equalsIgnoreCase("$number") || string.equalsIgnoreCase("$string") || string.equalsIgnoreCase("$date") || string.equalsIgnoreCase("$timestamp") || string.equalsIgnoreCase("$boolean") || string.equalsIgnoreCase("$binary") || string.equalsIgnoreCase("$numberOnly") || string.equalsIgnoreCase("$stringOnly") || string.equalsIgnoreCase("$booleanOnly") || string.equalsIgnoreCase("$binaryOnly") || string.equalsIgnoreCase("$dateTimeOnly") || string.equalsIgnoreCase("$idOnly") || string.equalsIgnoreCase("$ceiling") || string.equalsIgnoreCase("$floor") || string.equalsIgnoreCase("$abs") || string.equalsIgnoreCase("$upper") || string.equalsIgnoreCase("$lower") || string.equalsIgnoreCase("$type") || string.equalsIgnoreCase("$length") || string.equalsIgnoreCase("$size") || string.equalsIgnoreCase("$not")) {
            n = 9;
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_NOT_AN_OPERATOR, string);
        }
        return n;
    }

    private void addArrayValues(AndORTree andORTree, JsonValue jsonValue, String string, boolean bl) throws QueryException {
        JsonArray jsonArray = (JsonArray)jsonValue;
        if (!bl && jsonArray.size() == 0) {
            QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
        }
        for (JsonValue jsonValue2 : jsonArray) {
            if (AndORTree.isJSONObject(jsonValue2)) {
                QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_SCALAR, string);
            }
            this.incrementNumVals();
            andORTree.addToValueArray(jsonValue2, string);
        }
    }

    private int addBetweenValues(AndORTree andORTree, JsonValue jsonValue, String string) throws QueryException {
        JsonArray jsonArray;
        if (!AndORTree.isJSONArray(jsonValue)) {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string);
        }
        if ((jsonArray = (JsonArray)jsonValue).size() != 2) {
            QueryException.throwSyntaxException(QueryMessage.EX_BETWEEN_ARGUMENT, string);
        }
        JsonValue jsonValue2 = (JsonValue)jsonArray.get(0);
        JsonValue jsonValue3 = (JsonValue)jsonArray.get(1);
        if (jsonValue2 == null || jsonValue3 == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_BETWEEN_ARGUMENT, string);
        } else {
            JsonValue.ValueType valueType = jsonValue2.getValueType();
            JsonValue.ValueType valueType2 = jsonValue3.getValueType();
            if (valueType == JsonValue.ValueType.NULL) {
                if (valueType2 == JsonValue.ValueType.NULL) {
                    QueryException.throwSyntaxException(QueryMessage.EX_BETWEEN_ARGUMENT, string);
                }
                andORTree.addToValueArray(jsonValue3, string);
                return 1;
            }
            if (valueType2 == JsonValue.ValueType.NULL) {
                andORTree.addToValueArray(jsonValue2, string);
                return -1;
            }
            andORTree.addToValueArray(jsonValue2, string);
            andORTree.addToValueArray(jsonValue3, string);
        }
        return 0;
    }

    private int addBetweenValues(AndORTree andORTree, JsonQueryPath jsonQueryPath, Evaluator.EvaluatorCode evaluatorCode, boolean bl, JsonValue jsonValue, String string) throws QueryException {
        JsonArray jsonArray;
        if (!AndORTree.isJSONArray(jsonValue)) {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string);
        }
        if ((jsonArray = (JsonArray)jsonValue).size() != 2) {
            QueryException.throwSyntaxException(QueryMessage.EX_BETWEEN_ARGUMENT, string);
        }
        JsonValue jsonValue2 = (JsonValue)jsonArray.get(0);
        JsonValue jsonValue3 = (JsonValue)jsonArray.get(1);
        if (jsonValue2 == null || jsonValue3 == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_BETWEEN_ARGUMENT, string);
        } else {
            JsonValue.ValueType valueType = jsonValue2.getValueType();
            JsonValue.ValueType valueType2 = jsonValue3.getValueType();
            if (valueType == JsonValue.ValueType.NULL) {
                if (valueType2 == JsonValue.ValueType.NULL) {
                    QueryException.throwSyntaxException(QueryMessage.EX_BETWEEN_ARGUMENT, string);
                }
                SqlJsonClause sqlJsonClause = new SqlJsonClause(Evaluator.EvaluatorCode.$lte, jsonQueryPath);
                sqlJsonClause.addModifier(evaluatorCode, string);
                sqlJsonClause.setNot(bl);
                sqlJsonClause.addBind(jsonValue3, string);
                andORTree.addSqlJsonOperator(sqlJsonClause);
                return 1;
            }
            if (valueType2 == JsonValue.ValueType.NULL) {
                SqlJsonClause sqlJsonClause = new SqlJsonClause(Evaluator.EvaluatorCode.$gte, jsonQueryPath);
                sqlJsonClause.addModifier(evaluatorCode, string);
                sqlJsonClause.setNot(bl);
                sqlJsonClause.addBind(jsonValue2, string);
                andORTree.addSqlJsonOperator(sqlJsonClause);
                return -1;
            }
            SqlJsonClause sqlJsonClause = new SqlJsonClause(Evaluator.EvaluatorCode.$gte, jsonQueryPath);
            sqlJsonClause.addModifier(evaluatorCode, string);
            sqlJsonClause.setNot(bl);
            sqlJsonClause.addBind(jsonValue2, string);
            andORTree.addSqlJsonOperator(sqlJsonClause);
            sqlJsonClause = new SqlJsonClause(Evaluator.EvaluatorCode.$lte, jsonQueryPath);
            sqlJsonClause.addModifier(evaluatorCode, string);
            sqlJsonClause.setNot(bl);
            sqlJsonClause.addBind(jsonValue3, string);
            andORTree.addSqlJsonOperator(sqlJsonClause);
        }
        return 0;
    }

    private void parseSpatialOperator(AndORTree andORTree, String string, boolean bl, JsonQueryPath jsonQueryPath, JsonValue jsonValue) throws QueryException {
        Object object;
        Object object2;
        if (this.parent != null) {
            QueryException.throwSyntaxException(QueryMessage.EX_SPATIAL_MISPLACED, new Object[0]);
        }
        if (!AndORTree.isJSONObject(jsonValue)) {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string);
        }
        JsonObject jsonObject = (JsonObject)jsonValue;
        Set set = jsonObject.entrySet();
        Iterator iterator = set.iterator();
        andORTree.checkCompatibility(AndORNode.codeFor(string));
        boolean bl2 = string.equals("$near");
        String string2 = SpatialClause.sdoOperatorFor(string);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Boolean bl3 = false;
        Boolean bl4 = false;
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (String)object2.getKey();
            JsonValue jsonValue2 = (JsonValue)object2.getValue();
            JsonValue.ValueType valueType = jsonValue2.getValueType();
            if (((String)object).equals("$geometry")) {
                if (valueType != JsonValue.ValueType.OBJECT) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, object);
                }
                string3 = jsonValue2.toString();
                continue;
            }
            if (((String)object).equals("$distance")) {
                if (!bl2) {
                    QueryException.throwSyntaxException(QueryMessage.EX_OP_FIELD_NOT_ALLOWED, object, string);
                } else if (valueType != JsonValue.ValueType.NUMBER) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_NUMBER, object);
                }
                string4 = jsonValue2.toString();
                continue;
            }
            if (((String)object).equals("$excludeDistance")) {
                if (!bl2) {
                    QueryException.throwSyntaxException(QueryMessage.EX_OP_FIELD_NOT_ALLOWED, object, string);
                } else if (valueType != JsonValue.ValueType.NUMBER) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_NUMBER, object);
                }
                string5 = jsonValue2.toString();
                continue;
            }
            if (((String)object).equals("$unit")) {
                if (!bl2) {
                    QueryException.throwSyntaxException(QueryMessage.EX_OP_FIELD_NOT_ALLOWED, object, string);
                } else if (valueType != JsonValue.ValueType.STRING) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_STRING, object);
                }
                string6 = ((JsonString)jsonValue2).getString();
                continue;
            }
            if (((String)object).equals("$scalarRequired")) {
                if (valueType.equals((Object)JsonValue.ValueType.TRUE)) {
                    bl4 = true;
                    continue;
                }
                if (valueType.equals((Object)JsonValue.ValueType.FALSE)) continue;
                QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, string, object, "boolean");
                continue;
            }
            if (((String)object).equals("$lax")) {
                if (valueType.equals((Object)JsonValue.ValueType.TRUE)) {
                    bl3 = true;
                    continue;
                }
                if (valueType.equals((Object)JsonValue.ValueType.FALSE)) continue;
                QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, string, object, "boolean");
                continue;
            }
            QueryException.throwSyntaxException(QueryMessage.EX_OP_FIELD_UNKNOWN, object, string);
        }
        if (bl3.booleanValue() && bl4.booleanValue()) {
            QueryException.throwSyntaxException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
        }
        String string7 = bl4 != false ? "error on error" : (bl3 != false ? "null on error" : "error on error null on empty");
        if (string3 == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_OP_FIELD_REQUIRED, string, "$geometry");
        }
        object2 = null;
        if (bl2) {
            if (string4 == null) {
                QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
            }
            object2 = SpatialClause.buildDistance(string4, string5, string6);
        }
        object = new SpatialClause(string2, bl, jsonQueryPath, string3, (String)object2, string7);
        andORTree.addSpatialOperator((SpatialClause)object);
    }

    private void parseFullTextOperator(AndORTree andORTree, String string, boolean bl, String string2, JsonQueryPath jsonQueryPath, JsonValue jsonValue) throws QueryException {
        if (this.parent != null) {
            QueryException.throwSyntaxException(QueryMessage.EX_FULLTEXT_MISPLACED, new Object[0]);
        }
        if (jsonValue.getValueType() != JsonValue.ValueType.STRING) {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_STRING, string2);
        }
        andORTree.checkCompatibility(AndORNode.codeFor(string));
        String string3 = ((JsonString)jsonValue).getString();
        andORTree.addContainsClause(new ContainsClause(string3, bl, jsonQueryPath));
    }

    private void parseModifiedSqlJson(AndORTree andORTree, String string, Evaluator.EvaluatorCode evaluatorCode, boolean bl, JsonQueryPath jsonQueryPath, JsonObject jsonObject) throws QueryException {
        Set set = jsonObject.entrySet();
        Iterator iterator = set.iterator();
        if (!iterator.hasNext()) {
            QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
        }
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            JsonValue jsonValue = (JsonValue)entry.getValue();
            if (AndORTree.isJSONArray(jsonValue)) {
                QueryException.throwSyntaxException(QueryMessage.EX_CONTAINER_NOT_ALLOWED, string2, "array");
            } else if (AndORTree.isJSONObject(jsonValue)) {
                QueryException.throwSyntaxException(QueryMessage.EX_CONTAINER_NOT_ALLOWED, string2, "object");
            }
            Evaluator.EvaluatorCode evaluatorCode2 = AndORNode.codeFor(string2);
            andORTree.checkCompatibility(evaluatorCode2);
            if (evaluatorCode2 != Evaluator.EvaluatorCode.$eq && evaluatorCode2 != Evaluator.EvaluatorCode.$le && evaluatorCode2 != Evaluator.EvaluatorCode.$gt && evaluatorCode2 != Evaluator.EvaluatorCode.$lte && evaluatorCode2 != Evaluator.EvaluatorCode.$gte && evaluatorCode2 != Evaluator.EvaluatorCode.$lt && evaluatorCode2 != Evaluator.EvaluatorCode.$gt) {
                QueryException.throwSyntaxException(QueryMessage.EX_UNSUPPORTED_SQLJSON_OP, evaluatorCode2.toString());
            }
            boolean bl2 = false;
            if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                bl2 = true;
            }
            SqlJsonClause sqlJsonClause = new SqlJsonClause(evaluatorCode2, jsonQueryPath, bl2);
            sqlJsonClause.addBind(jsonValue, string2);
            andORTree.addSqlJsonOperator(sqlJsonClause);
        }
    }

    private void parseSqlJson(AndORTree andORTree, JsonObject jsonObject) throws QueryException {
        Set set = jsonObject.entrySet();
        for (Map.Entry entry : set) {
            JsonValue jsonValue = (JsonValue)entry.getValue();
            String string = (String)entry.getKey();
            int n = AndORNode.getKeyType(string);
            if (n != 4) {
                QueryException.throwSyntaxException(QueryMessage.EX_UNEXPECTED_OPERATOR, string);
            }
            JsonQueryPath jsonQueryPath = new JsonQueryPath(string);
            if (AndORTree.isJSONPrimitive(jsonValue)) {
                boolean bl = false;
                if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                    bl = true;
                }
                SqlJsonClause sqlJsonClause = new SqlJsonClause(Evaluator.EvaluatorCode.$eq, jsonQueryPath, bl);
                sqlJsonClause.addBind(jsonValue, string);
                andORTree.addSqlJsonOperator(sqlJsonClause);
                continue;
            }
            if (AndORTree.isJSONObject(jsonValue)) {
                this.parseModifiedSqlJson(andORTree, string, null, false, jsonQueryPath, (JsonObject)jsonValue);
                continue;
            }
            QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        }
    }

    private void parseModifiedOperators(AndORTree andORTree, String string, String string2, JsonQueryPath jsonQueryPath, JsonObject jsonObject) throws QueryException {
        Evaluator.EvaluatorCode evaluatorCode = AndORNode.codeFor(string2);
        boolean bl = evaluatorCode == Evaluator.EvaluatorCode.$not;
        String string3 = string;
        Set set = jsonObject.entrySet();
        Iterator iterator = set.iterator();
        if (!iterator.hasNext()) {
            QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string2);
        }
        if (!bl) {
            string3 = Evaluator.Modifier.get((Object)evaluatorCode);
            if (evaluatorCode != null) {
                andORTree.setValBookmark(evaluatorCode);
            }
        }
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            AndORNode andORNode = new AndORNode(this);
            Predicate predicate = new Predicate(jsonQueryPath, string3);
            this.children.add(andORNode);
            andORNode.predicate = predicate;
            if (bl) {
                andORNode.setNotOperation();
            }
            String string4 = (String)entry.getKey();
            Evaluator.EvaluatorCode evaluatorCode2 = AndORNode.codeFor(string4);
            JsonValue jsonValue = (JsonValue)entry.getValue();
            andORTree.checkCompatibility(evaluatorCode2);
            andORNode.setEval(evaluatorCode2);
            switch (evaluatorCode2) {
                case $all: {
                    if (!AndORTree.isJSONArray(jsonValue)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string4);
                    }
                    if (((JsonArray)jsonValue).size() == 0) {
                        evaluatorCode2 = Evaluator.EvaluatorCode.$in;
                        andORNode.setEval(evaluatorCode2);
                    }
                }
                case $in: 
                case $nin: {
                    if (!AndORTree.isJSONArray(jsonValue)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string4);
                    }
                    andORNode.addArrayValues(andORTree, jsonValue, string4, true);
                    break;
                }
                case $near: 
                case $within: 
                case $intersects: {
                    this.parseSpatialOperator(andORTree, string4, bl, jsonQueryPath, jsonValue);
                    this.children.remove(andORNode);
                    break;
                }
                case $contains: {
                    this.parseFullTextOperator(andORTree, string4, bl, "$contains", jsonQueryPath, jsonValue);
                    this.children.remove(andORNode);
                    break;
                }
                case $between: {
                    int n = andORNode.addBetweenValues(andORTree, jsonValue, jsonQueryPath.toQueryString());
                    if (n < 0) {
                        andORNode.setEval(Evaluator.EvaluatorCode.$gte);
                        break;
                    }
                    if (n > 0) {
                        andORNode.setEval(Evaluator.EvaluatorCode.$lte);
                        break;
                    }
                    AndORNode andORNode2 = this;
                    if (bl && this.parent.eval != Evaluator.EvaluatorCode.$or) {
                        andORNode.setEval(Evaluator.EvaluatorCode.$or);
                        andORNode.clearNotOperation();
                        andORNode.numVals = 0;
                        andORNode2 = andORNode;
                        andORNode = new AndORNode(andORNode2);
                        andORNode2.children.add(andORNode);
                        andORNode.predicate = predicate;
                        if (bl) {
                            andORNode.setNotOperation();
                        }
                    }
                    andORNode.setEval(Evaluator.EvaluatorCode.$gte);
                    andORNode.numVals = 1;
                    andORNode = new AndORNode(andORNode2);
                    andORNode2.children.add(andORNode);
                    andORNode.setEval(Evaluator.EvaluatorCode.$lte);
                    andORNode.numVals = 1;
                    andORNode.predicate = predicate;
                    if (!bl) break;
                    andORNode.setNotOperation();
                    break;
                }
                case $double: 
                case $number: 
                case $string: 
                case $date: 
                case $timestamp: 
                case $boolean: 
                case $binary: 
                case $numberOnly: 
                case $stringOnly: 
                case $booleanOnly: 
                case $binaryOnly: 
                case $dateTimeOnly: 
                case $idOnly: 
                case $ceiling: 
                case $floor: 
                case $abs: 
                case $upper: 
                case $lower: 
                case $type: 
                case $length: 
                case $size: {
                    QueryException.throwSyntaxException(QueryMessage.EX_MOD_IS_NOT_ALLOWED, string2, string4);
                    break;
                }
                case $not: {
                    if (bl) {
                        QueryException.throwSyntaxException(QueryMessage.EX_NOT_IS_NOT_ALLOWED, string4);
                    }
                    if (!AndORTree.isJSONObject(jsonValue)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string4);
                    }
                    AndORNode andORNode2 = this;
                    if (this.eval != Evaluator.EvaluatorCode.$or) {
                        andORNode.setEval(Evaluator.EvaluatorCode.$or);
                        andORNode.clearNotOperation();
                        andORNode2 = andORNode;
                    } else {
                        this.children.remove(andORNode);
                    }
                    andORNode2.parseModifiedOperators(andORTree, string3, string4, jsonQueryPath, (JsonObject)jsonValue);
                    break;
                }
                case $and: 
                case $or: 
                case $nor: 
                case $orderby: 
                case $id: {
                    QueryException.throwSyntaxException(QueryMessage.EX_MOD_IS_NOT_ALLOWED, string2, string4);
                    break;
                }
                case $ne: {
                    if (bl) {
                        andORNode.setEval(Evaluator.EvaluatorCode.$eq);
                        andORNode.clearNotOperation();
                    }
                }
                default: {
                    AndORNode.checkScalarType(evaluatorCode2, string4, andORTree.addToValueArray(jsonValue, string4));
                }
            }
            switch (evaluatorCode2) {
                case $nin: {
                    if (!bl) break;
                    andORNode.setEval(Evaluator.EvaluatorCode.$in);
                    andORNode.clearNotOperation();
                    break;
                }
                case $in: {
                    break;
                }
            }
        }
        andORTree.endValBookmark();
    }

    private void adjustPredicate(JsonQueryPath jsonQueryPath, JsonValue jsonValue) throws QueryException {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.NUMBER) {
            this.predicate = new Predicate(jsonQueryPath, "numberOnly");
        } else if (valueType == JsonValue.ValueType.TRUE || valueType == JsonValue.ValueType.FALSE) {
            this.predicate = new Predicate(jsonQueryPath, "booleanOnly");
        }
    }

    void addNode(AndORTree andORTree, Map.Entry<String, JsonValue> entry) throws QueryException {
        AndORNode andORNode = null;
        String string = entry.getKey();
        int n = AndORNode.getKeyType(string);
        switch (n) {
            case 2: 
            case 3: 
            case 6: {
                Iterator iterator;
                AndORNode andORNode2;
                AndORNode andORNode3 = this;
                if (n == 2) {
                    if (this.getEval() != Evaluator.EvaluatorCode.$and) {
                        andORNode2 = new AndORNode(this);
                        andORNode2.setEval(Evaluator.EvaluatorCode.$and);
                        this.children.add(andORNode2);
                        andORNode3 = andORNode2;
                    }
                } else if (n == 3) {
                    if (this.getEval() != Evaluator.EvaluatorCode.$or || this.getNotOperation()) {
                        andORNode2 = new AndORNode(this);
                        andORNode2.setEval(Evaluator.EvaluatorCode.$or);
                        this.children.add(andORNode2);
                        andORNode3 = andORNode2;
                    }
                } else if (!(n != 6 || this.getEval() == Evaluator.EvaluatorCode.$or && this.getNotOperation())) {
                    andORNode2 = new AndORNode(this);
                    andORNode2.setEval(Evaluator.EvaluatorCode.$or);
                    this.children.add(andORNode2);
                    andORNode3 = andORNode2;
                    andORNode2.setNotOperation();
                }
                if (!AndORTree.isJSONArray(entry.getValue())) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string);
                }
                if (!(iterator = (andORNode2 = (JsonArray)entry.getValue()).iterator()).hasNext()) {
                    QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
                }
                while (iterator.hasNext()) {
                    JsonValue jsonValue = (JsonValue)iterator.next();
                    if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string);
                    }
                    JsonObject jsonObject = (JsonObject)jsonValue;
                    Set set = jsonObject.entrySet();
                    Iterator iterator2 = set.iterator();
                    AndORNode andORNode4 = andORNode3;
                    if (andORNode4.getEval() != Evaluator.EvaluatorCode.$and) {
                        andORNode4 = new AndORNode(andORNode3);
                        andORNode4.setEval(Evaluator.EvaluatorCode.$and);
                        andORNode3.children.add(andORNode4);
                    }
                    if (!iterator2.hasNext()) {
                        QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
                    }
                    while (iterator2.hasNext()) {
                        andORNode4.addNode(andORTree, (Map.Entry)iterator2.next());
                    }
                }
                break;
            }
            case 10: {
                JsonValue jsonValue;
                if (this.parent != null) {
                    QueryException.throwSyntaxException(QueryMessage.EX_SQL_JSON_MISPLACED, string);
                }
                if (!AndORTree.isJSONObject(jsonValue = entry.getValue())) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string);
                }
                this.parseSqlJson(andORTree, (JsonObject)jsonValue);
                break;
            }
            case 5: {
                JsonValue jsonValue;
                if (this.parent != null) {
                    QueryException.throwSyntaxException(QueryMessage.EX_ID_MISPLACED, new Object[0]);
                }
                if (andORTree.hasKeys()) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MULTIPLE_ID_CLAUSES, new Object[0]);
                }
                if (AndORTree.isJSONPrimitive(jsonValue = entry.getValue())) {
                    String string2 = andORTree.getScalarKey(jsonValue);
                    andORTree.addToKeys(string2);
                    break;
                }
                if (AndORTree.isJSONArray(jsonValue)) {
                    JsonArray jsonArray = (JsonArray)jsonValue;
                    for (JsonValue jsonValue2 : jsonArray) {
                        String string3 = andORTree.getScalarKey(jsonValue2);
                        andORTree.addToKeys(string3);
                    }
                    if (andORTree.getKeys().size() > 0) break;
                    QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
                    break;
                }
                QueryException.throwSyntaxException(QueryMessage.EX_NON_SCALAR_KEY, new Object[0]);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                QueryException.throwSyntaxException(QueryMessage.EX_UNEXPECTED_OPERATOR, string);
            }
            default: {
                String string4 = string;
                JsonValue jsonValue = entry.getValue();
                if (AndORTree.isJSONPrimitive(jsonValue)) {
                    andORNode = new AndORNode(this);
                    andORNode.predicate = new Predicate(new JsonQueryPath(string4));
                    andORNode.setEval(Evaluator.EvaluatorCode.$eq);
                    andORTree.addToValueArray(jsonValue, string4);
                    if (andORTree.strictTypeMatching) {
                        andORNode.adjustPredicate(new JsonQueryPath(string4), jsonValue);
                    }
                    this.children.add(andORNode);
                    break;
                }
                if (AndORTree.isJSONObject(jsonValue)) {
                    JsonQueryPath jsonQueryPath;
                    JsonObject jsonObject = (JsonObject)jsonValue;
                    Set set = jsonObject.entrySet();
                    Iterator iterator = set.iterator();
                    int n2 = set.size();
                    if (n2 == 0) {
                        QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string4);
                    }
                    JsonQueryPath jsonQueryPath2 = jsonQueryPath = new JsonQueryPath(string4);
                    boolean bl = false;
                    boolean bl2 = true;
                    AndORNode andORNode5 = this;
                    block17: while (iterator.hasNext()) {
                        AndORNode andORNode6;
                        Evaluator.EvaluatorCode evaluatorCode;
                        Map.Entry entry2 = (Map.Entry)iterator.next();
                        String string5 = (String)entry2.getKey();
                        JsonValue jsonValue3 = (JsonValue)entry2.getValue();
                        int n3 = AndORNode.getKeyType(string5);
                        Object var24_42 = null;
                        if (bl2) {
                            bl2 = false;
                            if (n3 != 4) {
                                boolean bl3;
                                boolean bl4 = bl3 = n2 == 1;
                                if (bl3 && string5.equals("$between")) {
                                    bl3 = false;
                                }
                                if (!bl3) {
                                    andORNode5 = new AndORNode(this);
                                    andORNode5.setEval(Evaluator.EvaluatorCode.$and);
                                    this.children.add(andORNode5);
                                    andORNode5.downScopePath = jsonQueryPath;
                                    jsonQueryPath = new JsonQueryPath();
                                }
                            }
                        }
                        if (n3 == 9) {
                            bl = true;
                            JsonObject jsonObject2 = null;
                            JsonArray jsonArray = null;
                            if (AndORTree.isJSONArray(jsonValue3)) {
                                jsonArray = (JsonArray)jsonValue3;
                                if (jsonArray.size() == 1) {
                                    jsonValue3 = (JsonValue)jsonArray.get(0);
                                    if (AndORTree.isJSONObject(jsonValue3) || AndORTree.isJSONArray(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_SCALAR, string5);
                                    }
                                    jsonArray = null;
                                }
                            } else if (AndORTree.isJSONObject(jsonValue3)) {
                                jsonObject2 = (JsonObject)jsonValue3;
                            }
                            evaluatorCode = AndORNode.codeFor(string5);
                            andORTree.checkCompatibility(evaluatorCode);
                            andORNode6 = andORNode5;
                            if (evaluatorCode == Evaluator.EvaluatorCode.$not) {
                                if (jsonObject2 == null) {
                                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string5);
                                }
                                if (jsonObject2.size() > 1) {
                                    andORNode6 = new AndORNode(andORNode5);
                                    andORNode6.setEval(Evaluator.EvaluatorCode.$or);
                                    andORNode5.children.add(andORNode6);
                                }
                            } else if (andORNode5.getEval() != Evaluator.EvaluatorCode.$and && jsonObject2 != null) {
                                andORNode6 = new AndORNode(andORNode5);
                                andORNode6.setEval(Evaluator.EvaluatorCode.$and);
                                andORNode5.children.add(andORNode6);
                            }
                            if (jsonObject2 != null) {
                                andORNode6.parseModifiedOperators(andORTree, null, string5, jsonQueryPath, jsonObject2);
                                continue;
                            }
                            if (jsonArray != null) {
                                QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string5);
                                continue;
                            }
                            AndORNode andORNode7 = new AndORNode(andORNode6);
                            andORNode6.children.add(andORNode7);
                            andORNode7.predicate = new Predicate(jsonQueryPath, Evaluator.Modifier.get((Object)evaluatorCode));
                            andORNode7.setEval(Evaluator.EvaluatorCode.$eq);
                            andORTree.setValBookmark(evaluatorCode);
                            AndORNode.checkScalarType(andORNode7.getEval(), string5, andORTree.addToValueArray(jsonValue3, Evaluator.Modifier.get((Object)andORNode7.getEval())));
                            andORTree.endValBookmark();
                            continue;
                        }
                        if (n3 == 1) {
                            Evaluator.EvaluatorCode evaluatorCode2 = AndORNode.codeFor(string5);
                            andORTree.checkCompatibility(evaluatorCode2);
                            bl = true;
                            andORNode = new AndORNode(andORNode5);
                            andORNode5.children.add(andORNode);
                            switch (evaluatorCode2) {
                                case $between: {
                                    int n4 = andORNode.addBetweenValues(andORTree, jsonValue3, string5);
                                    evaluatorCode = (JsonArray)jsonValue3;
                                    if (n4 < 0) {
                                        andORNode.setEval(Evaluator.EvaluatorCode.$gte);
                                        andORNode.predicate = new Predicate(jsonQueryPath);
                                        if (!andORTree.strictTypeMatching) continue block17;
                                        andORNode.adjustPredicate(jsonQueryPath, (JsonValue)evaluatorCode.get(0));
                                        break;
                                    }
                                    if (n4 > 0) {
                                        andORNode.setEval(Evaluator.EvaluatorCode.$lte);
                                        andORNode.predicate = new Predicate(jsonQueryPath);
                                        if (!andORTree.strictTypeMatching) continue block17;
                                        andORNode.adjustPredicate(jsonQueryPath, (JsonValue)evaluatorCode.get(1));
                                        break;
                                    }
                                    andORNode.setEval(Evaluator.EvaluatorCode.$and);
                                    andORNode.numVals = 0;
                                    andORNode6 = new AndORNode(andORNode);
                                    andORNode.children.add(andORNode6);
                                    andORNode6.setEval(Evaluator.EvaluatorCode.$gte);
                                    andORNode6.predicate = new Predicate(jsonQueryPath);
                                    andORNode6.numVals = 1;
                                    if (andORTree.strictTypeMatching) {
                                        andORNode6.adjustPredicate(jsonQueryPath, (JsonValue)evaluatorCode.get(0));
                                    }
                                    andORNode6 = new AndORNode(andORNode);
                                    andORNode.children.add(andORNode6);
                                    andORNode6.setEval(Evaluator.EvaluatorCode.$lte);
                                    andORNode6.predicate = new Predicate(jsonQueryPath);
                                    andORNode6.numVals = 1;
                                    if (!andORTree.strictTypeMatching) continue block17;
                                    andORNode6.adjustPredicate(jsonQueryPath, (JsonValue)evaluatorCode.get(1));
                                    break;
                                }
                                case $all: 
                                case $in: 
                                case $nin: {
                                    if (!AndORTree.isJSONArray(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string5);
                                    } else if (evaluatorCode2 == Evaluator.EvaluatorCode.$all && ((JsonArray)jsonValue3).size() == 0) {
                                        evaluatorCode2 = Evaluator.EvaluatorCode.$in;
                                    }
                                    andORNode.addArrayValues(andORTree, jsonValue3, string5, true);
                                    if (evaluatorCode2 == Evaluator.EvaluatorCode.$nin) {
                                        andORNode.setEval(Evaluator.EvaluatorCode.$in);
                                        andORNode.setNotOperation();
                                    } else {
                                        andORNode.setEval(evaluatorCode2);
                                    }
                                    andORNode.predicate = new Predicate(jsonQueryPath);
                                    break;
                                }
                                default: {
                                    if (AndORTree.isJSONArray(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_CONTAINER_NOT_ALLOWED, string5, "array");
                                    } else if (AndORTree.isJSONObject(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_CONTAINER_NOT_ALLOWED, string5, "object");
                                    }
                                    andORNode.predicate = new Predicate(jsonQueryPath);
                                    andORNode.setEval(evaluatorCode2);
                                    if (andORTree.strictTypeMatching) {
                                        andORNode.adjustPredicate(jsonQueryPath, jsonValue3);
                                    }
                                    AndORNode.checkScalarType(evaluatorCode2, string5, andORTree.addToValueArray(jsonValue3, string5));
                                }
                            }
                            continue;
                        }
                        if (AndORNode.getKeyType(string5) == 4 && !bl) {
                            andORNode = new AndORNode(andORNode5);
                            andORNode5.children.add(andORNode);
                            andORNode.setEval(Evaluator.EvaluatorCode.$and);
                            andORNode.downScopePath = jsonQueryPath;
                            andORNode.addNode(andORTree, entry2);
                            while (iterator.hasNext()) {
                                andORNode.addNode(andORTree, (Map.Entry)iterator.next());
                            }
                            continue;
                        }
                        if (n3 == 7) {
                            if (andORNode5 != this) {
                                QueryException.throwSyntaxException(QueryMessage.EX_OPERATOR_NOT_ALLOWED, string5);
                            }
                            this.parseSpatialOperator(andORTree, string5, false, jsonQueryPath2, jsonValue3);
                            continue;
                        }
                        if (n3 == 8) {
                            if (andORNode5 != this) {
                                QueryException.throwSyntaxException(QueryMessage.EX_OPERATOR_NOT_ALLOWED, string5);
                            }
                            this.parseFullTextOperator(andORTree, string5, false, string4, jsonQueryPath2, jsonValue3);
                            continue;
                        }
                        QueryException.throwSyntaxException(QueryMessage.EX_OPERATOR_NOT_ALLOWED, string5);
                    }
                    break;
                }
                if (AndORTree.isJSONArray(jsonValue)) {
                    JsonQueryPath jsonQueryPath = new JsonQueryPath(string4);
                    andORNode = new AndORNode(this);
                    andORNode.addArrayValues(andORTree, jsonValue, string4, true);
                    if (((JsonArray)jsonValue).size() == 0) {
                        andORNode.setEval(Evaluator.EvaluatorCode.$in);
                    } else {
                        andORNode.setEval(Evaluator.EvaluatorCode.$all);
                    }
                    andORNode.predicate = new Predicate(jsonQueryPath);
                    if (andORTree.strictTypeMatching) {
                        JsonArray jsonArray = (JsonArray)jsonValue;
                        boolean bl = jsonArray.size() == 0;
                        boolean bl5 = jsonArray.size() == 0;
                        for (JsonValue jsonValue4 : jsonArray) {
                            switch (jsonValue4.getValueType()) {
                                case NUMBER: {
                                    bl5 = true;
                                    break;
                                }
                                case TRUE: 
                                case FALSE: {
                                    bl = true;
                                    break;
                                }
                                default: {
                                    bl = false;
                                    bl5 = false;
                                }
                            }
                            if (!bl5 || !bl) continue;
                            break;
                        }
                        if (!bl) {
                            andORNode.predicate = new Predicate(jsonQueryPath, "numberOnly");
                        } else if (!bl5) {
                            andORNode.predicate = new Predicate(jsonQueryPath, "booleanOnly");
                        }
                    }
                    this.children.add(andORNode);
                    break;
                }
                QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
            }
        }
    }

    private void appendPathOp(String string, StringBuilder stringBuilder, String string2, String string3) {
        stringBuilder.append(string);
        stringBuilder.append(string2);
        if (string3 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string3);
        }
    }

    private void appendBind(StringBuilder stringBuilder, int n) throws QueryException {
        stringBuilder.append(" $B");
        stringBuilder.append(n);
    }

    private void appendBind(StringBuilder stringBuilder, AndORTree andORTree) throws QueryException {
        this.appendBind(stringBuilder, andORTree.getNextBind());
    }

    private void prependNotWrapper(StringBuilder stringBuilder) {
        stringBuilder.append("(!");
    }

    private void appendNotWrapper(StringBuilder stringBuilder) {
        stringBuilder.append(")");
    }

    StringBuilder generateJsonExists(AndORTree andORTree) throws QueryException {
        StringBuilder stringBuilder = new StringBuilder();
        this.generateJsonExists(andORTree, stringBuilder);
        return stringBuilder;
    }

    private void generateJsonExists(AndORTree andORTree, StringBuilder stringBuilder) throws QueryException {
        if (this.eval == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        }
        String string = null;
        String string2 = Evaluator.Operator.get((Object)this.eval);
        String string3 = " && ";
        boolean bl = false;
        boolean bl2 = false;
        if (this.predicate != null && this.predicate.path != null) {
            string = this.predicate.path.toQueryString(this.predicate.getValue());
        }
        switch (this.eval) {
            case $all: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                string2 = Evaluator.Operator.get((Object)Evaluator.EvaluatorCode.$eq);
                int n = this.getNumVals();
                if (n > 1) {
                    stringBuilder.append("(");
                }
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(string3);
                    }
                    stringBuilder.append("(");
                    this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                    this.appendOrInlineBind(andORTree, stringBuilder);
                    stringBuilder.append(")");
                }
                if (n > 1) {
                    stringBuilder.append(")");
                }
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $nin: {
                QueryException.throwExecutionException(QueryMessage.EX_UNSUPPORTED_OP, new Object[0]);
                break;
            }
            case $in: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                stringBuilder.append("(");
                int n = this.getNumVals();
                if (n == 1) {
                    string2 = Evaluator.Operator.get((Object)Evaluator.EvaluatorCode.$eq);
                    this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                    this.appendOrInlineBind(andORTree, stringBuilder);
                } else {
                    this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                    stringBuilder.append(" (");
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        this.appendOrInlineBind(andORTree, stringBuilder);
                    }
                    stringBuilder.append(")");
                }
                stringBuilder.append(")");
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $exists: {
                boolean bl3 = this.getNotOperation();
                int n = andORTree.getNextBind();
                ValueTypePair valueTypePair = andORTree.getValueArray().get(n);
                if (AndORNode.isReversedExists(valueTypePair)) {
                    boolean bl4 = bl3 = !bl3;
                }
                if (bl3) {
                    this.prependNotWrapper(stringBuilder);
                }
                string = this.predicate.path.toQueryString();
                stringBuilder.append("(exists(");
                this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, null);
                stringBuilder.append(")) ");
                if (bl3) {
                    this.appendNotWrapper(stringBuilder);
                }
                andORTree.removeBind(n);
                break;
            }
            case $or: {
                string3 = " || ";
            }
            case $and: {
                int n;
                String string4;
                if (this.children == null || this.children.size() == 0) {
                    return;
                }
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                if ((string4 = this.getDownScopePath()) != null) {
                    bl = true;
                    stringBuilder.append("( exists(");
                    stringBuilder.append(andORTree.getPredChar());
                    stringBuilder.append(string4);
                    stringBuilder.append("?");
                    bl2 = true;
                }
                if ((n = this.children.size()) > 1) {
                    bl2 = true;
                }
                if (bl2) {
                    stringBuilder.append("( ");
                }
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(string3);
                    }
                    AndORNode andORNode = this.children.get(i);
                    andORNode.generateJsonExists(andORTree, stringBuilder);
                }
                if (bl2) {
                    stringBuilder.append(" )");
                }
                if (bl) {
                    stringBuilder.append(") )");
                }
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $ne: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                this.prependNotWrapper(stringBuilder);
                stringBuilder.append("(");
                this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, Evaluator.Operator.get((Object)Evaluator.EvaluatorCode.$eq));
                this.appendOrInlineBind(andORTree, stringBuilder);
                stringBuilder.append(")");
                this.appendNotWrapper(stringBuilder);
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $near: 
            case $within: 
            case $intersects: 
            case $contains: {
                break;
            }
            default: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                stringBuilder.append("(");
                this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                int n = this.getNumVals();
                if (n <= 1) {
                    this.appendOrInlineBind(andORTree, stringBuilder);
                } else {
                    stringBuilder.append("(");
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        this.appendBind(stringBuilder, andORTree);
                    }
                    stringBuilder.append(")");
                }
                stringBuilder.append(")");
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
            }
        }
    }

    private void appendOrInlineBind(AndORTree andORTree, StringBuilder stringBuilder) throws QueryException {
        String string;
        boolean bl = false;
        int n = andORTree.getNextBind();
        ValueTypePair valueTypePair = andORTree.getValueArray().get(n);
        if (valueTypePair.isBoolean()) {
            stringBuilder.append(valueTypePair.getBooleanValue() ? " true" : " false");
            bl = true;
        } else if (valueTypePair.getValue() == JsonValue.NULL) {
            stringBuilder.append(" null");
            bl = true;
        } else if (valueTypePair.isString() && (string = valueTypePair.getStringValue()) != null && (string.equals("true") || string.equals("false") || string.equals("null"))) {
            stringBuilder.append(" \"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
            bl = true;
        }
        if (!bl) {
            this.appendBind(stringBuilder, n);
        } else {
            andORTree.removeBind(n);
        }
    }
}

