/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.json.common.ResourceManager;

public class CloseableCursor
implements Closeable {
    private static final Logger log = Logger.getLogger(CloseableCursor.class.getName());
    private final ResourceManager mgr;
    private final Statement stmt;
    private final ResultSet rows;

    public CloseableCursor(ResourceManager resourceManager, Statement statement, ResultSet resultSet) {
        this.stmt = statement;
        this.rows = resultSet;
        this.mgr = resourceManager;
        resourceManager.register(this);
    }

    @Override
    public void close() {
        try {
            if (this.rows != null) {
                this.rows.close();
            }
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.getMessage());
        }
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.getMessage());
        }
        if (this.mgr != null) {
            this.mgr.unregister(this);
        }
    }
}

