/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.executors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleDbDirectoryLocation;

public class DataPumpTransfer {
    private static final String NL = "\n";
    private DataPumpModel _model;
    private DataPumpArguments _args;

    public DataPumpTransfer(DataPumpModel model) {
        this._model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean transferFromCloud() throws ProcessFailedException {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_TRANS"));
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return false;
            }
        }
        int i = 0;
        boolean copyFailed = false;
        this._args = this._model.getArgs();
        List fileNames = (List)this._args.get("dumpfile");
        List uris = (List)this._args.get("dumpuri");
        try {
            for (String fileName : fileNames) {
                String tgt = this._args.get("dumpdirectory") + "/" + fileName;
                String src = (String)uris.get(i);
                this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_TRANSFER", src, tgt));
                if (!this._model.ToolLoggerFlushLog()) {
                    this._model.isValid(false);
                    boolean bl = false;
                    return bl;
                }
                CloudStorageUrl csFinalUrl = new CloudStorageUrl(src);
                this._args.put("cloud_url", csFinalUrl);
                Location srcLocation = CSCommon.getOciLocation((Map)this._args);
                OracleDbDirectoryLocation tgtLocation = CSCommon.getDbDirectoryLocation((Connection)this._model.getConn());
                srcLocation.connect();
                try (BufferedInputStream is = new BufferedInputStream(srcLocation.asInputStream(null, 0L, 0L));){
                    tgtLocation.connect();
                    tgtLocation.copy((InputStream)is, tgt);
                    this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPIED", tgt, src) + NL);
                }
                catch (IOException e) {
                    this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", tgt, src) + NL);
                    if (!this._model.ToolLoggerFlushLog()) {
                        this._model.isValid(false);
                        boolean bl = false;
                        if (this._model.isVerbose() || this._model.isDebug()) {
                            this._model.getToolLogger().logProcessEnd();
                        }
                        if (!this._model.ToolLoggerFlushLog()) {
                            this._model.isValid(false);
                            return false;
                        }
                        return bl;
                    }
                    try {
                        throw new ProcessFailedException(e, DataPumpResources.getString("DP_TRANS"));
                    }
                    catch (IOException e2) {
                        this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", tgt, src) + NL);
                        if (!this._model.ToolLoggerFlushLog()) {
                            this._model.isValid(false);
                            boolean bl = false;
                            return bl;
                        }
                        throw new ProcessFailedException(e2, DataPumpResources.getString("DP_TRANS"));
                    }
                }
                ++i;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logProcessEnd();
            }
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return false;
            }
        }
        return this._model.isValid();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean transferToCloud() throws ProcessFailedException {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_TRANS"));
        }
        int i = 0;
        boolean copyFailed = false;
        this._args = this._model.getArgs();
        List fileNames = (List)this._args.get("dumpfile");
        List uris = (List)this._args.get("dumpuri");
        for (String fileName : fileNames) {
            block22: {
                String src = this._args.get("dumpdirectory") + "/" + fileName;
                Path srcPath = new File(src).toPath();
                String tgt = (String)uris.get(i);
                this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_TRANSFER", src, tgt));
                if (!this._model.ToolLoggerFlushLog()) {
                    this._model.isValid(false);
                    return false;
                }
                try {
                    CloudStorageUrl csFinalUrl = new CloudStorageUrl(tgt);
                    this._args.put("cloud_url", csFinalUrl);
                    Location tgtLocation = CSCommon.getOciLocation((Map)this._model.getArgs());
                    OracleDbDirectoryLocation srcLocation = CSCommon.getDbDirectoryLocation((Connection)this._model.getConn());
                    try (BufferedInputStream is = new BufferedInputStream(srcLocation.asInputStream(srcPath, -1L, -1L));){
                        if (tgtLocation != null) {
                            tgtLocation.connect();
                            tgtLocation.copy((InputStream)is, null);
                            this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPIED", tgt, src) + NL);
                            if (!this._model.ToolLoggerFlushLog()) {
                                this._model.isValid(false);
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    catch (IOException se) {
                        copyFailed = true;
                        this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", src, tgt) + NL);
                        if (!this._model.ToolLoggerFlushLog()) {
                            this._model.isValid(false);
                            return false;
                        }
                    }
                }
                catch (IOException se) {
                    copyFailed = true;
                    this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", src, tgt) + NL);
                    if (this._model.ToolLoggerFlushLog()) break block22;
                    this._model.isValid(false);
                    return false;
                }
            }
            ++i;
        }
        try {
            if (!copyFailed) return this._model.isValid();
            if (i >= true) return this._model.isValid();
            this._model.isValid(false);
            throw new IOException(DataPumpResources.getString("DPTRANS_COPY_ERROR") + NL);
        }
        catch (IOException e) {
            throw new ProcessFailedException(e, DataPumpResources.getString("DP_TRANS"));
        }
        finally {
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logProcessEnd();
            }
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return false;
            }
        }
    }

    private void doDebug(String msg) {
        if (this._model.isDebug()) {
            this._model.getToolLogger().log(msg);
        }
    }
}

