/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.commands.DataPumpCommand;
import oracle.dbtools.commands.SetDataPumpOptions;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.datapump.help.Messages;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;

public class SetDataPump
extends CommandListener
implements SQLCLService,
IStoreCommand,
IShowCommand,
IShowPrefixNameNewline {
    private static final String DEFAULT = "default";
    private static final String NL = System.lineSeparator();
    public static ScriptRunnerContext ctx;
    private CommandHelp help;
    private DataPumpModel _model;

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return null;
    }

    public String getExtensionName() {
        return null;
    }

    public String getExtensionVersion() {
        return null;
    }

    public String[] getShowAliases() {
        return new String[]{"datapump"};
    }

    public String getStoreCommand(ScriptRunnerContext ctx) {
        StringBuilder sb = new StringBuilder();
        ScriptRunnerContext.Parameters parameters = ctx.getParameterInstance();
        HashMap parms = parameters.getParameters("setdatapump.parms");
        if (parms != null) {
            for (String key : parms.keySet()) {
                if (key.equals(CommandParserConstants.COMMAND)) {
                    // empty if block
                }
                if (key.equals("encryptionpassword")) {
                    sb.append("set datapump -" + key + " ********" + NL);
                    continue;
                }
                sb.append("set datapump -" + key + " " + parms.get(key) + NL);
            }
        }
        return sb.toString();
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean haveParameters;
        ScriptRunnerContext.Parameters parameters;
        block20: {
            if (!cmd.getSql().startsWith("set datapump") && !cmd.getSql().startsWith("set dp")) {
                return false;
            }
            DataPumpCommand.ctx = ctx;
            parameters = ctx.getParameterInstance();
            haveParameters = false;
            try {
                DataPumpArguments args = new DataPumpArguments(ctx);
                this._model = new DataPumpModel(conn, ctx, cmd, args);
                this._model.isSetCommand(true);
                this._model.getToolLogger().flushLog();
                this.help = new CommandHelp(ctx, SetDataPumpOptions.class);
                if (parameters.parametersContains("setdatapump.parms")) {
                    haveParameters = true;
                    if (parameters.getParameterAsBoolean("setdatapump.parms", "debug").booleanValue()) {
                        ctx.write("Current Set");
                        ctx.getParameterInstance().printParametersAsRow("setdatapump.parms");
                    }
                    parameters.getParameters("setdatapump.parms").forEach((key, value) -> args.put(key, value));
                    CommandParser.loadParams((String)"setdatapump.parms", (String)cmd.getSql(), (ScriptRunnerContext)ctx, SetDataPumpOptions.class, (boolean)true, (boolean)true, (boolean)false);
                } else {
                    CommandParser.loadParams((String)"setdatapump.parms", (String)cmd.getSql(), (ScriptRunnerContext)ctx, SetDataPumpOptions.class, (boolean)true, (boolean)true, (boolean)true);
                }
                if (parameters.getParameterAsBoolean("setdatapump.parms", "debug").booleanValue()) {
                    ctx.write("New Set");
                    ctx.getParameterInstance().printParametersAsRow("setdatapump.parms");
                }
                String _command = parameters.getParameterAsString("setdatapump.parms", CommandParserConstants.COMMAND);
                boolean _help = parameters.getParameterAsBoolean("setdatapump.parms", CommandParserConstants.HELP);
                if (_help) {
                    ctx.write(this.help.getCommandHelp());
                    return true;
                }
                if (conn == null) {
                    this._model.getToolLogger().logError(DataPumpResources.format("DPCMPD_CONN", "set datapump"));
                    this._model.getToolLogger().flushLog();
                    return true;
                }
                switch (_command) {
                    case "datapump": {
                        String defPos = parameters.getParameterAsString("setdatapump.parms", "pos1");
                        if (defPos != null && !defPos.equals(DEFAULT)) {
                            throw new ParameterFailedValidationException(DataPumpResources.format("DPSETINVALIDPARM", defPos));
                        }
                        if (parameters.getParameterAsBoolean("setdatapump.parms", DEFAULT).booleanValue() || defPos != null && defPos.equals(DEFAULT)) {
                            parameters.resetParameters("setdatapump.parms");
                            CommandParser.loadParams((String)"setdatapump.parms", (String)"set datapump -default false", (ScriptRunnerContext)ctx, SetDataPumpOptions.class);
                        }
                        break;
                    }
                    default: {
                        this.help.getCommandHelp();
                        break;
                    }
                }
            }
            catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                if (parameters.getParameterAsBoolean("setdatapump.parms", "debug").booleanValue()) {
                    e.printStackTrace(pw);
                    ctx.write(pw.toString());
                } else {
                    ctx.write(e.getLocalizedMessage() + NL);
                    ctx.write(Messages.getString("FAILED_REQUEST"));
                    parameters.printParametersAsTable("setdatapump.parms");
                }
                if (haveParameters) break block20;
                parameters.initParametersNull("setdatapump.parms");
            }
        }
        if (haveParameters) {
            parameters.getParameters("setdatapump.parms").remove("pos1");
        }
        return true;
    }

    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.getParameterInstance().printParametersAsTable("setdatapump.parms");
        return true;
    }

    public boolean inShowAll() {
        return false;
    }

    public boolean needsDatabase() {
        return false;
    }
}

