/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.Locale;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.OraLocaleInfo;

public final class OraDecimalFormatSymbols
implements Cloneable,
Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int LOCAL_CURRENCY_LENGTH = 10;
    static final int INTERNATIONAL_CURRENCY_LENGTH = 7;
    static final int DUAL_CURRENCY_LENGTH = 10;
    private String currencySymbol;
    private char decimalSeparator;
    private char groupingSeparator;
    private String internationalCurrencySymbol;
    private char infinity;
    private char NaN;

    public OraDecimalFormatSymbols() {
        this.initialize(OraLocaleInfo.getDefault().getOraTerritory());
    }

    public OraDecimalFormatSymbols(Locale locale) {
        this.initialize(OraLocaleInfo.getInstance(locale).getOraTerritory());
    }

    public OraDecimalFormatSymbols(OraLocaleInfo oraLocaleInfo) {
        this.initialize(oraLocaleInfo.getOraTerritory());
    }

    OraDecimalFormatSymbols(OraTerritory oraTerritory) {
        this.initialize(oraTerritory);
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char c) {
        this.groupingSeparator = c;
    }

    public String getInternationalCurrencySymbol() {
        return this.internationalCurrencySymbol;
    }

    public void setInternationalCurrencySymbol(String string) {
        this.internationalCurrencySymbol = string;
    }

    char getNaN() {
        return this.NaN;
    }

    char getInfinity() {
        return this.infinity;
    }

    public Object clone() {
        try {
            return (OraDecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDecimalFormatSymbols)) {
            return false;
        }
        OraDecimalFormatSymbols oraDecimalFormatSymbols = (OraDecimalFormatSymbols)object;
        return this.decimalSeparator == oraDecimalFormatSymbols.decimalSeparator && this.groupingSeparator == oraDecimalFormatSymbols.groupingSeparator && this.currencySymbol.equals(oraDecimalFormatSymbols.currencySymbol) && this.internationalCurrencySymbol.equals(oraDecimalFormatSymbols.internationalCurrencySymbol);
    }

    public int hashCode() {
        return this.internationalCurrencySymbol.hashCode();
    }

    private void initialize(OraTerritory oraTerritory) {
        this.decimalSeparator = oraTerritory.getDecimalCharacter().charAt(0);
        this.groupingSeparator = oraTerritory.getGroupSeparator().charAt(0);
        this.currencySymbol = oraTerritory.getLocalCurrencySymbol();
        this.internationalCurrencySymbol = oraTerritory.getInternationalCurrencySymbol();
        this.infinity = (char)8734;
        this.NaN = (char)65533;
    }
}

