/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.JSONToPropertiesObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.mle_js.MLEJS_Util;

public class ExpNode
extends PropertiesObject
implements PropertiesObject.PropsVarsSynch,
Cloneable {
    public String name;
    public String type;
    public String schema;
    public String module;
    public String scope;
    public String imp_name;
    public String return_type;
    public String name_in_code;
    public String imp_alias;
    public String comment;
    public String code;
    public String extendsClass;
    public String subtype;
    static String IMP_NAME = "imp_name";
    public List<Param> params = null;
    public List<ExpNode> methods = null;
    public List<ExpNode> properties = null;
    List<String> expItems = null;
    static Set<String> builtIn = new HashSet<String>();

    @Override
    public void initPropsList() {
        this.propsList.add("name");
        this.propsList.add("type");
        this.propsList.add("subtype");
        this.propsList.add("schema");
        this.propsList.add("module");
        this.propsList.add("scope");
        this.propsList.add(IMP_NAME);
        this.propsList.add("imp_alias");
        this.propsList.add("return_type");
        this.propsList.add("name_in_code");
        this.propsList.add("comment");
        this.propsList.add("code");
        this.propsList.add("extendsClass");
    }

    public String getNameId() {
        Object res = "-1";
        if (this.name != null) {
            res = this.name;
        }
        res = this.params == null ? (String)res + "0" : (String)res + this.params.size();
        return res;
    }

    @Override
    public void propsToVars() {
        this.name = this.getProperty("name");
        this.type = this.getProperty("type");
        this.subtype = this.getProperty("subtype");
        this.schema = this.getProperty("schema");
        this.module = this.getProperty("module");
        this.scope = this.getProperty("scope");
        this.imp_name = this.getProperty(IMP_NAME);
        this.imp_alias = this.getProperty("imp_alias");
        this.return_type = this.getProperty("return_type");
        this.name_in_code = this.getProperty("name_in_code");
        this.comment = this.getProperty("comment");
        this.code = this.getProperty("code");
        this.extendsClass = this.getProperty("extendsClass");
    }

    @Override
    public void varsToProps() {
        this.setProperty("name", this.name);
        this.setProperty("type", this.type);
        this.setProperty("subtype", this.subtype);
        this.setProperty("schema", this.schema);
        this.setProperty("module", this.module);
        this.setProperty("scope", this.scope);
        this.setProperty(IMP_NAME, this.imp_name);
        this.setProperty("imp_alias", this.imp_alias);
        this.setProperty("return_type", this.return_type);
        this.setProperty("name_in_code", this.name_in_code);
        this.setProperty("comment", this.comment);
        this.setProperty("code", this.code);
        this.setProperty("extendsClass", this.extendsClass);
    }

    public boolean isBuiltInModule() {
        if (this.imp_name == null) {
            return false;
        }
        return builtIn.contains(MLEJS_Util.getName(this.imp_name));
    }

    @Override
    public void addJSONValue(String collName, JsonValue value) {
        if (value instanceof JsonString) {
            if (this.expItems == null) {
                this.expItems = new ArrayList<String>();
            }
            this.expItems.add(JSONToPropertiesObject.getString(value));
        } else {
            super.addJSONValue(collName, value);
        }
    }

    @Override
    public PropertiesObject createObjectForCollection(String collName) {
        if (collName != null) {
            return new Param();
        }
        return super.createObjectForCollection(collName);
    }

    @Override
    public void addObject(String collName, PropertiesObject obj) {
        if (collName != null && "params".equalsIgnoreCase(collName)) {
            if (this.params == null) {
                this.params = new ArrayList<Param>();
            }
            this.params.add((Param)obj);
            return;
        }
        super.addObject(collName, obj);
    }

    @Override
    public List<PropertiesObject.CollectionDescriptor> getCollectionDescriptors() {
        PropertiesObject.CollectionDescriptor cd;
        ArrayList<PropertiesObject.CollectionDescriptor> list = new ArrayList<PropertiesObject.CollectionDescriptor>();
        if (this.params != null && this.params.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "params";
            cd.coll = this::getParams;
            list.add(cd);
        }
        if (this.expItems != null && this.expItems.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "items";
            cd.coll = this::getExpItems;
            list.add(cd);
        }
        if (this.methods != null && this.methods.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "methods";
            cd.coll = this::getMethods;
            list.add(cd);
        }
        if (this.properties != null && this.properties.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "properties";
            cd.coll = this::getProperties;
            list.add(cd);
        }
        if (list.size() > 0) {
            return list;
        }
        return super.getCollectionDescriptors();
    }

    @Override
    public String toString() {
        return this.toJSONString(false);
    }

    public String toJson() {
        return this.toJson(0);
    }

    public String toJsonMetadata() {
        StringAdd s = new StringAdd();
        s.addText("{").addNL_Tabs("\"metadata\":[", 1);
        s.addNL_Tabs("]", 1).addNL().addText("}");
        return s.toString();
    }

    @Override
    public String toJSONString(boolean excludeNulls) {
        return this.toJson(0);
    }

    public String toJson(int baseTab) {
        boolean first;
        StringAdd s = new StringAdd();
        s.addTabs("{", baseTab).addNL().addProperty("name", ExpNode.encode(this.name), baseTab + 1);
        s.addPropNewLineString("type", ExpNode.encode(this.type), baseTab + 1);
        if (this.isBuiltInModule()) {
            s.addPropNewLineNumBool("builtInModule", "true", baseTab + 1);
        }
        if (this.subtype != null) {
            s.addPropNewLineString("subtype", this.subtype, baseTab + 1);
        }
        if (this.name_in_code != null) {
            s.addPropNewLineString("name_in_code", ExpNode.encode(this.name_in_code), baseTab + 1);
        }
        if (this.schema != null) {
            s.addPropNewLineString("schema", ExpNode.encode(this.schema), baseTab + 1);
        }
        if (this.module != null) {
            s.addPropNewLineString("module", ExpNode.encode(this.module), baseTab + 1);
        }
        if (this.imp_name != null) {
            s.addPropNewLineString(IMP_NAME, ExpNode.encode(this.imp_name), baseTab + 1);
        }
        if (this.imp_alias != null) {
            s.addPropNewLineString("imp_alias", ExpNode.encode(this.imp_alias), baseTab + 1);
        }
        if (this.scope != null) {
            s.addPropNewLineString("scope", ExpNode.encode(this.scope), baseTab + 1);
        }
        if (this.return_type != null) {
            s.addPropNewLineString("return_type", ExpNode.encode(this.return_type), baseTab + 1);
        } else if ("function".equals(this.type)) {
            s.addText(",").addNL().addTabs("\"return_type\":null", baseTab + 1);
        }
        if (this.comment != null) {
            s.addPropNewLineString("comment", ExpNode.encode(this.comment), baseTab + 1);
        }
        if (this.code != null) {
            s.addPropNewLineString("code", ExpNode.encode(this.code), baseTab + 1);
        }
        if (this.extendsClass != null) {
            s.addPropNewLineString("extendsClass", ExpNode.encode(this.extendsClass), baseTab + 1);
        }
        if (this.params != null && this.params.size() > 0) {
            s.addText(",");
            s.addNL_Tabs("\"params\":[", baseTab + 1);
            first = true;
            for (Param param : this.params) {
                if (first) {
                    s.addNL().addText(param.toJson(baseTab + 2));
                    first = false;
                    continue;
                }
                s.addText(",").addNL().addText(param.toJson(baseTab + 2));
            }
            s.addNL_Tabs("]", baseTab + 1);
        }
        if (this.expItems != null && this.expItems.size() > 0) {
            s.addText(",");
            s.addNL_Tabs("\"items\":[", baseTab + 1);
            first = true;
            for (String string : this.expItems) {
                if (first) {
                    s.addNL_Tabs("\"" + ExpNode.encode(string) + "\"", baseTab + 2);
                    first = false;
                    continue;
                }
                s.addText(",").addNL_Tabs("\"" + ExpNode.encode(string) + "\"", baseTab + 2);
            }
            s.addNL_Tabs("]", baseTab + 1);
        }
        if (this.properties != null && this.properties.size() > 0) {
            s.addText(",");
            s.addNL_Tabs("\"properties\":[", baseTab + 1);
            first = true;
            for (ExpNode expNode : this.properties) {
                if (first) {
                    s.addNL().addText(expNode.toJson(baseTab + 2));
                    first = false;
                    continue;
                }
                s.addText(",").addNL().addText(expNode.toJson(baseTab + 2));
            }
            s.addNL_Tabs("]", baseTab + 1);
        }
        if (this.methods != null && this.methods.size() > 0) {
            s.addText(",");
            s.addNL_Tabs("\"methods\":[", baseTab + 1);
            first = true;
            for (ExpNode expNode : this.methods) {
                if (first) {
                    s.addNL().addText(expNode.toJson(baseTab + 2));
                    first = false;
                    continue;
                }
                s.addText(",").addNL().addText(expNode.toJson(baseTab + 2));
            }
            s.addNL_Tabs("]", baseTab + 1);
        }
        s.addNL_Tabs("}", baseTab);
        return s.toString();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isMinimumDefined() {
        return false;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public boolean hasParamsWithDataType() {
        if (this.params == null) {
            return false;
        }
        for (Param p : this.params) {
            if (p.type == null || p.type.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<String> getExpItems() {
        return this.expItems;
    }

    public Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        ExpNode p = (ExpNode)obj;
        if (this.params != null) {
            p.params = new ArrayList<Param>();
            for (Param t : this.params) {
                p.params.add((Param)t.clone());
            }
        }
        return p;
    }

    public List<ExpNode> getMethods() {
        return this.methods;
    }

    public void setMethods(List<ExpNode> methods) {
        this.methods = methods;
    }

    public List<ExpNode> getProperties() {
        return this.properties;
    }

    static String encode(String str) {
        return StringUtilities.encodeAttributeValueJSON(str);
    }

    static {
        builtIn.add("mle-js-oracledb");
        builtIn.add("mle-js-bindings");
        builtIn.add("mle-js-plsqltypes");
    }

    public static class StringAdd {
        String tab = "    ";
        String s = "";
        boolean format = true;

        public StringAdd addNL() {
            if (this.format) {
                this.s = this.s + "\n";
            }
            return this;
        }

        public StringAdd addTabs(int tabs) {
            if (this.format) {
                for (int i = 0; i < tabs; ++i) {
                    this.s = this.s + this.tab;
                }
            }
            return this;
        }

        public StringAdd addNL_Tabs(String text, int tabs) {
            if (this.format) {
                this.addNL().addTabs(tabs).addText(text);
            } else {
                this.addText(text);
            }
            return this;
        }

        public StringAdd addTabs(String text, int tabs) {
            if (this.format) {
                this.addTabs(tabs).addText(text);
            } else {
                this.addText(text);
            }
            return this;
        }

        public StringAdd addText(String text) {
            this.s = this.s + text;
            return this;
        }

        public StringAdd addProperty(String key, String value, int tabs) {
            this.addTabs(tabs);
            this.s = this.s + "\"" + key + "\":\"" + value + "\"";
            return this;
        }

        public StringAdd addPropNewLineString(String key, String value, int tabs) {
            this.s = this.s + ",";
            this.addNL();
            this.addTabs(tabs);
            this.s = this.s + "\"" + key + "\":\"" + value + "\"";
            return this;
        }

        public StringAdd addPropNewLineNumBool(String key, String value, int tabs) {
            this.s = this.s + ",";
            this.addNL();
            this.addTabs(tabs);
            this.s = this.s + "\"" + key + "\":" + value;
            return this;
        }

        public String toString() {
            return this.s;
        }
    }

    public static class Param
    extends PropertiesObject
    implements Cloneable,
    PropertiesObject.PropsVarsSynch {
        public String name;
        public String type = "";
        public String direction = "";

        @Override
        public void initPropsList() {
            this.propsList.add("name");
            this.propsList.add("type");
            this.propsList.add("direction");
        }

        @Override
        public void propsToVars() {
            this.name = this.getProperty("name");
            this.type = this.getProperty("type");
            this.direction = this.getProperty("direction");
        }

        @Override
        public void varsToProps() {
            this.setProperty("name", this.name);
            this.setProperty("type", this.type);
            this.setProperty("direction", this.direction);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public String toJson(int baseTab) {
            StringAdd s = new StringAdd();
            s.addTabs("{", baseTab).addNL().addProperty("name", ExpNode.encode(this.name), baseTab + 1);
            s.addPropNewLineString("type", ExpNode.encode(this.type), baseTab + 1);
            s.addPropNewLineString("direction", ExpNode.encode(this.direction), baseTab + 1);
            s.addNL_Tabs("}", baseTab);
            return s.toString();
        }

        public String toJson() {
            return this.toJson(0);
        }

        @Override
        public String getName() {
            return this.getProperty("name");
        }

        @Override
        public boolean isMinimumDefined() {
            return false;
        }

        protected Object clone() throws CloneNotSupportedException {
            Object obj = super.clone();
            Param p = (Param)obj;
            p.name = this.name;
            p.type = this.type;
            p.direction = this.direction;
            return p;
        }
    }
}

