/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap;

import java.util.Iterator;
import oracle.dbtools.crest.util.propertymap.PropertyMap;

public class PropertyMapComparer {
    public static PropertyMap difference(boolean considerValues, PropertyMap result, PropertyMap base, PropertyMap subtract) {
        Iterator baseNames = base.getPropertyNames();
        while (baseNames.hasNext()) {
            String key = (String)baseNames.next();
            String value = base.getProperty(key);
            if (considerValues) {
                if (subtract.hasProperty(key, value)) continue;
                result.setProperty(key, value);
                continue;
            }
            if (subtract.hasProperty(key)) continue;
            result.setProperty(key, value);
        }
        return result;
    }

    public static PropertyMap intersection(boolean considerValues, PropertyMap result, PropertyMap one, PropertyMap two) {
        Iterator baseNames = one.getPropertyNames();
        while (baseNames.hasNext()) {
            String key = (String)baseNames.next();
            String value = one.getProperty(key);
            if (considerValues) {
                if (!two.hasProperty(key, value)) continue;
                result.setProperty(key, value);
                continue;
            }
            if (!two.hasProperty(key)) continue;
            result.setProperty(key, value);
        }
        return result;
    }

    public static void filterChangedProperties(PropertyMap resultOld, PropertyMap resultNew, PropertyMap dataOlder, PropertyMap dataNewer) {
        Iterator oldNames = dataOlder.getPropertyNames();
        while (oldNames.hasNext()) {
            String key = (String)oldNames.next();
            String value = dataOlder.getProperty(key);
            if (!dataNewer.hasProperty(key)) {
                resultOld.setProperty(key, value);
                continue;
            }
            if (dataNewer.hasProperty(key, value)) continue;
            resultOld.setProperty(key, value);
            resultNew.setProperty(key, dataNewer.getProperty(key));
        }
        Iterator newNames = dataNewer.getPropertyNames();
        while (newNames.hasNext()) {
            String key = (String)newNames.next();
            if (dataOlder.hasProperty(key)) continue;
            resultNew.setProperty(key, dataNewer.getProperty(key));
        }
    }

    public static void copy(PropertyMap from, PropertyMap to) {
        Iterator names = from.getPropertyNames();
        while (names.hasNext()) {
            String key = (String)names.next();
            to.setProperty(key, from.getProperty(key));
        }
    }

    public static String toString(PropertyMap propertyMap) {
        Iterator it = propertyMap.getPropertyNames();
        StringBuffer buffer = new StringBuffer("PropertyMap[").append("\n");
        while (it.hasNext()) {
            String key = (String)it.next();
            buffer.append(key).append('=').append(propertyMap.getProperty(key)).append('\n');
        }
        return buffer.append(']').toString();
    }
}

