/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling.compare;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.scheduling.SchedulerConstants;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerObjectCompare
implements SchedulerConstants {
    SchedulerObject source;
    SchedulerObject target;
    List<String> setNullAttrList = new ArrayList<String>();
    Map<String, String> diffMap = new TreeMap<String, String>();
    protected Set<String> excludeNulls = new HashSet<String>();

    public SchedulerObjectCompare(SchedulerObject source, SchedulerObject target) {
        this.source = source;
        this.target = target;
        this.initExcludeNulls();
        this.compareProperties();
    }

    public void initExcludeNulls() {
    }

    public void compareProperties() {
        for (String prop : this.source.getPropsList()) {
            if (this.source.isPropertyExcludeFromCompare(prop)) continue;
            String sval = this.source.getProperty(prop);
            String tval = this.target.getProperty(prop);
            if (sval == null) {
                if (tval == null || tval.isEmpty() || this.excludeNulls.contains(prop.toUpperCase())) continue;
                this.setNullAttrList.add(prop.toUpperCase());
                continue;
            }
            if (tval == null) {
                this.diffMap.put(prop, sval);
                continue;
            }
            if (this.equalPropertiess(prop, sval, tval)) continue;
            this.diffMap.put(prop, sval);
        }
    }

    public boolean equalPropertiess(String prop, String sval, String tval) {
        if (!sval.equals(tval)) {
            if (this.source.isNameProperty(prop)) {
                tval = SchedulerObjectCompare.getName(tval);
                if (!(sval = SchedulerObjectCompare.getName(sval)).equals(tval)) {
                    return false;
                }
            } else {
                if (this.source.isCaseInsensitive(prop)) {
                    return sval.equalsIgnoreCase(tval);
                }
                return false;
            }
        }
        return true;
    }

    public static String getName(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] args) {
    }

    public SchedulerObject getSource() {
        return this.source;
    }

    public SchedulerObject getTarget() {
        return this.target;
    }

    public List<String> getSetNullAttrList() {
        return this.setNullAttrList;
    }

    public Map<String, String> getDiffMap() {
        return this.diffMap;
    }

    public boolean isModified() {
        return this.diffMap.size() > 0 || this.setNullAttrList.size() > 0;
    }

    public String getProperty(String name) {
        String value = this.diffMap.get(name);
        if (value == null && (value = this.diffMap.get(name.toLowerCase())) == null) {
            value = this.diffMap.get(name.toUpperCase());
        }
        return value;
    }

    public boolean hasAttributesToSetNull() {
        return this.setNullAttrList.size() > 0;
    }

    public boolean hasAttributesToSetNull(Map<String, String> excludeNullsMap) {
        if (this.setNullAttrList.size() > 0) {
            boolean i = false;
            for (String prop : this.setNullAttrList) {
                if (excludeNullsMap.containsKey(prop)) continue;
                return true;
            }
        }
        return false;
    }

    public String getObjectFormattedName() {
        String name = this.getSource().getNameFormatted();
        if (this.getTarget() != null) {
            name = this.getTarget().getNameFormatted();
        }
        return name;
    }

    public String getFormattedName(String propOwner, String propName) {
        String name = this.getProperty(propName);
        if (name == null) {
            name = this.getSource().getProperty(propName);
        }
        if (name != null && !name.isEmpty()) {
            name = SchedulerObject.getFormatedSimpleName(name);
            Object res = "";
            String owner = this.getProperty(propOwner);
            if (owner == null) {
                owner = this.getSource().getProperty(propOwner);
            }
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + name;
            return res;
        }
        return null;
    }

    public boolean containsNullProp(String name) {
        if (this.setNullAttrList.size() == 0) {
            return false;
        }
        boolean res = this.setNullAttrList.contains(name.toUpperCase());
        return res;
    }

    public boolean propertyChanged(String prop) {
        return this.getProperty(prop) != null;
    }

    public boolean propertyChanged(String[] props) {
        for (String prop : props) {
            if (this.getProperty(prop) != null) {
                return true;
            }
            if (!this.containsNullProp(prop)) continue;
            return true;
        }
        return false;
    }

    public String getEventQueueSpecFormattedFormatted() {
        String name = this.getProperty("EVENT_QUEUE_NAME");
        if (name == null && !this.containsNullProp("EVENT_QUEUE_NAME")) {
            name = this.getTarget().getProperty("EVENT_QUEUE_NAME");
        }
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("EVENT_QUEUE_OWNER");
            if (owner == null && !this.containsNullProp("EVENT_QUEUE_OWNER")) {
                owner = this.getTarget().getProperty("EVENT_QUEUE_OWNER");
            }
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerObject.getFormatedSimpleName(name);
            String agent = this.getProperty("EVENT_QUEUE_AGENT");
            if (agent == null && !this.containsNullProp("EVENT_QUEUE_AGENT")) {
                agent = this.getTarget().getProperty("EVENT_QUEUE_AGENT");
            }
            if (agent != null && !agent.isEmpty()) {
                res = (String)res + "," + SchedulerObject.getFormatedSimpleName(agent);
            }
            return res;
        }
        return null;
    }
}

