/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerWindow
extends SchedulerObject {
    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("WINDOW_NAME");
        this.propsList.add("RESOURCE_PLAN");
        this.propsList.add("SCHEDULE_OWNER");
        this.propsList.add("SCHEDULE_NAME");
        this.propsList.add("SCHEDULE_TYPE");
        this.propsList.add("START_DATE");
        this.propsList.add("REPEAT_INTERVAL");
        this.propsList.add("END_DATE");
        this.propsList.add("DURATION");
        this.propsList.add("WINDOW_PRIORITY");
        this.propsList.add("ENABLED");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("WINDOW_NAME", "VARCHAR2");
        this.dataTypes.put("RESOURCE_PLAN", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_OWNER", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_NAME", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_TYPE", "VARCHAR2");
        this.dataTypes.put("START_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("REPEAT_INTERVAL", "VARCHAR2");
        this.dataTypes.put("END_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("DURATION", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("WINDOW_PRIORITY", "VARCHAR2");
        this.dataTypes.put("ENABLED", "VARCHAR2");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public String getName() {
        return this.getProperty("WINDOW_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String value = this.getProperty("DURATION");
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = this.getProperty("SCHEDULE_NAME");
        if (value != null && !value.isEmpty()) {
            return true;
        }
        value = this.getProperty("REPEAT_INTERVAL");
        return value != null && !value.isEmpty();
    }

    public String getFormatedScheduleName() {
        return this.getFormattedName("SCHEDULE_OWNER", "SCHEDULE_NAME");
    }
}

