/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerStep
extends SchedulerObject {
    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("CHAIN_NAME");
        this.propsList.add("STEP_NAME");
        this.propsList.add("PROGRAM_OWNER");
        this.propsList.add("PROGRAM_NAME");
        this.propsList.add("EVENT_SCHEDULE_OWNER");
        this.propsList.add("EVENT_SCHEDULE_NAME");
        this.propsList.add("EVENT_QUEUE_OWNER");
        this.propsList.add("EVENT_QUEUE_NAME");
        this.propsList.add("EVENT_QUEUE_AGENT");
        this.propsList.add("EVENT_CONDITION");
        this.propsList.add("CREDENTIAL_OWNER");
        this.propsList.add("CREDENTIAL_NAME");
        this.propsList.add("DESTINATION");
        this.propsList.add("SKIP");
        this.propsList.add("PAUSE");
        this.propsList.add("PAUSE_BEFORE");
        this.propsList.add("RESTART_ON_RECOVERY");
        this.propsList.add("RESTART_ON_FAILURE");
        this.propsList.add("STEP_TYPE");
        this.propsList.add("TIMEOUT");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("CHAIN_NAME", "VARCHAR2");
        this.dataTypes.put("STEP_NAME", "VARCHAR2");
        this.dataTypes.put("PROGRAM_OWNER", "VARCHAR2");
        this.dataTypes.put("PROGRAM_NAME", "VARCHAR2");
        this.dataTypes.put("EVENT_SCHEDULE_OWNER", "VARCHAR2");
        this.dataTypes.put("EVENT_SCHEDULE_NAME", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_OWNER", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_NAME", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_AGENT", "VARCHAR2");
        this.dataTypes.put("EVENT_CONDITION", "VARCHAR2");
        this.dataTypes.put("CREDENTIAL_OWNER", "VARCHAR2");
        this.dataTypes.put("CREDENTIAL_NAME", "VARCHAR2");
        this.dataTypes.put("DESTINATION", "VARCHAR2");
        this.dataTypes.put("SKIP", "BOOLEAN");
        this.dataTypes.put("PAUSE", "BOOLEAN");
        this.dataTypes.put("PAUSE_BEFORE", "BOOLEAN");
        this.dataTypes.put("RESTART_ON_RECOVERY", "BOOLEAN");
        this.dataTypes.put("RESTART_ON_FAILURE", "BOOLEAN");
        this.dataTypes.put("STEP_TYPE", "VARCHAR2");
        this.dataTypes.put("TIMEOUT", "INTERVAL DAY(3) TO SECOND(0)");
    }

    @Override
    public String getName() {
        return this.getProperty("SCHEDULE_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String value = this.getProperty("PROGRAM_NAME");
        if (value != null && !value.isEmpty()) {
            return true;
        }
        value = this.getProperty("EVENT_CONDITION");
        if (value != null && !value.isEmpty() && (value = this.getProperty("EVENT_QUEUE_NAME")) != null && !value.isEmpty()) {
            return true;
        }
        value = this.getProperty("EVENT_SCHEDULE_NAME");
        return value != null && !value.isEmpty();
    }

    public String getFormatedEventQueueName() {
        return this.getFormattedName("EVENT_QUEUE_OWNER", "EVENT_QUEUE_NAME");
    }

    public String getFormatedDestinationName() {
        return this.getFormattedName("DESTINATION_OWNER", "DESTINATION");
    }
}

