/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public class NotNullConstraintOracle
extends AbstractStorageObjectOracle {
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set initiallySet = null;
    private ColumnProxyOracle column = null;
    private String initially = INITIALLY[0];
    private String deferrable = "NO";
    private String enable = "YES";
    private String validate = "YES";
    private String rely = "NO";
    private TableProxyOracle exceptionsTable = null;
    public static final String TYPE_NAME = "NotNullConstraint";

    public void setColumn(ColumnProxyOracle col) {
        NotNullConstraintSetOracle nncs = this.getStorageDesignOracle().getNotNullConstraintSet();
        NotNullConstraintOracle old = nncs.getNotNullConstraint(col);
        if (old != null && old != this) {
            nncs.remove(old);
        }
        this.column = col;
        this.resetID(col);
    }

    @Override
    public String getIDPrefix() {
        return "NNC";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public ColumnProxyOracle getColumn() {
        return this.column;
    }

    public TableProxyOracle getTable() {
        if (this.column != null) {
            return this.column.getTableProxy();
        }
        return null;
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String value) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(NotNullConstraintOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(value);
    }

    public void setInitially(String initially) {
        if (this.checkInitially(initially)) {
            this.initially = initially;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String deferrable) {
        if (ConstantsOracle.checkYesNo(deferrable)) {
            this.deferrable = deferrable;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setRely(String rely) {
        if (ConstantsOracle.checkYesNo(rely)) {
            this.rely = rely;
            this.fireDataFieldChange();
        }
    }

    public String getRely() {
        return this.rely;
    }

    public void setEnable(String enable) {
        if (ConstantsOracle.checkYesNo(enable)) {
            this.enable = enable;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String validate) {
        if (ConstantsOracle.checkYesNo(validate)) {
            this.validate = validate;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle exceptionsTable) {
        if (this.exceptionsTable != exceptionsTable) {
            this.exceptionsTable = exceptionsTable;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    private void resetID(ColumnProxyOracle col) {
        this.createGlobalID();
    }
}

