/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public abstract class HashPartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private PartitionListOracle partitionList = null;
    private AbstractStorageObjectOracle subPartitionOf = null;
    private TableProxyOracle partOfStorageTable;
    private TableSpaceOracle tableSpace = null;
    private TableSpaceOracle iotOverflowTablespace = null;
    private int position = 0;
    private StorageObjectCollection lobitems;
    public static final String TYPE_NAME = "HashPartition";

    public HashPartitionOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.lobitems = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet());
        this.lobitems.setParent(this);
        this.lobitems.setName(Messages.getString("HashPartitionOracle.LobStorages"));
        this.lobitems.setClassForParent(HashPartitionOracle.class);
        this.lobitems.setSetMethod("setHashPartition");
        ((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "HP";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setPartitionList(PartitionListOracle partitionList) {
        if (this.partitionList != partitionList) {
            this.partitionList = partitionList;
            if (partitionList != null && partitionList.getTable() != null) {
                partitionList.getTable().addObject(this);
            }
            this.fireDataFieldChange();
        }
    }

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public void setSubPartitionOf(AbstractStorageObjectOracle subPartitionOf) {
        if (this.subPartitionOf != subPartitionOf) {
            this.subPartitionOf = subPartitionOf;
            if (subPartitionOf != null && subPartitionOf instanceof PartitionOracle) {
                ((PartitionOracle)subPartitionOf).addHashPartitionOracle(this);
            } else if (subPartitionOf instanceof ListPartitionOraclev11g) {
                ((ListPartitionOraclev11g)subPartitionOf).addSubpartition(this);
            }
            this.fireDataFieldChange();
        }
    }

    public AbstractStorageObjectOracle getSubPartitionOf() {
        return this.subPartitionOf;
    }

    public void setPartOfStorageTable(TableProxyOracle partOfStorageTable) {
        if (this.partOfStorageTable != partOfStorageTable) {
            this.partOfStorageTable = partOfStorageTable;
            if (partOfStorageTable != null) {
                partOfStorageTable.addTemplateSubPartition(this);
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getPartOfStorageTable() {
        return this.partOfStorageTable;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setIotOverflowTablespace(TableSpaceOracle iotOverflowTablespace) {
        if (this.iotOverflowTablespace != iotOverflowTablespace) {
            this.iotOverflowTablespace = iotOverflowTablespace;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getIotOverflowTablespace() {
        return this.iotOverflowTablespace;
    }

    public void setPosition(int position) {
        if (this.position != position) {
            StorageObjectCollection partitions;
            Object parent;
            this.position = position;
            if (position > 0 && (parent = this.getParent()) instanceof StorageObjectCollection && position <= (partitions = (StorageObjectCollection)parent).size() && partitions.getChild(position - 1) != this) {
                partitions.moveElementToIndex(this, position - 1);
            }
            this.fireDataFieldChange();
        }
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof HashPartitionLobItemOracle) {
                HashPartitionLobItemOracle ls = (HashPartitionLobItemOracle)event.getAffected();
                ls.addObjectListener(this);
                if (ls.getHashPartition() != null && ls.getHashPartition() == this) {
                    ls.setParent(this.lobitems);
                    this.lobitems.add(ls);
                } else {
                    this.lobitems.remove(ls);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle ls = (HashPartitionLobItemOracle)event.getAffected();
            this.lobitems.remove(ls);
            ls.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle ls = (HashPartitionLobItemOracle)event.getAffected();
            if (ls.getHashPartition() != null && ls.getHashPartition() == this) {
                ls.setParent(this.lobitems);
                this.lobitems.add(ls);
            } else {
                this.lobitems.remove(ls);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobitems;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageObjectCollection getLobItems() {
        return this.lobitems;
    }

    public StorageObjectCollection getLobs() {
        return this.lobitems;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        HashPartitionOracle hashPart = null;
        StorageObject stObject = (StorageObject)((StorageDesignOracle)targetDesign).getHashPartitionSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                hashPart = (HashPartitionOracle)stObject;
            }
        } else {
            hashPart = ((StorageDesignOracle)targetDesign).getHashPartitionSet().createHashPartition();
        }
        if (hashPart != null) {
            TableSpaceOracle newTableSpace;
            TableSpaceOracle tableSpace;
            hashPart.setName(this.getName());
            if (this.getPartitionList() != null) {
                PartitionListOracle partList = (PartitionListOracle)((StorageDesignOracle)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOracle newPartList = ((StorageDesignOracle)targetDesign).getPartitionListSet().createPartitionList();
                    newPartList.setName(this.getPartitionList().getName());
                    newPartList.setRawObject(true);
                    hashPart.setPartitionList(newPartList);
                } else {
                    hashPart.setPartitionList(partList);
                }
            }
            for (HashPartitionLobItemOracle hashLob : this.getLobs()) {
                HashPartitionLobItemOracle targetHashLob = (HashPartitionLobItemOracle)((StorageDesignOracle)targetDesign).getHashPartitionLobItemSet().getByName(hashLob.getName());
                if (targetHashLob == null) {
                    HashPartitionLobItemOracle newHashLob = ((StorageDesignOracle)targetDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
                    newHashLob.setName(hashLob.getName());
                    newHashLob.setRawObject(true);
                    newHashLob.setHashPartition(hashPart);
                    hashPart.getLobs().add(newHashLob);
                    continue;
                }
                targetHashLob.setHashPartition(hashPart);
                hashPart.getLobs().add(targetHashLob);
            }
            if (this.getTableSpace() != null) {
                tableSpace = (TableSpaceOracle)((StorageDesignOracle)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tableSpace == null) {
                    newTableSpace = ((StorageDesignOracle)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    hashPart.setTableSpace(newTableSpace);
                } else {
                    hashPart.setTableSpace(tableSpace);
                }
            }
            if (this.getIotOverflowTablespace() != null) {
                tableSpace = (TableSpaceOracle)((StorageDesignOracle)targetDesign).getTableSpaceSet().getByName(this.getIotOverflowTablespace().getName());
                if (tableSpace == null) {
                    newTableSpace = ((StorageDesignOracle)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getIotOverflowTablespace().getName());
                    newTableSpace.setRawObject(true);
                    hashPart.setIotOverflowTablespace(newTableSpace);
                } else {
                    hashPart.setIotOverflowTablespace(tableSpace);
                }
            }
            if (this.getSubPartitionOf() != null) {
                PartitionOracle partition = (PartitionOracle)((StorageDesignOracle)targetDesign).getPartitionSet().getByName(this.getSubPartitionOf().getName());
                if (partition == null) {
                    PartitionOracle newPartition = ((StorageDesignOracle)targetDesign).getPartitionSet().createPartition();
                    newPartition.setName(this.getSubPartitionOf().getName());
                    newPartition.setRawObject(true);
                    hashPart.setSubPartitionOf(newPartition);
                } else {
                    hashPart.setSubPartitionOf(partition);
                }
            }
            if (this.getPartOfStorageTable() != null) {
                Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getPartOfStorageTable().getObject().getName());
                TableProxyOracle tableProxy = (TableProxyOracle)targetDesign.getTableProxySet().getProxy(table.getObjectID());
                if (tableProxy == null) {
                    TableProxyOracle newTableProxy = (TableProxyOracle)((TableProxySetOracle)targetDesign.getTableProxySet()).createProxy(table);
                    newTableProxy.setName(this.getPartOfStorageTable().getName());
                    newTableProxy.setRawObject(true);
                    hashPart.setPartOfStorageTable(newTableProxy);
                } else {
                    hashPart.setPartOfStorageTable(tableProxy);
                }
            }
            hashPart.setPosition(this.getPosition());
            hashPart.setComment(this.getComment());
            hashPart.setRawObject(false);
        }
    }

    public HashPartitionLobItemOracle createLobItem() {
        if (this.lobitems.getStorageObjectSet() != null) {
            return (HashPartitionLobItemOracle)this.lobitems.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> lips = new ArrayList<LocalIndexProperties>();
        for (LocalIndexProperties lip : ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet()) {
            if (lip.getPartition() != this || lip.getIndex() == null) continue;
            lips.add(lip);
        }
        return lips;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties lip = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        lip.setPartition(this);
        return lip;
    }

    @Override
    public void setParent(Object parent) {
        RepositoryObject parentObject;
        super.setParent(parent);
        RepositoryObject storableObject = null;
        if (parent instanceof StorageObjectCollection && (storableObject = (parentObject = (RepositoryObject)((StorageObjectCollection)parent).getParent()).getPAC_Element()) == null) {
            storableObject = parentObject;
        }
        this.setPAC_Element(storableObject);
    }

    @Override
    public void remove() {
        if (this.getPartitionList() != null && this.getPartitionList().getTable() != null) {
            this.getPartitionList().getTable().removeObject(this);
        } else if (this.partOfStorageTable != null) {
            this.partOfStorageTable.removeTemplateSubPartition(this);
        }
        super.remove();
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append("| ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

