/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class TypeElementProxy
extends RelationalObjectProxy {
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    public static final String TYPE_NAME = "TElm";

    public TypeElementProxy(TypeElement typeElement, StorageDesign storageDesign) {
        super(typeElement, storageDesign);
    }

    public TypeElementProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "TypeElement";
    }

    public StructuredType getStructuredType() {
        return ((TypeElement)this.getObject()).getStructuredType();
    }

    public StructuredTypeProxy getStructuredTypeProxy() {
        return (StructuredTypeProxy)this.getStorageDesign().getProxy(((TypeElement)this.getObject()).getStructuredType());
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    @Override
    public String getComment() {
        if (this.isCommentChanged()) {
            return super.getComment();
        }
        return this.getObject().getComment();
    }

    @Override
    public void setComment(String comment) {
        if (!comment.equals(this.getObject().getComment())) {
            super.setComment(comment);
            this.setCommentChanged(true);
        } else {
            this.setCommentChanged(false);
        }
    }

    public String getDatatype(String rdbms) {
        return ((TypeElement)this.getObject()).getDataType(rdbms);
    }

    public String getDatatype() {
        return this.getDatatype(this.getStorageDesign().getRDBMSType().getName());
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        if (this.pac_Element == null) {
            this.setPAC_Element(this.getStructuredTypeProxy());
        }
        return super.getPAC_Element();
    }
}

