/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignSet;

public class StorageDesignFactory
extends ModelObject {
    private Map instances = new HashMap();
    StorageDesignSet elements = new StorageDesignSet();
    private RelationalDesign physicalDesign;

    public StorageDesignFactory(RelationalDesign physicalDesign) {
        this.physicalDesign = physicalDesign;
        this.elements.setName(Messages.getString("StorageDesignFactory.PhysicalModels"));
        this.elements.setParent(physicalDesign);
        this.elements.setDesign(physicalDesign.getDesign());
        this.setDesign(physicalDesign.getDesign());
    }

    public static final String getStorageDesignSetName() {
        return Messages.getString("StorageDesignFactory.PhysicalModels");
    }

    public RDBMSSiteSet getRDBMSSiteSet() {
        return this.getDesign().getRDBMSSiteSet();
    }

    public RDBMSSite[] getRDBMSSites() {
        return this.getRDBMSSiteSet().toSiteArray();
    }

    public StorageDesign getStorageDesign(RDBMSSite site) {
        StorageDesign stoDes;
        if (!this.instances.containsKey(site)) {
            stoDes = StorageDesign.createStorageDesign(this.getPhysicalDesign(), site, this.physicalDesign.getDesign());
            stoDes.setParent(this.elements);
            this.instances.put(site, stoDes);
            stoDes.setLoading(false);
        }
        stoDes = (StorageDesign)this.instances.get(site);
        return stoDes;
    }

    public StorageDesign[] getOpenStorageDesigns() {
        ArrayList<StorageDesign> list = new ArrayList<StorageDesign>();
        for (StorageDesign sd : this.instances.values()) {
            if (!sd.isOpen()) continue;
            list.add(sd);
        }
        return list.toArray(StorageDesign.PROTOTYPE_ARRAY);
    }

    public RDBMSSite[] getOpenRDBMSSites() {
        return (RDBMSSite[])this.instances.keySet().toArray(RDBMSSiteSet.PROTO_ARRAY);
    }

    public void removeStorageDesign(StorageDesign sd) {
        if (this.instances.containsKey(sd.getRDBMSSite())) {
            this.instances.remove(sd.getRDBMSSite());
            this.elements.remove(sd);
        }
    }

    public StorageDesignSet getSorageDesigns() {
        return this.elements;
    }

    public void sdTempStatusChanged(StorageDesign sd) {
        if (!sd.isTempModel() && !this.elements.contains(sd)) {
            sd.setParent(this.elements);
            this.elements.add(sd);
        } else if (sd.isTempModel()) {
            this.elements.remove(sd);
        }
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public boolean existStorageDesign(RDBMSSite site) {
        return this.instances.get(site) != null;
    }

    public void clearStorageDesigns() {
        this.instances.clear();
        this.elements.removeAll();
    }
}

