/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.AttributeViewSet;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.CandidateKeySet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.ViewAttributePlaceHolder;

public class EntityView
extends AbstractView
implements EditableFonts {
    public static final String TYPE_VIEW = "EntityView";
    public static final String TYPE_NAMED_QUERY = "NAMED QUERY";
    public static final String[] VIEW_TYPES = new String[]{"EntityView", "NAMED QUERY"};
    private String viewType = "EntityView";
    private List editableFonts = new ArrayList();

    public EntityView(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getIDPrefix() {
        return MDPreferences.getDefaultInstance().get("entityview id prefix");
    }

    @Override
    public Class getContainedClass() {
        return AttributeView.class;
    }

    public DesignObjectSet getEntitySet() {
        return ((LogicalDesign)this.getDesignPart()).getEntitySet();
    }

    public AttributeViewSet getAttributeViewSet() {
        return ((LogicalDesign)this.getDesignPart()).getAttributeViewSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getAttributeViewSet();
    }

    public ContainedObject createContainedObject(String id) {
        AttributeView attribute = new AttributeView(this.getDesignPart());
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        if (id != null) {
            attribute.setObjectID(id);
        }
        attribute.setDesignObjectSet(this.getAttributeViewSet());
        this.add(attribute);
        this.getAttributeViewSet().add(attribute);
        if (id != null) {
            attribute.setObjectID(id);
        }
        return attribute;
    }

    @Override
    public void add(ContainedObject object) {
        if (!this.exists(object)) {
            if (object instanceof AttributeView) {
                if (object.getObjectID() == null) {
                    this.assignLocalID(object);
                }
                object.setDesign(this.getDesign());
                this.getAttributeViewSet().add(object);
                this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), object));
                super.add(object);
                if (((AttributeView)object).getReferencedAttribute() != null) {
                    ((AttributeView)object).getReferencedAttribute().addObjectListener(this);
                }
                if (((AttributeView)object).getView() != null && ((AttributeView)object).getView() != this) {
                    ContainedObject[] cols = ((AttributeView)object).getView().getElements();
                    for (int i = 0; i < cols.length; ++i) {
                        if (((AttributeView)cols[i]).getReferencedAttribute() != ((AttributeView)object).getReferencedAttribute()) continue;
                        ((AttributeView)cols[i]).addObjectListener(this);
                    }
                }
            } else {
                AttributeView adapter = new AttributeView(this.getDesignPart());
                adapter.setObjectID(this.getDesignPart().getIDGenerator().createNewID());
                adapter.setName(object.getName());
                adapter.setDesign(this.getDesign());
                adapter.setReferencedAttribute((Attribute)object);
                adapter.setDataType(((Attribute)object).getDataType().toString());
                adapter.setContainer(this);
                adapter.setEntity((Entity)object.getContainer());
                this.getAttributeViewSet().add(adapter);
                this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), adapter));
                super.add(adapter);
                if (adapter.getView() != this) {
                    adapter.addObjectListener(this);
                }
                object.addObjectListener(this);
            }
        }
    }

    public AttributeView attributeViewAdd(ContainedObject object) {
        if (!this.exists(object)) {
            if (object instanceof AttributeView) {
                if (object.getObjectID() == null) {
                    this.assignLocalID(object);
                }
                object.setDesign(this.getDesign());
                this.getAttributeViewSet().add(object);
                this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), object));
                super.add(object);
                if (((AttributeView)object).getReferencedAttribute() != null) {
                    ((AttributeView)object).getReferencedAttribute().addObjectListener(this);
                }
                if (((AttributeView)object).getView() != null && ((AttributeView)object).getView() != this) {
                    ContainedObject[] cols = ((AttributeView)object).getView().getElements();
                    for (int i = 0; i < cols.length; ++i) {
                        if (((AttributeView)cols[i]).getReferencedAttribute() != ((AttributeView)object).getReferencedAttribute()) continue;
                        ((AttributeView)cols[i]).addObjectListener(this);
                    }
                }
                return (AttributeView)object;
            }
            AttributeView adapter = new AttributeView(this.getDesignPart());
            adapter.setName(object.getName());
            adapter.setDesign(this.getDesign());
            adapter.setReferencedAttribute((Attribute)object);
            adapter.setDataType(((Attribute)object).getDataType().toString());
            this.getAttributeViewSet().add(adapter);
            adapter.setContainer(this);
            adapter.setEntity((Entity)object.getContainer());
            this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), adapter));
            super.add(adapter);
            if (adapter.getView() != this) {
                adapter.addObjectListener(this);
            }
            object.addObjectListener(this);
            return adapter;
        }
        return null;
    }

    private boolean exists(ContainedObject object) {
        if (object instanceof AttributeView) {
            return this.getElementsCollection().contains(object);
        }
        for (AttributeView contained : this.getElementsCollection()) {
            if (object != contained.getReferencedAttribute()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(ContainedObject object) {
        this.phelements.removePlaceHolderFor(object);
        this.removeFromOrderBy(object);
        super.remove(object);
        this.getAttributeViewSet().remove(object);
    }

    @Override
    public void addToOrderBy(ContainedObject object, String sortOrder) {
        if (object.getObjectID() == null) {
            this.assignLocalID(object);
        }
        object.setContainer(this);
        this.getAttributeViewSet().add(object);
        this.orderByMap.put(object.getObjectID(), sortOrder);
        this.orderByList.add(object);
        if (((AttributeView)object).getReferencedAttribute() != null) {
            ((AttributeView)object).getReferencedAttribute().addObjectListener(this);
        }
    }

    public AttributeView getAttributeByObjectID(String objectID) {
        for (AttributeView contained : this.getElementsCollection()) {
            if (!contained.getObjectID().equals(objectID)) continue;
            return contained;
        }
        return null;
    }

    @Override
    public void addToContainers(ContainerObject container, String alias) {
        this.containerMap.put(alias, container.getObjectID());
        if (container instanceof Entity) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
            }
        } else if (container instanceof EntityView && !this.views.contains(container)) {
            this.views.add(container);
        }
        this.usedContainers.add(new AbstractView.ContainerHolder(this, container, alias));
    }

    @Override
    public void addToContainers(String objectID, String alias) {
        this.containerMap.put(alias, objectID);
        ContainerObject container = (ContainerObject)this.getEntitySet().getObjectByID(objectID);
        if (container != null) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
            }
            this.usedContainers.add(new AbstractView.ContainerHolder(this, container, alias));
            this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(this, objectID, alias));
        } else {
            EntityView v = (EntityView)((LogicalDesign)this.getDesignPart()).getEntityViewSet().getObjectByID(objectID);
            if (v != null) {
                if (!this.views.contains(v)) {
                    this.views.add(v);
                }
                this.usedContainers.add(new AbstractView.ContainerHolder(this, v, alias));
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(this, objectID, alias));
            } else {
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(this, objectID, alias));
            }
        }
    }

    public AttributeView getAttributeViewByName(String name) {
        for (AttributeView contained : this.getElementsCollection()) {
            if (!contained.getName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public AttributeView getAttributeViewByLongName(String name) {
        for (AttributeView contained : this.getElementsCollection()) {
            if (!contained.getLongName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    @Override
    public void clearContainers() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
    }

    @Override
    public void clear(ContainerObject container) {
        this.tables.remove(container);
        this.views.remove(container);
        Object[] obj = this.containerMap.keySet().toArray();
        for (int i = obj.length - 1; i >= 0; --i) {
            String alias = (String)obj[i];
            String containerID = (String)this.containerMap.get(alias);
            if (!container.getObjectID().equalsIgnoreCase(containerID)) continue;
            this.containerMap.remove(alias);
        }
        if (container != this) {
            this.clearElements(container);
        }
        this.clearOrderByElements(container);
        AbstractView.ContainerHolder ch = this.getContainerHolderFor(container);
        if (ch != null) {
            this.usedContainers.remove(ch);
        }
    }

    public void clear(AttributeView attribute) {
        if (attribute.getContainer() == this) {
            Iterator it = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
            while (it.hasNext()) {
                EntityView view = (EntityView)it.next();
                if (view == this) continue;
                if (this.getElementsCollection().contains(attribute)) {
                    view.remove(attribute);
                }
                view.removeFromOrderBy(attribute);
            }
        }
    }

    @Override
    public void clearElements(ContainerObject container) {
        block5: {
            block4: {
                if (!(container instanceof EntityView)) break block4;
                ContainedObject[] cos = container.getElements();
                for (int i = 0; i < cos.length; ++i) {
                    if (!this.getElementsCollection().contains(cos[i])) continue;
                    this.remove(cos[i]);
                }
                break block5;
            }
            if (!(container instanceof Entity)) break block5;
            ArrayList<AttributeView> forRemove = new ArrayList<AttributeView>();
            Iterator it = this.getElementsCollection().iterator();
            ContainedObject[] cos = container.getElements();
            block1: while (it.hasNext()) {
                AttributeView attributeView = (AttributeView)it.next();
                if (attributeView.getReferencedAttribute() == null) continue;
                for (int i = 0; i < cos.length; ++i) {
                    if (attributeView.getReferencedAttribute() != cos[i]) continue;
                    forRemove.add(attributeView);
                    continue block1;
                }
            }
            it = forRemove.iterator();
            while (it.hasNext()) {
                this.remove((AttributeView)it.next());
            }
        }
    }

    @Override
    public void clearOrderByElements(ContainerObject container) {
        block7: {
            block6: {
                if (!(container instanceof EntityView)) break block6;
                ArrayList<AttributeView> forRemove = new ArrayList<AttributeView>();
                for (AttributeView attribute : container.getElementsCollection()) {
                    for (AttributeView attr : this.orderByList) {
                        if (attribute.getReferencedAttribute() != attr.getReferencedAttribute()) continue;
                        forRemove.add(attr);
                    }
                }
                Iterator it = forRemove.iterator();
                while (it.hasNext()) {
                    this.removeFromOrderBy((AttributeView)it.next());
                }
                break block7;
            }
            if (!(container instanceof Entity)) break block7;
            ArrayList<AttributeView> forRemove = new ArrayList<AttributeView>();
            block3: for (AttributeView attributeView : this.orderByList) {
                if (attributeView.getReferencedAttribute() == null) continue;
                for (Attribute attribute : container.getElementsCollection()) {
                    if (attributeView.getReferencedAttribute() != attribute) continue;
                    forRemove.add(attributeView);
                    continue block3;
                }
            }
            Iterator it = forRemove.iterator();
            while (it.hasNext()) {
                this.removeFromOrderBy((AttributeView)it.next());
            }
        }
    }

    @Override
    public void remove() {
        Iterator it = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            view.clear(this);
        }
        for (AttributeView attribute : this.getElementsCollection()) {
            this.getAttributeViewSet().remove(attribute);
        }
        ArrayList<AttributeView> forDelete = new ArrayList<AttributeView>();
        it = this.getAttributeViewSet().iterator();
        while (it.hasNext()) {
            AttributeView attribute = (AttributeView)it.next();
            if (attribute.getView() != this) continue;
            forDelete.add(attribute);
        }
        for (AttributeView attribute : forDelete) {
            this.getAttributeViewSet().remove(attribute);
            attribute.getContainer().remove(attribute);
        }
        super.remove();
        SetEvent.OBJECT_REMOVED.setAffected(this);
        ((LogicalDesign)this.getDesignPart()).getEntityViewSet().fireChange(SetEvent.OBJECT_REMOVED);
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet) {
            super.changed(set, event);
            return;
        }
        if (SetEvent.OBJECT_REMOVED.equals(event) && event.getAffected() instanceof ContainerObject) {
            ((ContainerObject)event.getAffected()).removeContainerListener(this);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        boolean containsObject = false;
        if (event.isType(ObjectChangeEvent.OBJECT_REMOVED) || event.isType(ObjectChangeEvent.NAME_CHANGED) || event.isType(ObjectChangeEvent.SCHEMA_CHANGED)) {
            if (this.sqlNameExists(object.getObjectID())) {
                containsObject = true;
            }
            if (!containsObject) {
                if (object instanceof ContainerObject) {
                    if (this.sqlNameExists(object.getObjectID())) {
                        containsObject = true;
                    }
                } else if (object instanceof Attribute) {
                    for (AttributeView colView : this.getElementsCollection()) {
                        if (colView.getReferencedColumn() == null || colView.getReferencedColumn() != object) continue;
                        containsObject = true;
                        break;
                    }
                } else if (object instanceof AttributeView) {
                    for (AttributeView colView : this.getElementsCollection()) {
                        if (colView != object && colView.getReferencedColumnView() != object) continue;
                        containsObject = true;
                        break;
                    }
                }
            }
            if (containsObject) {
                this.setValidSQL(!this.isSQLNamesChanged());
                if (!this.isValidSQL()) {
                    this.invalidateLinkedViews();
                }
            }
        }
    }

    protected void invalidateLinkedViews() {
        Iterator it = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            if (entityView == null || !entityView.isValidSQL() || !entityView.sqlNameExists(this.getObjectID())) continue;
            entityView.setValidSQL(false);
            entityView.invalidateLinkedViews();
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copy(desObject, null, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        EntityView view = (EntityView)desObject;
        super.copy(view);
        view.setWhere(this.getWhere());
        view.setGroupBy(this.getGroupBy());
        view.setHaving(this.getHaving());
        view.setUserDefined(this.getUserDefined());
        view.setUserDefinedSQL(this.getUserDefinedSQL(view.getName()));
        view.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            view.addToContainers(cID, alias);
        }
        for (String id : this.getOrderByMap().keySet()) {
            AttributeView attribute = (AttributeView)this.getObjectByID(this.orderByList, id);
            if (attribute != null) {
                AttributeView col = new AttributeView(this.getDesignPart());
                attribute.copy(col);
                col.setView(view);
                view.addToOrderBy(col, (String)this.getOrderByMap().get(id));
                continue;
            }
            System.out.println("EntityView.copy: Unable to find AttributeView: " + id);
        }
        if (!this.isBST()) {
            int i;
            if (remoteObject) {
                ContainedObject[] columns = view.getElements();
                for (i = columns.length - 1; i >= 0; --i) {
                    ContainedObject rc;
                    ContainedObject column = columns[i];
                    String rcID = column.getRemoteObjectID();
                    if ("".equalsIgnoreCase(rcID) || (rc = this.getElementByID(rcID)) != null) continue;
                    column.remove();
                }
            }
            view.getElementsCollection().clear();
            ContainedObject[] cos = this.getElements();
            for (i = 0; i < cos.length; ++i) {
                AttributeView old = (AttributeView)cos[i];
                AttributeView col = new AttributeView(this.getDesignPart());
                if (remoteObject) {
                    if (old.isRemoteObject()) {
                        col.setRemoteObjectID(old.getRemoteObjectID());
                    } else {
                        col.setRemoteObjectID(old.getObjectID());
                    }
                }
                old.copy(col);
                col.setView(view);
                col.setContainer(view);
                view.add(col);
            }
        }
    }

    @Override
    public void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            AttributeView attribute = (AttributeView)this.getElementByStructAttributeID(te.getObjectID());
            if (attribute == null) {
                attribute = new AttributeView(this.getDesignPart());
                attribute.setName(te.getName());
                attribute.setStructAttributeID(te.getObjectID());
                this.addAttribute(attribute);
            }
            this.copyTEToAttribute(te, attribute);
        }
    }

    private void copyTEToAttribute(TypeElement te, AttributeView attribute) {
        attribute.setName(te.getName());
        attribute.setDataType(te.getDataType());
        attribute.setReference(te.isReference());
        if (te.getType() instanceof StructuredType) {
            attribute.setStructuredType((StructuredType)te.getType());
        } else {
            attribute.setStructuredType(null);
        }
    }

    public void addAttribute(AttributeView attribute) {
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        this.add(attribute);
    }

    public List getRefColumns() {
        ArrayList<AttributeView> list = new ArrayList<AttributeView>();
        if (this.isBST()) {
            ContainedObject[] attributes = this.getElements();
            for (int i = 0; i < attributes.length; ++i) {
                AttributeView col = (AttributeView)attributes[i];
                if (!col.isReference()) continue;
                list.add(col);
            }
        }
        return list;
    }

    public String getViewType() {
        return this.viewType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_VIEW;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    @Override
    public AbstractViewElement createViewElement(DesignPart designPart) {
        return new AttributeView(designPart);
    }

    @Override
    public DesignObjectSet getTableSet() {
        return this.getEntitySet();
    }

    @Override
    public String getFCObjectType() {
        return "Logical View";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "view" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new CandidateKeySet(this.getDesignPart());
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return Entity.KEY_PROTOTYPE;
    }

    @Override
    public KeyObject createKeyObject(String id) {
        return this.createCandidateKey(id);
    }

    public CandidateKey createCandidateKey(String id) {
        CandidateKey key = new CandidateKey(this.getDesignPart());
        key.setObjectID(id);
        key.setDesign(this.getDesign());
        key.setContainerObject(this);
        key.setUnique(true);
        this.add(key);
        return key;
    }
}

