/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class DTInheritanceSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new DTInheritance[0];

    public DTInheritanceSet(DesignPart designPart) {
        super(designPart);
    }

    public DTInheritance createInheritance(String oldID) {
        DTInheritance inheritance = new DTInheritance(this.getDesignPart());
        inheritance.setObjectID(oldID);
        inheritance.setDesign(this.getDesign());
        inheritance.setParent(this);
        this.getDesign().addDesignObject(inheritance);
        this.add(inheritance);
        return inheritance;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "DTInheritance";
    }

    public Collection getInheritancesToSource(StructuredType source) {
        ArrayList<DTInheritance> col = new ArrayList<DTInheritance>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DTInheritance inheritance = (DTInheritance)it.next();
            if (inheritance.getSourceDTObject() != source) continue;
            col.add(inheritance);
        }
        return col;
    }

    public Collection getInheritancesToTarget(StructuredType target) {
        ArrayList<DTInheritance> col = new ArrayList<DTInheritance>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DTInheritance inheritance = (DTInheritance)it.next();
            if (inheritance.getTargetDTObject() != target) continue;
            col.add(inheritance);
        }
        return col;
    }

    public Collection getRelationsTo(StructuredType st) {
        ArrayList<DTInheritance> col = new ArrayList<DTInheritance>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DTInheritance inheritance = (DTInheritance)it.next();
            if (inheritance.getSourceDTObject() != st && inheritance.getTargetDTObject() != st) continue;
            col.add(inheritance);
        }
        return col;
    }
}

