/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;

public class CollectionTypeSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new CollectionType[0];

    public CollectionTypeSet(DesignPart designPart) {
        super(designPart);
    }

    public CollectionType createCollectionType(String oldID) {
        CollectionType collectionType = new CollectionType(this.getDesignPart());
        collectionType.setObjectID(oldID);
        collectionType.setDesign(this.getDesign());
        collectionType.setParent(this);
        this.getDesign().addDesignObject(collectionType);
        this.add(collectionType);
        return collectionType;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "CollectionType";
    }

    public CollectionType findByChangedHiveType(String hiveType) {
        if (hiveType != null && !"".equals(hiveType)) {
            String type = hiveType.toUpperCase();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                CollectionType stype = (CollectionType)it.next();
                String tt = stype.getDataTypePresentationForHive().toUpperCase();
                tt = tt.replaceAll("<", "(");
                if (!(tt = tt.replaceAll(">", ")")).equals(type)) continue;
                return stype;
            }
        }
        return null;
    }
}

