/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;

public class TemporaryTablespaceComparatorOracle
extends StoragePropertiesComparator {
    public static final String TABLESPACE_GROUP = TemporaryTablespaceComparatorOracle.getPropertyNameOracle("TemporaryTablespacePropertyDialogOraclev10g.TableSpaceGroup");
    public static final String UNIFORM_SIZE = TemporaryTablespaceComparatorOracle.getPropertyNameOracle("TemporaryTablespacePropertyDialogOraclev10g.UniformSize");
    public static final String UNIFORM_SIZE_UNIT = Messages.getString("TemporaryTablespaceComparatorOracle.UniformSizeUnit");
    public static final String FILE_TYPE = TemporaryTablespaceComparatorOracle.getPropertyNameOracle("TemporaryTablespacePropertyDialogOraclev10g.FileType");
    public static final String ORACLE_MANAGED_FILES = TemporaryTablespaceComparatorOracle.getPropertyNameOracle("TemporaryTablespacePropertyDialogOraclev10g.OracleManFiles");
    private TemporaryTablespaceOracle sourceTablespace;
    private TemporaryTablespaceOracle targetTablespace;

    public TemporaryTablespaceComparatorOracle(TemporaryTablespaceOracle sourceTablespace, TemporaryTablespaceOracle targetTablespace) {
        super(sourceTablespace, targetTablespace);
        this.sourceTablespace = sourceTablespace;
        this.targetTablespace = targetTablespace;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        StorageDesign storageDesign = null;
        if (this.sourceTablespace != null) {
            storageDesign = this.sourceTablespace.getStorageDesign();
        } else if (this.targetTablespace != null) {
            storageDesign = this.targetTablespace.getStorageDesign();
        }
        boolean oracle9i = storageDesign instanceof StorageDesignOraclev9i;
        this.initNameProperty();
        this.initCommentProperty();
        if (!oracle9i) {
            this.initProperty(TABLESPACE_GROUP, "tableSpaceGroup");
        }
        this.initProperty(UNIFORM_SIZE, "uniformSize");
        this.initProperty(UNIFORM_SIZE_UNIT, "measureUnitUniformSize");
        if (!oracle9i) {
            this.initProperty(FILE_TYPE, "fileType");
            this.initProperty(ORACLE_MANAGED_FILES, "oracleManagedFiles");
        }
    }
}

