/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;

public class LobStorageComparatorOracle
extends StoragePropertiesComparator {
    public static final String LOB_COLUMN = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.LobColumn");
    public static final String LOB_STORAGE_TYPE = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOraclev11g.LobStorageType");
    public static final String LOB_SEGMENT_NAME = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.LobSegmentName");
    public static final String TABLESPACE = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.TableSpace");
    public static final String STORAGE_IN_ROW = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.StorageInRow");
    public static final String COMPRESSION = LobStorageComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.Compression");
    public static final String COMPRESSION_TYPE = LobStorageComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.CompressionType");
    public static final String DUPLICATION = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOraclev11g.Duplication");
    public static final String LOGGING = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.Logging");
    public static final String CACHE = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.Cache");
    public static final String CHUNK = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.Chunk");
    public static final String OLD_VERSIONS = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.OldVersions");
    public static final String PCT_VERSION = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.PCTVersion");
    public static final String FREEPOOLS = LobStorageComparatorOracle.getPropertyNameOracle("LobStoragePropertyDialogOracle.FreePools");
    private LobStorageOracle sourceLob;
    private LobStorageOracle targetLob;

    public LobStorageComparatorOracle(LobStorageOracle sourceLob, LobStorageOracle targetLob) {
        super(sourceLob, targetLob);
        this.sourceLob = sourceLob;
        this.targetLob = targetLob;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        StorageDesign storageDesign = null;
        if (this.sourceLob != null) {
            storageDesign = this.sourceLob.getStorageDesign();
        } else if (this.targetLob != null) {
            storageDesign = this.targetLob.getStorageDesign();
        }
        boolean oracle11g = storageDesign instanceof StorageDesignOraclev11g;
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(LOB_COLUMN, "column");
        if (oracle11g) {
            this.initProperty(LOB_STORAGE_TYPE, "lobStorageType");
        }
        this.initProperty(LOB_SEGMENT_NAME, "lobSegmentName");
        this.initProperty(TABLESPACE, "tableSpace");
        this.initProperty(STORAGE_IN_ROW, "storageInRow");
        if (oracle11g) {
            this.initProperty(COMPRESSION, "compression");
            this.initProperty(COMPRESSION_TYPE, "compressionType");
            this.initProperty(DUPLICATION, "duplication");
        }
        this.initProperty(LOGGING, "logging");
        this.initProperty(CACHE, "cache");
        this.initProperty(CHUNK, "chunk");
        this.initProperty(OLD_VERSIONS, "oldVersions");
        this.initProperty(PCT_VERSION, "pcTVersion");
        this.initProperty(FREEPOOLS, "freepools");
        this.initProperty(SC_INITIAL_EXTENT, "scInitialExtent");
        this.initProperty(SC_NEXT_EXTENT, "scNextExtent");
        this.initProperty(SC_MIN_EXTENTS, "scMinExtents");
        this.initProperty(SC_MAX_EXTENTS, "scMaxExtents");
        this.initProperty(SC_PCT_INCREASE, "scPctIncrease");
        this.initProperty(SC_BUFFER_POOL, "scBufferPool");
        this.initProperty(SC_FREE_LISTS, "scFreeLists");
        this.initProperty(SC_FREE_LISTS_GRPS, "scFreelistGroups");
    }
}

