/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableConstraintComparatorOracle;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;

public class TableConstraintComparator
extends PropertiesComparator {
    private TableLevelConstraint sourceConstraint;
    private TableLevelConstraint targetConstraint;
    private StorageDesign sourceSD;
    private StorageDesign targetSD;

    public TableConstraintComparator(TableLevelConstraint sourceConstraint, TableLevelConstraint targetConstraint, StorageDesign sourceSD, StorageDesign targetSD) {
        super(sourceConstraint, targetConstraint);
        this.sourceConstraint = sourceConstraint;
        this.targetConstraint = targetConstraint;
        this.sourceSD = sourceSD;
        this.targetSD = targetSD;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        if (this.sourceSD instanceof StorageDesignOracle && this.targetSD instanceof StorageDesignOracle) {
            TableCheckConstraintOracle sourceTCC = null;
            if (this.sourceConstraint != null) {
                sourceTCC = (TableCheckConstraintOracle)((StorageDesignOracle)this.sourceSD).getTableCheckConstraintSet().getById(this.sourceConstraint.getObjectID());
            }
            TableCheckConstraintOracle targetTCC = null;
            if (this.targetConstraint != null) {
                targetTCC = (TableCheckConstraintOracle)((StorageDesignOracle)this.targetSD).getTableCheckConstraintSet().getById(this.targetConstraint.getObjectID());
            }
            this.setPhysicalPropertiesComparator(new TableConstraintComparatorOracle(sourceTCC, targetTCC));
        }
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(RULE);
        if (this.sourceConstraint != null) {
            ph.setLeftValue(this.sourceConstraint.getRule());
        }
        if (this.targetConstraint != null) {
            ph.setRightValue(this.targetConstraint.getRule());
        }
        if (this.isExcludedFromComparison(RULE)) {
            ph.setExcluded(true);
        } else if (this.sourceConstraint != null && this.targetConstraint != null && !this.isEqualClearLine(this.sourceConstraint.getRule(), this.targetConstraint.getRule())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(GEN_CONSTRAINT_IN_DDL);
        if (this.sourceConstraint != null) {
            ph.setLeftValue(this.sourceConstraint.getGenerateInDDL());
        }
        if (this.targetConstraint != null) {
            ph.setRightValue(this.targetConstraint.getGenerateInDDL());
        }
        if (this.isExcludedFromComparison(GEN_CONSTRAINT_IN_DDL)) {
            ph.setExcluded(true);
        } else if (this.sourceConstraint != null && this.targetConstraint != null) {
            ph.setModified(false);
            ph.setSelected(false);
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        if (this.sourceConstraint != null && this.targetConstraint != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(RULE)) continue;
                this.targetConstraint.setRule(this.sourceConstraint.getRule());
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceConstraint == null && this.targetConstraint != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

