/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.COPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ColumnComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public class ColumnComparator
extends COPropertiesComparator {
    private Column targetColumn;
    private Column sourceColumn;
    private ColumnProxy sourceColumnProxy;
    private ColumnProxy targetColumnProxy;
    private boolean tableShouldBeRecreated = false;
    private Map objectsMap;
    public static final String START_WITH = Messages.getString("PropertyNames.StartWith");
    public static final String INCREMENT_BY = Messages.getString("PropertyNames.IncrementBy");
    public static final String IDENTITY_GENERATION = Messages.getString("PropertyNames.IdentityGeneration");
    public static final String DEFAULT_ON_NULL = Messages.getString("PropertyNames.DefaultOnNull");
    public static final String MAX_VALUE = Messages.getString("PropertyNames.MaxValue");
    public static final String MIN_VALUE = Messages.getString("PropertyNames.MinValue");
    public static final String CYCLE = Messages.getString("PropertyNames.Cycle");
    public static final String NOCACHE = Messages.getString("PropertyNames.DisableCache");
    public static final String CACHE = Messages.getString("PropertyNames.Cache");
    public static final String ORDER = Messages.getString("PropertyNames.Order");

    public ColumnComparator(Column column, Column attribute, Map objectsMap) {
        this(column, attribute, null, null, objectsMap);
    }

    public ColumnComparator(Column sourceColumn, Column targetColumn, ColumnProxy sourceColumnProxy, ColumnProxy targetColumnProxy, Map objectsMap) {
        super(sourceColumn, targetColumn);
        EngPropertyHolder ph;
        this.targetColumn = targetColumn;
        this.sourceColumn = sourceColumn;
        this.sourceColumnProxy = sourceColumnProxy;
        this.targetColumnProxy = targetColumnProxy;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
        if (sourceColumn != null && !sourceColumn.getDesign().getSettings().isUseDataTypeKindInCompare() && (ph = this.getPropertyHolderByName(DATA_TYPE_KIND)) != null) {
            ph.setFiltered(true);
            ph.setEditable(false);
        }
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        ColumnProxy columnProxy;
        ColumnComparatorOracle physicalComparator = null;
        ColumnProxy columnProxy2 = columnProxy = this.sourceColumnProxy != null ? this.sourceColumnProxy : this.targetColumnProxy;
        if (columnProxy instanceof ColumnProxyOracle) {
            physicalComparator = new ColumnComparatorOracle(this.sourceColumnProxy, this.targetColumnProxy);
        }
        this.setPhysicalPropertiesComparator(physicalComparator);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromColumnToColumn();
    }

    public Column getTargetColumn() {
        return this.targetColumn;
    }

    public Column getSourceColumn() {
        return this.sourceColumn;
    }

    private void initIdentityColumn(Column sc, Column tc) {
        PropertyHolder ph = new PropertyHolder(IDENTITY_GENERATION);
        String leftValue = null;
        if (sc != null) {
            leftValue = sc.getIdentityGeneration();
        }
        String rightValue = null;
        if (tc != null) {
            rightValue = tc.getIdentityGeneration();
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, IDENTITY_GENERATION, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(START_WITH);
        leftValue = null;
        if (sc != null) {
            leftValue = sc.getAutoIncrementStartWith();
        }
        rightValue = null;
        if (tc != null) {
            rightValue = tc.getAutoIncrementStartWith();
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, START_WITH, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INCREMENT_BY);
        leftValue = null;
        if (sc != null) {
            leftValue = sc.getAutoIncrementIncrementBy().toString();
        }
        rightValue = null;
        if (tc != null) {
            rightValue = tc.getAutoIncrementIncrementBy().toString();
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, INCREMENT_BY, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MIN_VALUE);
        leftValue = null;
        if (sc != null) {
            leftValue = sc.getAutoIncrementMinValue();
        }
        rightValue = null;
        if (tc != null) {
            rightValue = tc.getAutoIncrementMinValue();
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, MIN_VALUE, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MAX_VALUE);
        leftValue = null;
        if (sc != null) {
            leftValue = sc.getAutoIncrementMaxValue();
        }
        rightValue = null;
        if (tc != null) {
            rightValue = tc.getAutoIncrementMaxValue();
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, MAX_VALUE, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CYCLE);
        leftValue = null;
        if (sc != null) {
            leftValue = String.valueOf(sc.isAutoIncrementCycle());
        }
        rightValue = null;
        if (tc != null) {
            rightValue = String.valueOf(tc.isAutoIncrementCycle());
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, CYCLE, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NOCACHE);
        leftValue = null;
        if (sc != null) {
            leftValue = String.valueOf(sc.isAutoIncrementDisableCache());
        }
        rightValue = null;
        if (tc != null) {
            rightValue = String.valueOf(tc.isAutoIncrementDisableCache());
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, NOCACHE, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CACHE);
        leftValue = null;
        if (sc != null) {
            leftValue = sc.getAutoIncrementCache() == null ? "" : sc.getAutoIncrementCache().toString();
        }
        rightValue = null;
        if (tc != null) {
            rightValue = tc.getAutoIncrementCache() == null ? "" : tc.getAutoIncrementCache().toString();
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, CACHE, sc, tc);
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ORDER);
        leftValue = null;
        if (sc != null) {
            leftValue = String.valueOf(sc.isAutoIncrementOrder());
        }
        rightValue = null;
        if (tc != null) {
            rightValue = String.valueOf(tc.isAutoIncrementOrder());
        }
        ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, ORDER, sc, tc);
        this.propertiesList.add(ph);
    }

    public static void setPropertyHolder(PropertiesComparator comp, EngPropertyHolder ph, String leftValue, String rightValue, String name, ModelIDObject source, ModelIDObject target) {
        if (leftValue == null) {
            leftValue = "";
            ph.setLeftValue("");
        } else {
            ph.setLeftValue(leftValue);
        }
        if (rightValue == null) {
            rightValue = "";
            ph.setRightValue("");
        } else {
            ph.setRightValue(rightValue);
        }
        if (comp.isExcludedFromComparison(name)) {
            ph.setExcluded(true);
        } else if (source != null && target != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
    }

    @Override
    protected void initPropertiesList() {
        String rightValue;
        String leftValue;
        super.initPropertiesList();
        PropertyHolder ph = new PropertyHolder(SCOPE);
        if (this.targetColumn != null && this.targetColumn.getScope() != null) {
            ph.setRightValue(this.targetColumn.getScope().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.sourceColumn != null && this.sourceColumn.getScope() != null) {
            ph.setLeftValue(this.sourceColumn.getScope().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.isExcludedFromComparison(SCOPE)) {
            ph.setExcluded(true);
        } else if (this.sourceColumn != null && this.targetColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        StorageDesign sd = null;
        if (this.sourceColumn != null) {
            sd = this.sourceColumn.getRelationalModel().getStorageDesign();
        } else if (this.targetColumn != null) {
            sd = this.targetColumn.getRelationalModel().getStorageDesign();
        }
        if (sd != null && sd instanceof StorageDesignOraclev12c || !DDL_ONLY) {
            ph = new PropertyHolder(DEFAULT_ON_NULL);
            leftValue = null;
            if (this.sourceColumn != null) {
                leftValue = String.valueOf(this.sourceColumn.isDefaultOnNull());
            }
            rightValue = null;
            if (this.targetColumn != null) {
                rightValue = String.valueOf(this.targetColumn.isDefaultOnNull());
            }
            ColumnComparator.setPropertyHolder(this, ph, leftValue, rightValue, DEFAULT_ON_NULL, this.sourceColumn, this.targetColumn);
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(AUTO_INCREMENT);
        ph.setLeftValue(this.sourceColumn != null ? String.valueOf(this.sourceColumn.isAutoIncrementColumn()) : "");
        ph.setRightValue(this.targetColumn != null ? String.valueOf(this.targetColumn.isAutoIncrementColumn()) : "");
        if (this.isExcludedFromComparison(AUTO_INCREMENT)) {
            ph.setExcluded(true);
        } else if (this.sourceColumn != null && this.targetColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(IDENTITY_COLUMN);
        ph.setLeftValue(this.sourceColumn != null ? String.valueOf(this.sourceColumn.isIdentityColumn()) : "");
        ph.setRightValue(this.targetColumn != null ? String.valueOf(this.targetColumn.isIdentityColumn()) : "");
        if (this.isExcludedFromComparison(IDENTITY_COLUMN)) {
            ph.setExcluded(true);
        } else if (this.sourceColumn != null && this.targetColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (sd != null && sd instanceof StorageDesignOraclev12c || !DDL_ONLY) {
            this.initIdentityColumn(this.sourceColumn, this.targetColumn);
        }
        ph = new PropertyHolder(SEQUENCE_NAME);
        leftValue = null;
        if (this.sourceColumn != null) {
            leftValue = this.sourceColumn.getAutoIncrementSequenceName();
        }
        if (leftValue == null) {
            leftValue = "";
        }
        ph.setLeftValue(leftValue);
        rightValue = null;
        if (this.targetColumn != null) {
            rightValue = this.targetColumn.getAutoIncrementSequenceName();
        }
        if (rightValue == null) {
            rightValue = "";
        }
        ph.setRightValue(rightValue);
        if (this.isExcludedFromComparison(SEQUENCE_NAME)) {
            ph.setExcluded(true);
        } else if (this.sourceColumn != null && this.targetColumn != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TRIGGER_NAME);
        leftValue = null;
        if (this.sourceColumn != null) {
            leftValue = this.sourceColumn.getAutoIncrementTriggerName();
        }
        if (leftValue == null) {
            leftValue = "";
        }
        ph.setLeftValue(leftValue);
        rightValue = null;
        if (this.targetColumn != null) {
            rightValue = this.targetColumn.getAutoIncrementTriggerName();
        }
        if (rightValue == null) {
            rightValue = "";
        }
        ph.setRightValue(rightValue);
        if (this.isExcludedFromComparison(TRIGGER_NAME)) {
            ph.setExcluded(true);
        } else if (this.sourceColumn != null && this.targetColumn != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(DEPEND_ON_FK);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceColumn != null ? String.valueOf(this.sourceColumn.getDependOnForeignKey()) : "");
            ph.setRightValue(this.targetColumn != null ? String.valueOf(this.targetColumn.getDependOnForeignKey()) : "");
            if (this.isExcludedFromComparison(DEPEND_ON_FK)) {
                ph.setExcluded(true);
            } else if (this.targetColumn != null && this.sourceColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(DEPEND_ON_FK_AS_MANDATORY);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceColumn != null ? String.valueOf(this.sourceColumn.isDependOnFK_AsMandatory()) : "");
            ph.setRightValue(this.targetColumn != null ? String.valueOf(this.targetColumn.isDependOnFK_AsMandatory()) : "");
            if (this.isExcludedFromComparison(DEPEND_ON_FK_AS_MANDATORY)) {
                ph.setExcluded(true);
            } else if (this.targetColumn != null && this.sourceColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
    }

    private void copyPropertiesFromColumnToColumn() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            this.targetColumn.setTemporaryWriteable(true);
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(SCOPE)) {
                    if (this.sourceColumn.getScope() != null) {
                        Table tTable;
                        Table sTable = (Table)this.sourceColumn.getScope();
                        if (sTable == null || (tTable = (Table)this.objectsMap.get(sTable.getObjectID())) == null) continue;
                        this.targetColumn.setScopeId(tTable.getObjectID());
                        continue;
                    }
                    this.targetColumn.setScopeId(null);
                    continue;
                }
                if (ph.getName().equals(AUTO_INCREMENT)) {
                    this.targetColumn.setAutoIncrementColumn(this.sourceColumn.isAutoIncrementColumn());
                    continue;
                }
                if (ph.getName().equals(IDENTITY_COLUMN)) {
                    this.targetColumn.setIdentityColumn(this.sourceColumn.isIdentityColumn());
                    continue;
                }
                if (ph.getName().equals(SEQUENCE_NAME)) {
                    this.targetColumn.setAutoIncrementSequenceName(this.sourceColumn.getAutoIncrementSequenceName());
                    continue;
                }
                if (ph.getName().equals(TRIGGER_NAME)) {
                    this.targetColumn.setAutoIncrementTriggerName(this.sourceColumn.getAutoIncrementTriggerName());
                    continue;
                }
                if (ph.getName().equals(DEPEND_ON_FK)) {
                    FKIndexAssociation fk = this.sourceColumn.getDependOnForeignKey();
                    if (fk != null) {
                        FKIndexAssociation tfk = (FKIndexAssociation)this.objectsMap.get(fk.getObjectID());
                        if (tfk == null) continue;
                        this.targetColumn.setDependOnForeignKey(tfk);
                        continue;
                    }
                    this.targetColumn.setDependOnForeignKey(null);
                    this.targetColumn.setDependOnForeignKeyID("");
                    continue;
                }
                if (!ph.getName().equals(DEPEND_ON_FK_AS_MANDATORY)) continue;
                this.targetColumn.setDependOnFK_AsMandatory(this.sourceColumn.isDependOnFK_AsMandatory());
            }
            this.targetColumn.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceColumn != null ? this.sourceColumn.getContainerWithKeyObject().getName() + "." + this.sourceColumn.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetColumn != null ? this.targetColumn.getContainerWithKeyObject().getName() + "." + this.targetColumn.getName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(PropertiesComparator.DATA_TYPE) || !ph.isSelected()) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceColumn == null && this.targetColumn != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public ColumnProxy getSourceColumnProxy() {
        return this.sourceColumnProxy;
    }

    public ColumnProxy getTargetColumnProxy() {
        return this.targetColumnProxy;
    }

    public boolean isDataTypeChanged() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(PropertiesComparator.DATA_TYPE) || !ph.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTableShouldBeRecreated() {
        return this.tableShouldBeRecreated;
    }

    public void setTableShouldBeRecreated(boolean tableShouldBeRecreated) {
        this.tableShouldBeRecreated = tableShouldBeRecreated;
    }

    public boolean isRecreateTable() {
        return this.isTableShouldBeRecreated() && this.hasToBeRename();
    }
}

