/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.FontObjectWr;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;

public class Label
extends MultiShapedDesignObject
implements EditableFonts {
    private List editableFonts = new ArrayList();
    private int site = 1;
    private TVConnector tvConnector;
    private Point2D lastPos = new Point2D.Double(0.0, 0.0);
    private boolean connectorSelected = false;

    public Label(DesignPart designPart) {
        super(designPart);
        this.noBackgroundColor = true;
        this.noForegroundColor = true;
    }

    @Override
    public String getObjectTypeName() {
        return "Label";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "Label";
    }

    public String getText() {
        return this.getComment();
    }

    public void setText(String text) {
        this.setComment(text);
    }

    @Override
    public String getFCObjectType() {
        if (this.isRelationshipAttributesLabel()) {
            return "Relationship Attributes";
        }
        return "Label";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public int getSite() {
        return this.site;
    }

    public void setSite(int site) {
        this.site = site;
    }

    public boolean isCenterLabel() {
        return this.site == 1;
    }

    public TVConnector getTVConnector() {
        return this.tvConnector;
    }

    public void setTVConnector(TVConnector tvConnector) {
        this.tvConnector = tvConnector;
    }

    public Point2D getLastPos() {
        return this.lastPos;
    }

    public void setLastPos(Point2D lastPos) {
        this.lastPos.setLocation(lastPos);
    }

    public boolean isConnectorSelected() {
        return this.connectorSelected;
    }

    public void setConnectorSelected(boolean connectorSelected) {
        this.connectorSelected = connectorSelected;
    }

    public Rectangle getBounds() {
        if (this.tvConnector != null) {
            switch (this.site) {
                case 0: {
                    return this.tvConnector.getSourceLabelBounds();
                }
                case 1: {
                    return this.tvConnector.getLabelBounds();
                }
                case 2: {
                    return this.tvConnector.getTargetLabelBounds();
                }
            }
        }
        return null;
    }

    public void setBounds(Rectangle rect) {
        if (this.tvConnector != null && rect != null) {
            switch (this.site) {
                case 0: {
                    this.tvConnector.setSourceLabelBounds(rect);
                    break;
                }
                case 1: {
                    this.tvConnector.setLabelBounds(rect);
                    break;
                }
                case 2: {
                    this.tvConnector.setTargetLabelBounds(rect);
                }
            }
        }
    }

    public boolean isRelationshipAttributesLabel() {
        return this.getDesignPart() instanceof LogicalDesign && this.isCenterLabel();
    }

    @Override
    public Color getBackgroundColor() {
        return super.getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        super.setBackgroundColor(backgroundColor);
    }

    @Override
    public Color getForegroundColor() {
        return super.getForegroundColor();
    }

    @Override
    public void setForegroundColor(Color foregroundColor) {
        super.setForegroundColor(foregroundColor);
    }

    @Override
    public boolean useDefaultColor() {
        TopView tv = this.getTopView();
        if (tv != null) {
            return tv.useDefaultColor();
        }
        return super.useDefaultColor();
    }

    @Override
    public void setUseDefaultColor(boolean useDefaultColor) {
        TopView tv = this.getTopView();
        if (tv != null) {
            tv.setUseDefaultColor(useDefaultColor);
        }
        super.setUseDefaultColor(useDefaultColor);
    }

    public List getFontObjectWrappers() {
        TopView tv = this.getTopView();
        if (tv != null && tv.useCustomFormat()) {
            return tv.getFontObjectWrappers();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addFontObjectWrapper(FontObjectWr foWr) {
        TopView tv = this.getTopView();
        if (tv != null && tv.useCustomFormat()) {
            tv.addFontObjectWrapper(foWr);
        }
        super.addFontObjectWrapper(foWr);
    }
}

