/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDOracleSystemType;
import oracle.dbtools.crest.model.datatype.oracle.MDDataTypeFactoryOracle;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDDayToSecondOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDDbUriTypeOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDHttpUriTypeOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDTimestampOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDTimestampWithLocalZoneOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDTimestampWithTimeZoneOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDUriTypeOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDXdbUriTypeOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDXmlTypeOraclev9i;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDYearToMonthOraclev9i;
import oracle.dbtools.crest.util.options.Settings;

public class MDDataTypeFactoryOraclev9i
extends MDDataTypeFactoryOracle {
    public MDDataTypeFactoryOraclev9i(Settings settings) {
        super(settings);
    }

    @Override
    protected void initFlyWeightsTimeTypes() {
    }

    @Override
    protected void initFlyWeights() {
        super.initFlyWeights();
        this.flyweights.put("XMLTYPE", new MDXmlTypeOraclev9i());
        this.flyweights.put("URITYPE", new MDUriTypeOraclev9i());
        this.flyweights.put("HTTPURITYPE", new MDHttpUriTypeOraclev9i());
        this.flyweights.put("XDBURITYPE", new MDXdbUriTypeOraclev9i());
        this.flyweights.put("DBURITYPE", new MDDbUriTypeOraclev9i());
        this.initSystemTypes();
    }

    protected void initSystemTypes() {
        this.flyweights.put("SYS.ANYDATA", new MDOracleSystemType("SYS.ANYDATA"));
        this.flyweights.put("SYS.ANYDATASET", new MDOracleSystemType("SYS.ANYDATASET"));
        this.flyweights.put("SYS.ANYTYPE", new MDOracleSystemType("SYS.ANYTYPE"));
        this.flyweights.put("ORDSYS.ORDAudio", new MDOracleSystemType("ORDSYS.ORDAudio"));
        this.flyweights.put("ORDSYS.ORDDoc", new MDOracleSystemType("ORDSYS.ORDDoc"));
        this.flyweights.put("ORDSYS.ORDImage", new MDOracleSystemType("ORDSYS.ORDImage"));
        this.flyweights.put("ORDSYS.ORDImageSignature", new MDOracleSystemType("ORDSYS.ORDImageSignature"));
        this.flyweights.put("ORDSYS.ORDVideo", new MDOracleSystemType("ORDSYS.ORDVideo"));
    }

    @Override
    protected void initHeavyWeights() {
        super.initHeavyWeights();
        this.heavyweights.put("TIMESTAMP", MDTimestampOraclev9i.class);
        this.heavyweights.put("TIMESTAMP WITH TIME ZONE", MDTimestampWithTimeZoneOraclev9i.class);
        this.heavyweights.put("TIMESTAMP WITH LOCAL TIME ZONE", MDTimestampWithLocalZoneOraclev9i.class);
        this.heavyweights.put("INTERVAL YEAR TO MONTH", MDYearToMonthOraclev9i.class);
        this.heavyweights.put("INTERVAL DAY TO SECOND", MDDayToSecondOraclev9i.class);
    }

    @Override
    public MDDataType createType(String name, String size) {
        MDDataType dataType = super.createType(name, size);
        if (dataType != null) {
            return dataType;
        }
        if ("INTERVAL YEAR TO MONTH".equals(name)) {
            MDYearToMonthOraclev9i ytm = new MDYearToMonthOraclev9i();
            ytm.setPrecision(size);
            return ytm;
        }
        if ("TIMESTAMP WITH TIME ZONE".equals(name)) {
            MDTimestampWithTimeZoneOraclev9i tstamp = new MDTimestampWithTimeZoneOraclev9i();
            tstamp.setPrecision(size);
            return tstamp;
        }
        if ("TIMESTAMP WITH LOCAL TIME ZONE".equals(name)) {
            MDTimestampWithLocalZoneOraclev9i tstamp = new MDTimestampWithLocalZoneOraclev9i();
            tstamp.setPrecision(size);
            return tstamp;
        }
        if ("TIMESTAMP".equals(name)) {
            MDTimestampOraclev9i tstamp = new MDTimestampOraclev9i();
            tstamp.setPrecision(size);
            return tstamp;
        }
        if ("INTERVAL DAY TO SECOND".equals(name)) {
            MDDayToSecondOraclev9i dts = new MDDayToSecondOraclev9i();
            dts.setPrecision(size);
            return dts;
        }
        return dataType;
    }

    @Override
    public MDDataType createType(String name, int precision, int scale) {
        MDDataType type = super.createType(name, precision, scale);
        if (type != null) {
            return type;
        }
        if ("TIMESTAMP".equals(name)) {
            MDTimestampOraclev9i tstamp = new MDTimestampOraclev9i();
            tstamp.setPrecision(precision);
            return tstamp;
        }
        if ("INTERVAL DAY TO SECOND".equals(name)) {
            MDDayToSecondOraclev9i dts = new MDDayToSecondOraclev9i();
            dts.setPrecision(precision);
            dts.setScale(scale);
            return dts;
        }
        return null;
    }
}

