/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.TSDPPolicySet;
import oracle.dbtools.crest.model.TSDPSubPolicy;
import oracle.dbtools.crest.util.logging.Logger;

public class TSDPPolicy
extends ModelIDObject {
    public static final String TYPE_NAME = "TSDPPolicy";
    private boolean isBeingRemoved = false;
    private TSDPPolicySet tsdpPolicySet;
    private boolean removed = false;
    private List<TSDPSubPolicy> elements;
    private List sensitiveTypesList;
    private boolean generateInDDL = true;
    private static final Logger LOGGER = new Logger(TSDPPolicy.class);

    public TSDPPolicy() {
        this.createGlobalID();
        this.elements = new ArrayList<TSDPSubPolicy>();
        this.sensitiveTypesList = new ArrayList();
    }

    @Override
    public String getOwnerDesignName() {
        return "";
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            this.elements.clear();
            if (this.getTSDPPolicySet() != null) {
                this.getTSDPPolicySet().remove(this);
            }
            ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
            event.setAffected(this);
            this.fireChange(event);
            event.setAffected(null);
            this.setIsBeingRemoved(false);
            this.removed = true;
        }
    }

    protected void setIsBeingRemoved(boolean value) {
        this.isBeingRemoved = value;
    }

    public boolean getIsBeingRemoved() {
        return this.isBeingRemoved;
    }

    public void setTSDPPolicySet(TSDPPolicySet set) {
        this.tsdpPolicySet = set;
    }

    public TSDPPolicySet getTSDPPolicySet() {
        return this.tsdpPolicySet;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public List<TSDPSubPolicy> getElements() {
        return this.elements;
    }

    public void addTSDPSubPolicy(TSDPSubPolicy element) {
        if (!this.elements.contains(element)) {
            this.elements.add(element);
        }
    }

    public void removeTSDPSubPolicy(TSDPSubPolicy element) {
        this.elements.remove(element);
    }

    public boolean contains(TSDPSubPolicy element) {
        return this.elements.contains(element);
    }

    public TSDPSubPolicy createSubPolicy() {
        return this.createSubPolicy("");
    }

    public TSDPSubPolicy createSubPolicy(String name) {
        TSDPSubPolicy policy = new TSDPSubPolicy();
        policy.setName(name);
        policy.setTsdpPolicy(this);
        this.add(policy);
        return policy;
    }

    public void add(TSDPSubPolicy object) {
        if (object == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(object)) {
            return;
        }
        if (!TSDPSubPolicy.class.isAssignableFrom(object.getClass())) {
            LOGGER.error("Class: " + object.getClass());
            LOGGER.error("Expected: " + TSDPSubPolicy.class);
            throw new RuntimeException("Wrong class added to container.");
        }
        this.elements.add(object);
        object.setTsdpPolicy(this);
        this.getDesign().getTSDPSubPolicySet().add(object);
    }

    public boolean moveElementToIndex(TSDPSubPolicy object, int index) {
        if (this.elements.indexOf(object) == index) {
            return true;
        }
        if (this.elements.contains(object) && this.elements.size() > index && index >= 0) {
            this.elements.remove(object);
            this.elements.add(index, object);
            return true;
        }
        return false;
    }

    public TSDPSubPolicy getElementByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator<TSDPSubPolicy> it = this.elements.iterator();
        while (it.hasNext()) {
            TSDPSubPolicy policy = it.next();
            if (!localID.equals(policy.getObjectID())) continue;
            it = null;
            return policy;
        }
        it = null;
        return null;
    }

    public TSDPSubPolicy getElementByName(String name) {
        if (name == null) {
            return null;
        }
        Iterator<TSDPSubPolicy> it = this.elements.iterator();
        while (it.hasNext()) {
            TSDPSubPolicy policy = it.next();
            if (!name.equals(policy.getObjectID())) continue;
            it = null;
            return policy;
        }
        it = null;
        return null;
    }

    public List getSensitiveTypesList() {
        return this.sensitiveTypesList;
    }

    public void addSensitiveType(SensitiveType sensitiveType) {
        if (sensitiveType != null && !this.sensitiveTypesList.contains(sensitiveType)) {
            this.sensitiveTypesList.add(sensitiveType);
        }
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        ModelIDObject object = null;
        if ("sensitiveType".equalsIgnoreCase(propertyName) || "sensitiveTypes".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getSensitiveTypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public boolean getGenerateInDDL() {
        return this.generateInDDL;
    }

    public void setGenerateInDDL(boolean generateInDDL) {
        this.generateInDDL = generateInDDL;
    }
}

