/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.loading;

import java.io.File;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.DDLFileMaker;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;

public class FileSystemDesignLoader {
    public static void main(String[] args) {
        String desp = "D:/temp/OE_874.dmd";
        Design.dmInternalsDistDir = "D:/Projects/DMWS/datamodeler";
        try {
            Design des = new Design();
            des.setLoading(true);
            LogicalDataTypesReader lr = new LogicalDataTypesReader();
            lr.recreateLogicalTypes(des);
            FileSystemDesignLoader fl = new FileSystemDesignLoader();
            fl.openDesign(des, desp);
            des.setLoading(false);
            RelationalDesign relModel = des.getRelationalDesign();
            StorageDesign sd = relModel.getStorageDesign();
            DDLFileMaker ddlFileMaker = new DDLFileMaker(des);
            ddlFileMaker.setStorageDesign(sd);
            ddlFileMaker.generateDDLContent();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    static void printCols(RelationalDesign rd) {
        Iterator it = rd.getTableSet().iterator();
        while (it.hasNext()) {
            ContainedObject[] cos;
            Table t = (Table)it.next();
            for (ContainedObject containedObject : cos = t.getElements()) {
            }
        }
    }

    public void openDesign(Design design, String desingPath) {
        String ext = ".dmd";
        File selected = new File(desingPath);
        if (selected != null && selected.exists()) {
            String designPath = selected.getParent();
            String fileName = selected.getName();
            String designName = FileUtils.removeExt(fileName);
            int pos = fileName.lastIndexOf(".");
            if (pos > -1) {
                ext = fileName.substring(pos);
            }
            this.openDesign(design, designPath, designName, ext);
        }
    }

    public boolean openDesign(Design design, String desingPath, String designName, String ext) {
        design.setFileName(designName);
        design.setDesignPath(desingPath);
        boolean result = false;
        result = XMLTransformationManager.getInstance().openDesign(design, new File(design.getDesignPath(), designName + ext));
        XMLTransformationManager.getInstance().openDesignPart(design.getDataTypesDesign());
        for (RelationalDesign relModel : design.getRelationalDesigns()) {
            XMLTransformationManager.getInstance().openDesignPart(relModel);
            RDBMSSite defaultSite = relModel.getSelectedRDBMSSite();
            StorageDesign storageDesign = relModel.getStorageDesign(defaultSite);
            File file = new File(storageDesign.getStorageName());
            if (!file.exists()) continue;
            XMLTransformationManager.getInstance().openPhysicalModel(storageDesign);
            storageDesign.setOpen(true);
        }
        return result;
    }
}

