/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerSchedule;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerSchedule
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_SCHEDULE";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_SCHEDULES";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_SCHEDULES";

    public MOHSchedulerSchedule(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) continue;
                SchedulerSchedule sched = new SchedulerSchedule();
                for (String prop : sched.getPropsList()) {
                    String value = null;
                    try {
                        value = rs.getString(prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("propname - " + prop);
                    }
                    sched.setProperty(prop, value);
                }
                rs.close();
                sched.validate();
                res.add(sched);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select \r\n    OWNER,\r\n    SCHEDULE_NAME,\r\n    SCHEDULE_TYPE,\r\n    to_char( START_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as START_DATE,\r\n    REPEAT_INTERVAL,\r\n    EVENT_QUEUE_OWNER,\r\n    EVENT_QUEUE_NAME,\r\n    EVENT_QUEUE_AGENT,\r\n    EVENT_CONDITION,\r\n    FILE_WATCHER_OWNER,\r\n    FILE_WATCHER_NAME,\r\n    to_char( END_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as END_DATE,\r\n    COMMENTS from " + (dba ? DBA_TABLE : ALL_TABLE) + " \nwhere owner = ? and SCHEDULE_NAME = ?";
        return sql;
    }
}

