/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerProgram
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_PROGRAM";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_PROGRAMS";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_PROGRAMS";
    public static final String DBA_ARGS_TABLE = "SYS.DBA_SCHEDULER_PROGRAM_ARGS";
    public static final String ALL_ARGS_TABLE = "SYS.ALL_SCHEDULER_PROGRAM_ARGS";

    public MOHSchedulerProgram(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        String args_sql = this.getArgumentsSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        PreparedStatement statement_a = null;
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) continue;
                SchedulerProgram prog = new SchedulerProgram();
                for (String prop : prog.getPropsList()) {
                    String value = null;
                    try {
                        value = rs.getString(prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("propname - " + prop);
                    }
                    prog.setProperty(prop, value);
                }
                rs.close();
                res.add(prog);
                if (prog.getNumberOfArguments() <= 0) continue;
                if (statement_a == null) {
                    statement_a = conn.prepareStatement(args_sql);
                }
                this.processArguments(conn, statement_a, prog, dbo);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processArguments(Connection conn, PreparedStatement statement, SchedulerProgram prog, DBObject dbo) {
        ResultSet rs = null;
        try {
            statement.setString(1, dbo.getSchema());
            statement.setString(2, dbo.getName());
            rs = statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    SchedulerArgument arg = new SchedulerArgument();
                    for (String prop : arg.getPropsList()) {
                        String value = null;
                        try {
                            value = rs.getString(prop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("propname - " + prop);
                        }
                        arg.setProperty(prop, value);
                    }
                    prog.addArgument(arg);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Closeables.close(rs);
        }
    }

    String getSQL(boolean dba) {
        String sql = "select \np.OWNER,\np.PROGRAM_NAME,\np.PROGRAM_TYPE,\np.PROGRAM_ACTION,\np.NUMBER_OF_ARGUMENTS,\np.ENABLED,\np.DETACHED,\ncase\nwhen p.SCHEDULE_LIMIT is not null then\nreplace(to_char(cast(p.SCHEDULE_LIMIT as interval day(3) to second(0)),'DD\" \" HH24:MI:SS'),'+0','+') \nelse null end as SCHEDULE_LIMIT,\np.MAX_RUNS,\np.MAX_FAILURES,\ncase\nwhen p.MAX_RUN_DURATION is not null then\nreplace(to_char(cast(p.MAX_RUN_DURATION as interval day(3) to second(0)),'DD\" \" HH24:MI:SS'),'+0','+') \nelse null end as MAX_RUN_DURATION,\np.HAS_CONSTRAINTS,\n--p.NLS_ENV,\np.COMMENTS\nfrom " + (dba ? DBA_TABLE : ALL_TABLE) + " p\nwhere p.owner = ? and p.PROGRAM_NAME = ?";
        return sql;
    }

    String getArgumentsSQL(boolean dba) {
        String sql = "select\n--p.OWNER,\n--p.PROGRAM_NAME,\np.ARGUMENT_NAME,\np.ARGUMENT_POSITION,\np.ARGUMENT_TYPE,\np.METADATA_ATTRIBUTE,\np.DEFAULT_VALUE --,\n--p.DEFAULT_ANYDATA_VALUE\n--p.OUT_ARGUMENT\nfrom " + (dba ? DBA_ARGS_TABLE : ALL_ARGS_TABLE) + " p \nwhere p.owner = ? and p.PROGRAM_NAME = ? \norder by p.ARGUMENT_POSITION";
        return sql;
    }
}

