/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerJobClass;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerJobClass
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_JOB_CLASS";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_JOB_CLASSES";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_JOB_CLASSES";

    public MOHSchedulerJobClass(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object statement_a = null;
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs != null && rs.next()) {
                    SchedulerJobClass prog = new SchedulerJobClass();
                    for (String prop : prog.getPropsList()) {
                        String value = null;
                        try {
                            value = rs.getString(prop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("propname - " + prop);
                        }
                        prog.setProperty(prop, value);
                    }
                    prog.validate();
                    res.add(prog);
                }
                rs.close();
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select \nOWNER,\r\nJOB_CLASS_NAME,\r\nRESOURCE_CONSUMER_GROUP,\r\nSERVICE,\r\nLOGGING_LEVEL,\r\nLOG_HISTORY,\r\nCOMMENTS \r\nfrom " + (dba ? DBA_TABLE : ALL_TABLE) + " p\nwhere p.owner = ? and p.JOB_CLASS_NAME = ?";
        return sql;
    }
}

