/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v10g;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHBitmapIndexesv10g
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BITMAP JOIN";
    private static final Logger LOGGER = new Logger(MOHBitmapIndexesv10g.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement jcol_statement = null;

    public MOHBitmapIndexesv10g(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHBitmapIndexesv10g(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.jcol_statement = null;
        try {
            StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
            for (BitmapJoinIndexOracle bmjInd : sd.getBitmapJoinIndexSet()) {
                this.initJoinColumns(sqlConnection, bmjInd, bmjInd.getUser().getName(), importLog);
            }
        }
        finally {
            if (this.jcol_statement != null) {
                this.jcol_statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initJoinColumns(Connection sqlConnection, BitmapJoinIndexOracle bitmapIndex, String owner, ImportLogger importLog) throws SQLException {
        if (this.jcol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("INNER_TABLE_OWNER").append(',');
            buffer.append("INNER_TABLE_NAME").append(',');
            buffer.append("INNER_TABLE_COLUMN").append(',');
            buffer.append("OUTER_TABLE_OWNER").append(',');
            buffer.append("OUTER_TABLE_NAME").append(',');
            buffer.append("OUTER_TABLE_COLUMN").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_join_ind_columns" : "all_join_ind_columns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("INDEX_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.jcol_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.jcol_statement.setString(1, owner);
            this.jcol_statement.setString(2, bitmapIndex.getName());
            rs = this.jcol_statement.executeQuery();
            HashMap<Table, ArrayList<String>> map = new HashMap<Table, ArrayList<String>>();
            if (rs != null) {
                while (rs.next()) {
                    String innerTableOwner = rs.getString("INNER_TABLE_OWNER");
                    String innerTable = rs.getString("INNER_TABLE_NAME");
                    String innerColumn = rs.getString("INNER_TABLE_COLUMN");
                    BitmapJoinIndexOracle.ColumnHolder ch = new BitmapJoinIndexOracle.ColumnHolder(innerTableOwner, innerTable, innerColumn);
                    String outerTableOwner = rs.getString("OUTER_TABLE_OWNER");
                    String outerTable = rs.getString("OUTER_TABLE_NAME");
                    String outerColumn = rs.getString("OUTER_TABLE_COLUMN");
                    ch.setOuterColumn(outerTableOwner, outerTable, outerColumn);
                    bitmapIndex.getJoinColumnHolders().add(ch);
                    Table iTable = this.getRelationalDesign().getTableSet().getBySchemaAndName(innerTableOwner, innerTable);
                    Table oTable = this.getRelationalDesign().getTableSet().getBySchemaAndName(outerTableOwner, outerTable);
                    if (iTable == null || oTable == null) continue;
                    Column iColumn = (Column)iTable.getElementByName(innerColumn);
                    Column oColumn = (Column)oTable.getElementByName(outerColumn);
                    if (iColumn == null || oColumn == null) continue;
                    bitmapIndex.setJoinColumns(oColumn.getObjectID());
                    bitmapIndex.setJoinColumns(iColumn.getObjectID());
                    ArrayList<String> list = (ArrayList<String>)map.get(oTable);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put(oTable, list);
                    }
                    list.add(oColumn.getName());
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                Index index = this.getUniqueIndexForColumnNames((Table)entry.getKey(), (List)entry.getValue());
                if (index == null) continue;
                bitmapIndex.setDimensionKeys(((Table)entry.getKey()).getObjectID());
                bitmapIndex.setDimensionKeys(index.getObjectID());
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHBitmapIndexesv10g.initJoinColumns():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        ArrayList copy = new ArrayList();
        copy.addAll(names);
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < names.size(); ++j) {
                if (!columns[i].getName().equalsIgnoreCase((String)names.get(j))) continue;
                copy.remove(names.get(j));
            }
        }
        return copy.size() == 0;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        if (sd != null) {
            Object[] ips;
            for (Object obj : ips = sd.getIndexProxySet().toArray()) {
                Index ind;
                IndexProxyOracle ip = (IndexProxyOracle)obj;
                if (ip.getBitmapJoinIndex() == null || (ind = (Index)ip.getObject()) == null) continue;
                ind.remove();
            }
        }
    }
}

