/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHMViewLog
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "MATERIALIZED_VIEW_LOG";
    private static final Logger LOGGER = new Logger(MOHMViewLog.class);
    public static String LOG_OWNER = "LOG_OWNER";
    public static String MASTER = "MASTER";
    public static String LOG_TABLE = "LOG_TABLE";
    public static String ROWIDS = "ROWIDS";
    public static String PRIMARY_KEY = "PRIMARY_KEY";
    public static String OBJECT_ID = "OBJECT_ID";
    public static String FILTER_COLUMNS = "FILTER_COLUMNS";
    public static String SEQUENCE = "SEQUENCE";
    public static String INCLUDE_NEW_VALUES = "INCLUDE_NEW_VALUES";
    public static String PURGE_ASYNCHRONOUS = "PURGE_ASYNCHRONOUS";
    public static String PURGE_DEFERRED = "PURGE_DEFERRED";
    public static String PURGE_START = "PURGE_START";
    public static String PURGE_INTERVAL = "PURGE_INTERVAL";
    public static String LAST_PURGE_DATE = "LAST_PURGE_DATE";
    public static String LAST_PURGE_STATUS = "LAST_PURGE_STATUS";
    public static String NUM_ROWS_PURGED = "NUM_ROWS_PURGED";
    public static String COMMIT_SCN_BASED = "COMMIT_SCN_BASED";
    protected boolean dbaUser;

    public MOHMViewLog(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHMViewLog(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        PreparedStatement statement = null;
        try {
            for (DBObject dboNext : schemas) {
                if (!dboNext.isSelected()) continue;
                if (statement == null) {
                    try {
                        String filterCondition = this.getFilterConditionOracle("MASTER");
                        Object sql = "SELECT\n    LOG_OWNER,\n    MASTER,\n    LOG_TABLE\n FROM\n" + (this.dbaUser ? " DBA_MVIEW_LOGS " : " ALL_MVIEW_LOGS ") + " WHERE LOG_OWNER = ? ";
                        if (filterCondition != null && !filterCondition.isEmpty()) {
                            sql = (String)sql + " AND " + filterCondition;
                        }
                        sql = (String)sql + " ORDER BY MASTER";
                        int limit = this.getDbmeHandler().getLimit();
                        if (limit > 0) {
                            sql = this.getDbmeHandler().getPaginatedQuery((String)sql);
                        }
                        statement = sqlConnection.prepareStatement((String)sql);
                    }
                    catch (Exception e) {
                        System.out.println("MOHMViewLog.extract(): " + e.getMessage());
                        LOGGER.error("MOHMViewLog.extract():", e);
                    }
                }
                try {
                    statement.setString(1, dboNext.getName());
                    ResultSet rs = statement.executeQuery();
                    try {
                        if (rs == null) continue;
                        while (rs.next()) {
                            String schema = rs.getString(1);
                            String tName = rs.getString(2);
                            String logTable = rs.getString(3);
                            DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tName, OBJECT_TYPE, schema);
                            dboTs.setLogTable(logTable);
                            list.add(dboTs);
                        }
                        rs.close();
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("MOHMViewLog.extract(): " + e.getMessage());
                    LOGGER.error("MOHMViewLog.extract():", e);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
        return list;
    }

    public String getQuery(StorageDesign storageDesign) {
        String sql = "SELECT\n    LOG_OWNER,\n    MASTER,\n    LOG_TABLE,\n    ROWIDS,\n    PRIMARY_KEY,\n    OBJECT_ID,\n    FILTER_COLUMNS,\n    SEQUENCE,\n    INCLUDE_NEW_VALUES,\n    PURGE_ASYNCHRONOUS,\n    PURGE_DEFERRED,\n    to_char(PURGE_START,'YYYY-MM-DD HH24:MI:SS') PURGE_START,\n    PURGE_INTERVAL,\n    LAST_PURGE_DATE,\n    LAST_PURGE_STATUS,\n    NUM_ROWS_PURGED,\n    COMMIT_SCN_BASED\n FROM\n" + (this.dbaUser ? " DBA_MVIEW_LOGS " : " ALL_MVIEW_LOGS ") + " WHERE LOG_OWNER = ? AND MASTER = ?";
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        PreparedStatement statement = null;
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                ResultSet rs;
                DBObject dbo;
                block14: {
                    dbo = (DBObject)selectedObjects.get(i);
                    if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                    rs = null;
                    try {
                        try {
                            if (statement == null) {
                                String query = this.getQuery(storageDesign);
                                statement = sqlConnection.prepareStatement(query);
                            }
                            statement.setString(1, dbo.getSchema());
                            statement.setString(2, dbo.getName());
                            rs = statement.executeQuery();
                        }
                        catch (SQLSyntaxErrorException e) {
                            LOGGER.error("MOHMViewLog.generate", e);
                        }
                        if (rs == null) break block14;
                        if (rs.next()) {
                            if (storageDesign instanceof StorageDesignOracle) {
                                MaterializedViewLogOracle mvlog = ((StorageDesignOracle)storageDesign).createMaterializedViewLogOracle();
                                mvlog.setName(dbo.getName());
                                this.setProperties(mvlog, rs, dbo);
                                this.stampModelObject(mvlog, dbo);
                            } else {
                                LOGGER.error("Unable to find Storage Design!");
                            }
                        }
                        rs.close();
                    }
                    catch (Exception e) {
                        try {
                            System.out.println("MOHMViewLog.generate(): " + e.getMessage());
                            LOGGER.error("MOHMViewLog.generate():", e);
                        }
                        catch (Throwable throwable) {
                            Closeables.close(rs);
                            throw throwable;
                        }
                        Closeables.close((Object)rs);
                    }
                }
                Closeables.close((Object)rs);
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
        }
        finally {
            Closeables.close(statement);
        }
    }

    private void setProperties(MaterializedViewLogOracle mvlog, ResultSet rs, DBObject dbo) {
        TableProxyOracle tp;
        StorageDesign sd = mvlog.getStorageDesign();
        RelationalDesign rd = sd.getPhysicalDesign();
        Table masterTable = rd.getTableSet().getBySchemaAndName(dbo.getSchema(), dbo.getName());
        if (masterTable != null && (tp = (TableProxyOracle)sd.getStorageObject(masterTable.getObjectID())) != null) {
            mvlog.setTableProxy(tp);
        }
        try {
            String rowIDs = rs.getString(ROWIDS);
            String pk = rs.getString(PRIMARY_KEY);
            String objID = rs.getString(OBJECT_ID);
            String filterColumns = rs.getString(FILTER_COLUMNS);
            String sequence = rs.getString(SEQUENCE);
            String inclNewValues = rs.getString(INCLUDE_NEW_VALUES);
            String purgeAsync = rs.getString(PURGE_ASYNCHRONOUS);
            String purgeDeferred = rs.getString(PURGE_DEFERRED);
            String purgeStart = rs.getString(PURGE_START);
            String purgeInterval = rs.getString(PURGE_INTERVAL);
            String commitSCN = rs.getString(COMMIT_SCN_BASED);
            mvlog.setRowIDLogged(rowIDs);
            mvlog.setPkLogged(pk);
            mvlog.setSequenceLogged(sequence);
            mvlog.setNewValues(inclNewValues);
            Table logTable = rd.getTableSet().getBySchemaAndName(dbo.getSchema(), dbo.getLogTable());
            if (logTable != null) {
                logTable.setOracleLogTable(true);
                logTable.setTypeID("3");
                TableProxyOracle tp2 = (TableProxyOracle)sd.getStorageObject(logTable.getObjectID());
                if (tp2 != null) {
                    mvlog.setLogTableProxy(tp2);
                }
            }
            mvlog.setObjectIDLogged(objID);
            if ("YES".equalsIgnoreCase(commitSCN)) {
                mvlog.setCommitSCN(true);
            } else {
                mvlog.setCommitSCN(false);
            }
            if ("YES".equalsIgnoreCase(purgeDeferred)) {
                mvlog.setPurgeType("DEFERRED");
            } else if ("YES".equalsIgnoreCase(purgeAsync)) {
                mvlog.setPurgeType("DEFERRED");
            }
            if (purgeStart != null && !purgeStart.isEmpty()) {
                String pexpr = "TO_DATE('" + purgeStart + "','YYYY-MM-DD HH24:MI:SS')";
                mvlog.setPurgeSWExpression(pexpr);
            }
            if (purgeInterval != null && !purgeInterval.isEmpty()) {
                mvlog.setPurgeNextExpression(purgeInterval);
            }
            this.setColumns(mvlog);
        }
        catch (SQLException e) {
            LOGGER.error("MOHMViewLog.setProperties", e);
            e.printStackTrace();
        }
    }

    private void setColumns(MaterializedViewLogOracle mvlog) {
        TableProxyOracle ltp = mvlog.getLogTableProxy();
        TableProxyOracle mtp = mvlog.getTableProxy();
        if (ltp != null && mtp != null) {
            Table log = ltp.getTable();
            Table master = mtp.getTable();
            Object colIDs = "";
            Object colNames = "";
            for (Column col : master.getElementsCollection()) {
                ContainedObject c;
                if (col.isPKElement() || (c = log.getElementByName(col.getName())) == null) continue;
                if (((String)colIDs).isEmpty()) {
                    colIDs = col.getObjectID();
                    colNames = col.getName();
                    continue;
                }
                colIDs = (String)colIDs + "," + col.getObjectID();
                colNames = (String)colNames + "," + col.getName();
            }
            if (!((String)colIDs).isEmpty()) {
                mvlog.setColumns((String)colIDs);
                mvlog.setColumnNames((String)colNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preGenerateProcessing(Connection sqlConnection, List<DBObject> selectedObject) {
        HashMap<CallSite, DBObject> map = new HashMap<CallSite, DBObject>();
        ArrayList<DBObject> mvlogs = new ArrayList<DBObject>();
        for (DBObject dBObject : selectedObject) {
            if ("TABLE".equalsIgnoreCase(dBObject.getType())) {
                map.put((CallSite)((Object)(dBObject.getSchema() + "." + dBObject.getName())), dBObject);
                continue;
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            mvlogs.add(dBObject);
        }
        Statement statement = null;
        try {
            for (DBObject dBObject : mvlogs) {
                if (map.get(dBObject.getSchema() + "." + dBObject.getName()) == null) {
                    selectedObject.add(new DBObject(true, dBObject.getName(), "TABLE", dBObject.getSchema()));
                }
                if (dBObject.getLogTable() == null || dBObject.getLogTable().isEmpty()) {
                    ResultSet rs = null;
                    try {
                        if (statement == null) {
                            String sql = "SELECT\n    LOG_TABLE\n FROM\n" + (this.dbaUser ? " DBA_MVIEW_LOGS " : " ALL_MVIEW_LOGS ") + " WHERE LOG_OWNER = ? and  MASTER = ?";
                            statement = sqlConnection.prepareStatement(sql);
                        }
                        statement.setString(1, dBObject.getSchema());
                        statement.setString(2, dBObject.getName());
                        rs = statement.executeQuery();
                        if (rs != null && rs.next()) {
                            String log_table = rs.getString(1);
                            dBObject.setLogTable(log_table);
                            rs.close();
                        }
                        Closeables.close((Object)rs);
                    }
                    catch (SQLException e) {
                        LOGGER.error("MOHMViewLog.preGenerateProcessing(): - getting log table name", e);
                        e.printStackTrace();
                    }
                    finally {
                        Closeables.close(rs);
                    }
                }
                if (dBObject.getLogTable() == null || dBObject.getLogTable().isEmpty() || map.get(dBObject.getSchema() + "." + dBObject.getLogTable()) != null) continue;
                selectedObject.add(new DBObject(true, dBObject.getLogTable(), "TABLE", dBObject.getSchema()));
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("MOHMViewLog.preGenerateProcessing(): - statement.close()", sQLException);
                    sQLException.printStackTrace();
                }
            }
        }
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        Table table;
        Iterator it;
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RelationalDesign rd = sd.getPhysicalDesign();
        if (sd != null) {
            if (sd.getMaterializedViewLogSet().size() > 0) {
                for (MaterializedViewLogOracle mvl : sd.getMaterializedViewLogSet()) {
                    Table table2;
                    if (mvl.getLogTableProxy() != null) {
                        mvl.getLogTableProxy().setMarkedGenerate(false);
                        mvl.getLogTableProxy().getTable().setMarkedGenerate(false);
                    }
                    if (!"YES".equalsIgnoreCase(mvl.getPkLogged()) || (table2 = rd.getTableSet().getBySchemaAndName(mvl.getTableSchema(), "RUPD$_" + mvl.getTableName())) == null) continue;
                    table2.setOracleLogTable(true);
                    table2.setTypeID("3");
                    table2.setMarkedGenerate(false);
                }
            } else {
                it = rd.getTableSet().iterator();
                while (it.hasNext()) {
                    table = (Table)it.next();
                    String name = table.getName();
                    if (!name.startsWith("RUPD$_") && !name.startsWith("MLOG$_")) continue;
                    table.setOracleLogTable(true);
                    table.setTypeID("3");
                    table.setMarkedGenerate(false);
                }
            }
        }
        if (!sd.getDesign().getSettings().isImportTables()) {
            it = rd.getTableSet().iterator();
            while (it.hasNext()) {
                table = (Table)it.next();
                table.setMarkedGenerate(false);
            }
        }
    }
}

