/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.metadata.DataGuideRequestProcessor;

public class RequestManager {
    public static String CT_HTML = "text/html";
    public static String CT_CSS = "text/css";
    public static String CT_JSON = "application/json";
    public static String CT_JSON_UTF8 = "application/json;charset=UTF-8";
    public static String CT_TEXT = "text/plain;charset=UTF-8";
    static List<RequestProcessor> processors = new ArrayList<RequestProcessor>();

    public static RequestResult handleRequest(Connection conn, String url, ContentWrapper cw, Map<String, Boolean> options) {
        for (RequestProcessor proc : processors) {
            RequestResult rr = proc.processRequest(conn, url, cw, options);
            if (rr == null || !rr.processed) continue;
            return rr;
        }
        return null;
    }

    public static RequestResult processHelloRequest(Connection conn, String url, ContentWrapper cw, Map<String, Boolean> options) {
        String oper = cw.getParameter("oper");
        if (oper != null && "hello".equalsIgnoreCase(oper)) {
            RequestResult rr = new RequestResult();
            rr.result = "Hello in string";
            rr.contentType = CT_TEXT;
            rr.processed = true;
            return rr;
        }
        if (oper != null && "hello2".equalsIgnoreCase(oper)) {
            RequestResult rr = new RequestResult();
            try {
                cw.getWriter().write("{\"result\":\"Hello in stream\"}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            rr.contentType = CT_JSON_UTF8;
            rr.processed = true;
            return rr;
        }
        return null;
    }

    public static void main(String[] args) {
    }

    static {
        processors.add(RequestManager::processHelloRequest);
        processors.add(DataGuideRequestProcessor::processDataGuideRequest);
    }

    public static class RequestResult {
        public String contentType = CT_JSON_UTF8;
        public String error;
        public String returnCode;
        public String result;
        public boolean needsGzip = false;
        public boolean returnedToStream = false;
        public boolean returnedWriter = false;
        public boolean processed = false;
    }

    public static interface ContentWrapper {
        public OutputStream getOutputStream() throws IOException;

        public Writer getWriter() throws IOException;

        public void setContentType(String var1);

        public String getContentType();

        public InputStream getInputStream() throws IOException;

        public String[] getParameterValues(String var1);

        public Map<String, String[]> getParameterMap();

        public String getParameter(String var1);

        public void setStatus(int var1);

        public void addHeader(String var1, String var2);

        default public void writeBytes(String str) {
            try {
                byte[] b = str.getBytes(StandardCharsets.UTF_8);
                this.getOutputStream().write(b);
            }
            catch (Throwable e) {
                this.logError("Error in writng content ", e);
            }
        }

        public void logError(String var1, Throwable var2);
    }

    public static interface RequestProcessor {
        public RequestResult processRequest(Connection var1, String var2, ContentWrapper var3, Map<String, Boolean> var4);
    }
}

