/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.scheduling.SchedulerDDLGenerator;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SchedulerDDLMaker {
    private StringBuffer contentBuffer;
    private String content;

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private String appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            result = StringUtilities.rtrim(StringUtilities.ltrim(result));
            this.buffer().append(result);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
        }
        return result;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    public void generateDDLContent(List<SchedulerObject> objects) {
        SchedulerDDLGenerator gen = new SchedulerDDLGenerator();
        for (SchedulerObject object : objects) {
            this.appendStatementFor(object, gen);
        }
    }
}

