/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;

public class SSBDropMaterializedViewLogOracle
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof MaterializedViewLogOracle;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        MaterializedViewLogOracle mvLog;
        if (object instanceof MaterializedViewLogOracle && (mvLog = (MaterializedViewLogOracle)object).isDropEnabled()) {
            StorageDesign storageDesign = this.getStorageDesign(object);
            StringBuffer buffer = new StringBuffer();
            SSBDropMaterializedViewLogOracle.appendStringWithSpace(buffer, "DROP");
            SSBDropMaterializedViewLogOracle.appendStringWithSpace(buffer, "MATERIALIZED");
            SSBDropMaterializedViewLogOracle.appendStringWithSpace(buffer, "VIEW");
            SSBDropMaterializedViewLogOracle.appendStringWithSpace(buffer, "LOG");
            SSBDropMaterializedViewLogOracle.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(mvLog));
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            SSBDropMaterializedViewLogOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBDropMaterializedViewLogOracle.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        }
    }
}

