/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.JarURLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import oracle.dbtools.raptor.liquibase.exception.BadConnectionException;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LbCommand;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class LbUtils {
    private static Liquibase _lb = null;
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private static String NL = System.lineSeparator();

    public static void checkConnection(Connection conn) throws BadConnectionException {
        try {
            if (conn == null || !conn.isValid(2)) {
                throw new BadConnectionException("Connection Failed validation make sure you are still connected.");
            }
        }
        catch (SQLException e) {
            throw new BadConnectionException();
        }
    }

    public static String exceptionToString(Exception e) {
        return Throwables.getStackTraceAsString((Throwable)e);
    }

    public static Multimap<String, String> getAllErrors() {
        return LbUtils.getConfig().getAllErrors();
    }

    public static void addError(String file, String error) {
        LbUtils.getConfig().addError(file, error);
    }

    public static String getBanner() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Object myVersion = LiquibaseUtil.getBuildVersionInfo();
        String buildTimeString = LiquibaseUtil.getBuildTime();
        StringBuilder banner = new StringBuilder();
        banner.append(String.format(coreBundle.getString("starting.liquibase.at.timestamp"), dateFormat.format(calendar.getTime())));
        if (StringUtil.isNotEmpty((String)myVersion) && StringUtil.isNotEmpty((String)buildTimeString)) {
            myVersion = (String)myVersion + " #" + LiquibaseUtil.getBuildNumber();
            banner.append(String.format(coreBundle.getString("liquibase.version.builddate"), myVersion, buildTimeString));
        }
        return banner.toString();
    }

    public static boolean getBoolenParameter(String name) {
        try {
            return LbUtils.getContext().getParameterInstance().getParameterAsBoolean("lb.parameters", name);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getBuildTime(Class<?> cl) {
        try {
            String rn = cl.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)cl.getClassLoader().getResource(rn).openConnection();
            Date date = new Date(j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime());
            SimpleDateFormat df2 = new SimpleDateFormat("HHMMSS");
            return df2.format(date);
        }
        catch (Exception e) {
            return "0101";
        }
    }

    public static SqlclConfig getConfig() {
        return (SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue();
    }

    public static ScriptRunnerContext getContext() {
        if (LbUtils.getConfig().getContext() == null) {
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            LbUtils.setContext(ctx);
            LbUtils.getContext().getParameterInstance().putParameterSet("ddl.parms", (Map)SetDDLSettings.getDefaultMap((ScriptRunnerContext)ctx));
            LbUtils.getContext().getParameterInstance().resetParameters("lb.parameters");
            LbUtils.getContext().getParameterInstance().putParameter("lb.parameters", "isSqlCl".toLowerCase(), (Object)"true");
        }
        return LbUtils.getConfig().getContext();
    }

    public static boolean getDDLParameter(String name) {
        String value = (String)LbUtils.getContext().getParameterInstance().getParameter("ddl.parms", name);
        if (value == null) {
            return true;
        }
        return "ON".equals(value);
    }

    public static int getIntParameter(String name) {
        return LbUtils.getContext().getParameterInstance().getParameterAsInt("lb.parameters", name.toLowerCase());
    }

    public static Liquibase getLiquibase() {
        return _lb;
    }

    public static String getParameter(String name) {
        try {
            return LbUtils.getContext().getParameterInstance().getParameterAsString("lb.parameters", name.toLowerCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HashMap<String, Object> getParameters() {
        return LbUtils.getContext().getParameterInstance().getParameters("lb.parameters");
    }

    public static Boolean getTriStateParameter(String name) {
        try {
            return LbUtils.getContext().getParameterInstance().getParameterAsBoolean("lb.parameters", name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSqlClVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public static String getVersion() {
        String myVersion = LiquibaseUtil.getBuildVersionInfo() + " #" + LiquibaseUtil.getBuildNumber();
        String buildTimeString = LiquibaseUtil.getBuildTime();
        StringBuilder sb = new StringBuilder();
        sb.append("Liquibase version:   " + String.format(" %s built at %s", myVersion, buildTimeString));
        sb.append("\nExtension Version:   " + Messages.getString("SQLclVersion.VERSION") + "/23.1.37-" + LbUtils.getBuildTime(LbCommand.class));
        sb.append("\n");
        return sb.toString();
    }

    public static void log(Exception e) {
        Logger log = Logger.getLogger("liquibase");
        log.severe(LbUtils.exceptionToString(e));
        LbUtils.reportIfDebug(LbUtils.exceptionToString(e));
    }

    public static void log(String msg) {
        Logger log = Logger.getLogger("liquibase");
        log.info(msg);
        LbUtils.reportIfDebug(msg);
    }

    public static String mapToString(Map<?, ?> map) {
        return Joiner.on((String)",").withKeyValueSeparator("=").join(map);
    }

    public static boolean outputSchema() {
        if (Scope.getCurrentScope().getDatabase() != null) {
            return Scope.getCurrentScope().getDatabase().getOutputDefaultSchema();
        }
        if (LbUtils.getParameter("output-default-schema") == null) {
            return false;
        }
        return LbUtils.getBoolenParameter("output-default-schema");
    }

    public static String processSchema(String sql, String ObjectOwner) {
        String ret = sql;
        if (!LbUtils.outputSchema()) {
            ret = sql.replaceAll("\"" + ObjectOwner + "\"[.]", "");
            ret = ret.replaceAll(ObjectOwner.toUpperCase() + "[.]", "");
            ret = ret.replaceAll(ObjectOwner.toLowerCase() + "[.]", "");
        } else if (LbUtils.getBoolenParameter("output-default-schema")) {
            String schema = ObjectOwner;
            if (LbUtils.getParameter("default-schema-name") != null) {
                schema = LbUtils.getParameter("default-schema-name");
            }
            ret = sql.replaceAll("\"" + ObjectOwner + "\"[.]", "\"" + schema + "\".");
            ret = ret.replaceAll(ObjectOwner.toUpperCase() + "[.]", schema + ".");
            ret = ret.replaceAll(ObjectOwner.toLowerCase() + "[.]", schema + ".");
        }
        return ret;
    }

    public static void report(Exception e) {
        LbUtils.report(e.getMessage(), true);
    }

    public static void report(Exception e, boolean log) {
        LbUtils.report(LbUtils.exceptionToString(e), true);
    }

    public static void report(String msg, boolean log) {
        if (log) {
            LbUtils.log(msg);
        }
        Scope.getCurrentScope().getUI().sendMessage(msg);
    }

    public static void report(String msg) {
        LbUtils.report(msg, false);
    }

    public static int getErrCount() {
        return LbUtils.getConfig().getErrorCount();
    }

    public static void reportErrors() {
        LbUtils.report(LbUtils.getErrors(), true);
    }

    public static void resetAllParameters() {
        LbUtils.getContext().getParameterInstance().resetParameters("apex.parameters");
        LbUtils.getContext().getParameterInstance().resetParameters("lb.parameters");
    }

    public static void resetErrors() {
        LbUtils.getConfig().resetErrorList();
    }

    public static void setContext(ScriptRunnerContext ctx) {
        LbUtils.getConfig().setContext(ctx);
    }

    public static void setLiquibase(Liquibase lb) {
        _lb = lb;
    }

    public static void setParameter(String name, String value) {
        LbUtils.getContext().getParameterInstance().putParameter("lb.parameters", name.toLowerCase(), (Object)value);
    }

    public static Map<String, String> stringToMap(String mapAsString) {
        return Splitter.on((char)',').withKeyValueSeparator('=').split((CharSequence)mapAsString);
    }

    public static String writeErrorLog() {
        try {
            if (LbUtils.getAllErrors().size() > 0) {
                return LbFileUtils.writeErrorLog(LbUtils.getErrors());
            }
        }
        catch (IOException e) {
            LbUtils.report(Messages.getString("LB_LOGFILE_ERROR"));
            LbUtils.reportIfDebug(LbUtils.exceptionToString(e));
        }
        return null;
    }

    private static String getErrors() {
        Date date = new Date();
        if (LbUtils.getAllErrors().size() <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int fC = 1;
        int eC = 1;
        sb.append(NL + "######## ERROR SUMMARY ##################" + NL);
        sb.append("Run date:    " + date.toString() + NL);
        sb.append("Error cnt:" + LbUtils.getErrCount() + NL + NL);
        for (String key : LbUtils.getAllErrors().keySet()) {
            Collection errs = LbUtils.getAllErrors().get((Object)key);
            eC = 1;
            sb.append("----------------------------" + NL);
            sb.append("File #" + fC++ + ":  " + key + NL);
            sb.append("Errors :" + errs.size() + NL + NL);
            for (String err : errs) {
                sb.append("Error :" + eC++ + NL + err + NL);
            }
            sb.append("----------------------------" + NL);
        }
        return sb.toString();
    }

    private static void reportIfDebug(String msg) {
        if (LbUtils.getBoolenParameter("debug")) {
            Scope.getCurrentScope().getUI().sendMessage(msg);
        }
    }
}

