/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import liquibase.Scope;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import liquibase.util.StringUtil;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class LbFileUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static FileHandler fileHandler;
    private static Level logLevel;
    private static String configuredChannels;
    private static File log;

    public static String getRoot(ScriptRunnerContext ctx, String dirName) {
        Path fpath = Paths.get(ctx.prependCD(dirName), new String[0]);
        Object newDir = dirName;
        int i = 1;
        while (Files.exists(fpath, new LinkOption[0])) {
            newDir = dirName + "_" + i++;
            fpath = Paths.get(ctx.prependCD((String)newDir), new String[0]);
        }
        return newDir;
    }

    public static File getLog() {
        return log;
    }

    public static void setLog(File log) {
        LbFileUtils.log = log;
    }

    public static File getFile(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        Path fpath;
        Path filePath = fpath = Paths.get(fileName, new String[0]);
        int parts = fpath.getNameCount();
        if (parts == 1) {
            String[] pcs = fileName.split("\\.");
            pcs[0] = LbFileUtils.removeIllegalCharacters(pcs[0], true);
            String front = pcs.length > 1 ? pcs[0] : fileName;
            Path out = fileName.contains(LbUtils.getContext().prependCD("")) ? Paths.get(fileName, new String[0]) : Paths.get(LbUtils.getContext().prependCD(""), fileName);
            int i = 1;
            Object oldfront = front;
            String newfront = (String)oldfront + "_" + i;
            while (Files.exists(out, new LinkOption[0])) {
                out = Paths.get(out.toString().replace((CharSequence)oldfront, newfront), new String[0]);
                oldfront = newfront;
                newfront = front + "_" + ++i;
            }
            if (create) {
                if (out.toFile().getParentFile() != null) {
                    out.toFile().getParentFile().mkdirs();
                }
                out.toFile().createNewFile();
            }
            return out.toFile();
        }
        String front = fpath.getName(0).toString();
        int i = 1;
        while (Files.exists(Paths.get(LbUtils.getContext().prependCD(filePath.toString()), new String[0]), new LinkOption[0])) {
            String newFront = front + "_" + i++;
            filePath = Paths.get(fpath.toString().replaceFirst(front, newFront), new String[0]);
        }
        if (!filePath.toString().contains(LbUtils.getContext().prependCD(""))) {
            filePath = Paths.get(ctx.prependCD(filePath.toString()), new String[0]);
        }
        if (create) {
            if (filePath.toFile().getParentFile() != null) {
                filePath.toFile().getParentFile().mkdirs();
            }
            filePath.toFile().createNewFile();
        }
        return filePath.toFile();
    }

    public static String getFileString(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        return LbFileUtils.getFile(ctx, fileName, create).toString();
    }

    public static Path getPath(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        return Paths.get(LbFileUtils.getFile(ctx, fileName, create).toString(), new String[0]);
    }

    public static void setCWD(String path, ScriptRunnerContext ctx) {
        String cdPath = path.trim();
        if ((cdPath.startsWith("'") && cdPath.endsWith("'") || cdPath.startsWith("\"") && cdPath.endsWith("\"")) && cdPath.length() > 2) {
            cdPath = cdPath.substring(1, cdPath.length() - 1);
        }
        if (System.getProperty("os.name").startsWith("Windows") && cdPath.startsWith("/") && cdPath.length() > 3 && ":".equals(cdPath.substring(2, 3))) {
            cdPath = cdPath.substring(1);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            cdPath = cdPath.replace("/", "\\");
        }
        if (!System.getProperty("os.name").startsWith("Windows") && cdPath.startsWith("~")) {
            cdPath = cdPath.replaceFirst("~", System.getProperty("user.home"));
        }
        Path currentDir = Paths.get((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]);
        Path newPath = null;
        try {
            newPath = currentDir.resolve(cdPath);
        }
        catch (Exception e) {
            ctx.write(MessageFormat.format(Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
        }
        try {
            newPath = newPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            // empty catch block
        }
        File f = newPath.toFile();
        if (cdPath != null && f.isDirectory()) {
            String cPath = null;
            try {
                cPath = new File(newPath.toString()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ctx.putProperty("script.runner.cd_command", (Object)(cPath != null ? cPath : cdPath));
            ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), cPath != null ? cPath : cdPath);
        } else {
            ctx.write(MessageFormat.format(Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
        }
    }

    public static String writeErrorLog(String data) throws IOException {
        File file = LbFileUtils.getLogFile(true);
        file.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        return file.toString().replace(LbUtils.getContext().prependCD(""), "");
    }

    public static File getLogFile(boolean errorLog) throws IOException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        File log = null;
        if (errorLog) {
            log = Paths.get(LbUtils.getContext().prependCD("sqlcl-lb-error" + timestamp.getTime() + ".log"), new String[0]).toFile();
            log.createNewFile();
            return log;
        }
        log = Paths.get(LbUtils.getContext().prependCD("sqlcl-lb-" + timestamp.getTime() + ".log"), new String[0]).toFile();
        log.createNewFile();
        return log;
    }

    public static final String removeIllegalCharacters(String name, boolean singleSpaces) {
        String safe = name.trim();
        if ((safe = safe.replaceAll("[\\/|\\\\|\\*|\\:|\\||\"|'|\\<|\\>|\\{|\\}|\\?|\\%|,]", "")).endsWith("_")) {
            safe = safe.substring(0, safe.length() - 1);
        }
        safe = safe.replaceAll("\\s+", "_");
        if (singleSpaces) {
            safe = safe.replaceAll("_{2,}", "_");
        }
        return safe;
    }

    public static BufferedWriter getWriter(File file) throws IOException {
        try {
            Path path = Paths.get(file.toString(), new String[0]);
            return new BufferedWriter(new FileWriter(path.toString()));
        }
        catch (Exception e) {
            LbUtils.log(e);
            LbUtils.report("unable to get file path for :" + file.toString());
            return null;
        }
    }

    public static String writeFile(ScriptRunnerContext ctx, String fileName, String data) throws IOException, SQLException {
        File file = LbFileUtils.getFile(LbUtils.getContext(), fileName, true);
        BufferedWriter writer = LbFileUtils.getWriter(file);
        writer.write(data);
        writer.close();
        if (LbUtils.getBoolenParameter("sql") && !"controller.xml".equals(fileName)) {
            BufferedWriter sqlwriter = LbFileUtils.getWriter(Paths.get(file.toString().replace(".xml", ".sql"), new String[0]).toFile());
            if (SchemaGenerator.ddlChangeTypes.containsKey(LbUtils.getParameter("object-type"))) {
                if (LbUtils.getDDLParameter("EMIT_SCHEMA")) {
                    sqlwriter.write(LbUtils.getParameter("ddl"));
                } else {
                    sqlwriter.write(LbUtils.processSchema(LbUtils.getParameter("ddl"), ctx.getCurrentConnection().getSchema()));
                }
            } else {
                String sql = DbmsMetaUtils.getDdlFromSxml(LbUtils.getContext().getCurrentConnection(), LbUtils.getParameter("ddl"), LbUtils.getParameter("object-type"));
                if (LbUtils.getDDLParameter("EMIT_SCHEMA")) {
                    sqlwriter.write(sql);
                } else {
                    sqlwriter.write(LbUtils.processSchema(sql, ctx.getCurrentConnection().getSchema()));
                }
            }
            sqlwriter.close();
        }
        return file.toString().replace(LbUtils.getContext().prependCD(""), "");
    }

    public static void writeInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file, false);){
            int read;
            byte[] bytes = new byte[8192];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    public static void configureLogging(Level level, File logFile) throws IOException {
        ArrayList<String> channels;
        logLevel = level;
        log = logFile;
        JavaLogService logService = (JavaLogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        logService.setParent(liquibaseLogger);
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        Logger rootLogger = Logger.getLogger("");
        Level cliLogLevel = logLevel;
        if (log != null) {
            if (fileHandler == null) {
                fileHandler = new FileHandler(log.toString(), true);
                fileHandler.setFormatter(new SimpleFormatter());
                rootLogger.addHandler(fileHandler);
            }
            fileHandler.setLevel(logLevel);
            cliLogLevel = Level.OFF;
        }
        if ("all".equalsIgnoreCase(configuredChannels)) {
            channels = new ArrayList<String>(Arrays.asList("", "liquibase"));
        } else {
            channels = StringUtil.splitAndTrim((String)configuredChannels, (String)",");
            if (logLevel == Level.OFF) {
                channels.add("");
            }
        }
        for (String channel : channels) {
            if ("all".equalsIgnoreCase(channel)) {
                channel = "";
            }
            Logger.getLogger(channel).setLevel(logLevel);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(cliLogLevel);
        }
        LbUtils.log("Logging enabled at LEVEL");
    }

    public static void cleanup() {
        if (fileHandler != null) {
            fileHandler.flush();
            fileHandler.close();
        }
        fileHandler = null;
        LbUtils.resetErrors();
    }

    public static boolean isAncestorOf(Path parent, Path child) {
        Path absoluteParent = parent.toAbsolutePath().normalize();
        Path absoluteChild = child.toAbsolutePath().normalize();
        if (absoluteParent.getNameCount() >= absoluteChild.getNameCount()) {
            return false;
        }
        Path immediateParent = absoluteChild.getParent();
        if (immediateParent == null) {
            return false;
        }
        return LbFileUtils.isSameFileAs(absoluteParent, immediateParent) || LbFileUtils.isAncestorOf(absoluteParent, immediateParent);
    }

    public static boolean isSameFileAs(Path path, Path path2) {
        try {
            return Files.isSameFile(path, path2);
        }
        catch (IOException ioe) {
            return path.toAbsolutePath().normalize().equals(path2.toAbsolutePath().normalize());
        }
    }

    static {
        configuredChannels = "all";
    }
}

