/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import liquibase.ext.ora.change.AbstractOracleChange;
import liquibase.ext.ora.generator.RunApexScriptGenerator;
import liquibase.ext.ora.statement.RunApexScriptStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="runApexScript", description="Run Apex Script", priority=1)
public class RunApexScriptChange
extends AbstractCommonPlSqlChange {
    public RunApexScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public RunApexScriptChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SCRIPT");
    }

    public CheckSum generateCheckSum() {
        RunApexScriptStatement stmt = new RunApexScriptStatement(this);
        try {
            return CheckSum.compute((String)RunApexScriptGenerator.getSqlString(stmt));
        }
        catch (Exception e) {
            return null;
        }
    }

    public SqlStatement[] generateStatements(Database database) {
        RunApexScriptStatement stmt = new RunApexScriptStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

