/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.net.URI;
import java.net.URISyntaxException;
import oracle.dbtools.util.Logger;

public final class URIUtils {
    private static final String DIR = "/";

    public static URI newURI(String spec) {
        return URIUtils.newURI(spec, false);
    }

    public static URI newURI(String spec, boolean forceDir) {
        if (spec == null) {
            return null;
        }
        if (forceDir) {
            spec = URIUtils.ensureDir(spec);
        }
        try {
            return new URI(spec);
        }
        catch (URISyntaxException e) {
            Logger.severe(URIUtils.class, e);
            return null;
        }
    }

    public static URI newURI(String scheme, String host, int port, String path) {
        return URIUtils.newURI(scheme, host, port, path);
    }

    public static URI newURI(String scheme, String host, int port, String path, boolean forceDir) {
        if (forceDir) {
            path = URIUtils.ensureDir(path);
        }
        try {
            return new URI(scheme, null, host, port, path, null, null);
        }
        catch (URISyntaxException e) {
            Logger.severe(URIUtils.class, e);
            return null;
        }
    }

    public static URI newURI(URI base, String path) {
        return URIUtils.newURI(base, path, false);
    }

    public static URI newURI(URI base, String path, boolean forceDir) {
        if (forceDir) {
            path = URIUtils.ensureDir(path);
        }
        return base.resolve(path);
    }

    private static String ensureDir(String path) {
        return path == null ? DIR : (path.endsWith(DIR) ? path : path + DIR);
    }
}

